/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.InternalHashCodeMap;
import java.util.InternalStringMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.JsUtils;

abstract class AbstractHashMap<K, V>
extends AbstractMap<K, V> {
    private InternalHashCodeMap<K, V> hashCodeMap;
    private InternalStringMap<K, V> stringMap;
    int modCount;

    public AbstractHashMap() {
        this.reset();
    }

    public AbstractHashMap(int ignored) {
        this(ignored, 0.0f);
    }

    public AbstractHashMap(int ignored, float alsoIgnored) {
        InternalPreconditions.checkArgument(ignored >= 0, "Negative initial capacity");
        InternalPreconditions.checkArgument(alsoIgnored >= 0.0f, "Non-positive load factor");
        this.reset();
    }

    public AbstractHashMap(Map<? extends K, ? extends V> toBeCopied) {
        this.reset();
        this.putAll(toBeCopied);
    }

    @Override
    public void clear() {
        this.reset();
    }

    private void reset() {
        this.hashCodeMap = new InternalHashCodeMap(this);
        this.stringMap = new InternalStringMap(this);
        this.structureChanged();
    }

    void structureChanged() {
        if (!InternalPreconditions.isApiChecked()) {
            return;
        }
        ++this.modCount;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String ? this.stringMap.contains((String)JsUtils.uncheckedCast(key)) : this.hashCodeMap.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(value, this.stringMap) || this.containsValue(value, this.hashCodeMap);
    }

    private boolean containsValue(Object value, Iterable<Map.Entry<K, V>> entries) {
        for (Map.Entry<K, V> entry : entries) {
            if (!this.equals(value, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public V get(Object key) {
        return key instanceof String ? this.stringMap.get((String)JsUtils.uncheckedCast(key)) : AbstractHashMap.getEntryValueOrNull(this.hashCodeMap.getEntry(key));
    }

    @Override
    public V put(K key, V value) {
        return key instanceof String ? this.stringMap.put((String)JsUtils.uncheckedCast(key), value) : this.hashCodeMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return key instanceof String ? this.stringMap.remove((String)JsUtils.uncheckedCast(key)) : this.hashCodeMap.remove(key);
    }

    @Override
    public int size() {
        return this.hashCodeMap.size() + this.stringMap.size();
    }

    abstract boolean equals(Object var1, Object var2);

    abstract int getHashCode(Object var1);

    private final class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, V>> stringMapEntries;
        private Iterator<Map.Entry<K, V>> current;
        private Iterator<Map.Entry<K, V>> last;
        private boolean hasNext;
        private int lastModCount;

        private EntrySetIterator() {
            this.stringMapEntries = AbstractHashMap.this.stringMap.iterator();
            this.current = this.stringMapEntries;
            this.hasNext = this.computeHasNext();
            this.lastModCount = AbstractHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        private boolean computeHasNext() {
            if (this.current.hasNext()) {
                return true;
            }
            if (this.current != this.stringMapEntries) {
                return false;
            }
            this.current = AbstractHashMap.this.hashCodeMap.iterator();
            return this.current.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            InternalPreconditions.checkConcurrentModification(AbstractHashMap.this.modCount, this.lastModCount);
            InternalPreconditions.checkElement(this.hasNext());
            this.last = this.current;
            Map.Entry rv = this.current.next();
            this.hasNext = this.computeHasNext();
            return rv;
        }

        @Override
        public void remove() {
            InternalPreconditions.checkState(this.last != null);
            InternalPreconditions.checkConcurrentModification(AbstractHashMap.this.modCount, this.lastModCount);
            this.last.remove();
            this.last = null;
            this.hasNext = this.computeHasNext();
            this.lastModCount = AbstractHashMap.this.modCount;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            AbstractHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                return AbstractHashMap.this.containsEntry((Map.Entry)o);
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public boolean remove(Object entry) {
            if (this.contains(entry)) {
                Object key = ((Map.Entry)entry).getKey();
                AbstractHashMap.this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return AbstractHashMap.this.size();
        }
    }
}

