/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javaemul.internal.InternalPreconditions;
import jsinterop.annotations.JsNonNull;

public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected int modCount;

    protected AbstractList() {
    }

    @Override
    public boolean add(E obj) {
        this.add(this.size(), obj);
        return true;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        InternalPreconditions.checkNotNull(c);
        boolean changed = false;
        for (E e : c) {
            this.add(index++, e);
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List other = (List)o;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator iterOther = other.iterator();
        for (E elem : this) {
            Object elemOther;
            if (Objects.equals(elem, elemOther = iterOther.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Collections.hashCode(this);
    }

    @Override
    public int indexOf(Object toFind) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!Objects.equals(toFind, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public int lastIndexOf(Object toFind) {
        for (int i = this.size() - 1; i > -1; --i) {
            if (!Objects.equals(toFind, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int from) {
        return new ListIteratorImpl(from);
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @JsNonNull List<E> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    protected void removeRange(int fromIndex, int endIndex) {
        ListIterator<E> iter = this.listIterator(fromIndex);
        for (int i = fromIndex; i < endIndex; ++i) {
            iter.next();
            iter.remove();
        }
    }

    private static class SubList<E>
    extends AbstractList<E> {
        private final List<E> wrapped;
        private final int fromIndex;
        private int size;

        public SubList(List<E> wrapped, int fromIndex, int toIndex) {
            InternalPreconditions.checkCriticalPositionIndexes(fromIndex, toIndex, wrapped.size());
            this.wrapped = wrapped;
            this.fromIndex = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public void add(int index, E element) {
            InternalPreconditions.checkPositionIndex(index, this.size);
            this.wrapped.add(this.fromIndex + index, element);
            ++this.size;
        }

        @Override
        public E get(int index) {
            InternalPreconditions.checkElementIndex(index, this.size);
            return this.wrapped.get(this.fromIndex + index);
        }

        @Override
        public E remove(int index) {
            InternalPreconditions.checkElementIndex(index, this.size);
            E result = this.wrapped.remove(this.fromIndex + index);
            --this.size;
            return result;
        }

        @Override
        public E set(int index, E element) {
            InternalPreconditions.checkElementIndex(index, this.size);
            return this.wrapped.set(this.fromIndex + index, element);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private final class ListIteratorImpl
    extends IteratorImpl
    implements ListIterator<E> {
        private ListIteratorImpl() {
        }

        private ListIteratorImpl(int start) {
            InternalPreconditions.checkPositionIndex(start, AbstractList.this.size());
            this.i = start;
        }

        @Override
        public void add(E o) {
            AbstractList.this.add(this.i, o);
            ++this.i;
            this.last = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.i > 0;
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public E previous() {
            InternalPreconditions.checkElement(this.hasPrevious());
            this.last = --this.i;
            return AbstractList.this.get(this.i);
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public void set(E o) {
            InternalPreconditions.checkState(this.last != -1);
            AbstractList.this.set(this.last, o);
        }
    }

    private class IteratorImpl
    implements Iterator<E> {
        int i = 0;
        int last = -1;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.i < AbstractList.this.size();
        }

        @Override
        public E next() {
            InternalPreconditions.checkElement(this.hasNext());
            this.last = this.i++;
            return AbstractList.this.get(this.last);
        }

        @Override
        public void remove() {
            InternalPreconditions.checkState(this.last != -1);
            AbstractList.this.remove(this.last);
            this.i = this.last;
            this.last = -1;
        }
    }
}

