/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javaemul.internal.InternalPreconditions;
import jsinterop.annotations.JsNonNull;

public abstract class AbstractMap<K, V>
implements Map<K, V> {
    protected AbstractMap() {
    }

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.implFindEntry(key, false) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry entry : this.entrySet()) {
            Object v = entry.getValue();
            if (!Objects.equals(value, v)) continue;
            return true;
        }
        return false;
    }

    boolean containsEntry(Map.Entry<?, ?> entry) {
        V ourValue;
        Object key = entry.getKey();
        Object value = entry.getValue();
        if (!Objects.equals(value, ourValue = this.get(key))) {
            return false;
        }
        return ourValue != null || this.containsKey(key);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)obj;
        if (this.size() != otherMap.size()) {
            return false;
        }
        for (Map.Entry entry : otherMap.entrySet()) {
            if (this.containsEntry(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public V get(Object key) {
        return AbstractMap.getEntryValueOrNull(this.implFindEntry(key, false));
    }

    public int hashCode() {
        return Collections.hashCode(this.entrySet());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public @JsNonNull Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public void clear() {
                AbstractMap.this.clear();
            }

            @Override
            public boolean contains(Object key) {
                return AbstractMap.this.containsKey(key);
            }

            @Override
            public Iterator<K> iterator() {
                final Iterator outerIter = AbstractMap.this.entrySet().iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return outerIter.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)outerIter.next();
                        return entry.getKey();
                    }

                    @Override
                    public void remove() {
                        outerIter.remove();
                    }
                };
            }

            @Override
            public boolean remove(Object key) {
                if (AbstractMap.this.containsKey(key)) {
                    AbstractMap.this.remove(key);
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                return AbstractMap.this.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        InternalPreconditions.checkNotNull(map);
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return AbstractMap.getEntryValueOrNull(this.implFindEntry(key, true));
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        for (Map.Entry entry : this.entrySet()) {
            joiner.add(this.toString(entry));
        }
        return joiner.toString();
    }

    private String toString(Map.Entry<K, V> entry) {
        return this.toString(entry.getKey()) + "=" + this.toString(entry.getValue());
    }

    private String toString(Object o) {
        return o == this ? "(this Map)" : String.valueOf(o);
    }

    @Override
    public @JsNonNull Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public void clear() {
                AbstractMap.this.clear();
            }

            @Override
            public boolean contains(Object value) {
                return AbstractMap.this.containsValue(value);
            }

            @Override
            public Iterator<V> iterator() {
                final Iterator outerIter = AbstractMap.this.entrySet().iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return outerIter.hasNext();
                    }

                    @Override
                    public V next() {
                        Map.Entry entry = (Map.Entry)outerIter.next();
                        return entry.getValue();
                    }

                    @Override
                    public void remove() {
                        outerIter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractMap.this.size();
            }
        };
    }

    static <K, V> K getEntryKeyOrNull(Map.Entry<K, V> entry) {
        return entry == null ? null : (K)entry.getKey();
    }

    static <K, V> V getEntryValueOrNull(Map.Entry<K, V> entry) {
        return entry == null ? null : (V)entry.getValue();
    }

    private Map.Entry<K, V> implFindEntry(Object key, boolean remove) {
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object k = entry.getKey();
            if (!Objects.equals(key, k)) continue;
            if (remove) {
                entry = new SimpleEntry(entry.getKey(), entry.getValue());
                iter.remove();
            }
            return entry;
        }
        return null;
    }

    private static abstract class AbstractEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        protected AbstractEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)other;
            return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static class SimpleImmutableEntry<K, V>
    extends AbstractEntry<K, V> {
        public SimpleImmutableEntry(K key, V value) {
            super(key, value);
        }

        public SimpleImmutableEntry(Map.Entry<? extends K, ? extends V> entry) {
            super(entry.getKey(), entry.getValue());
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class SimpleEntry<K, V>
    extends AbstractEntry<K, V> {
        public SimpleEntry(K key, V value) {
            super(key, value);
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            super(entry.getKey(), entry.getValue());
        }
    }
}

