/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import javaemul.internal.ArrayHelper;
import javaemul.internal.InternalPreconditions;

public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable {
    private static final int MIN_INITIAL_CAPACITY = 8;
    private E[] array;
    private int head;
    private int tail;

    private static void checkConcurrentModification(boolean expression) {
        if (!expression) {
            throw new ConcurrentModificationException();
        }
    }

    private static int nextArrayLength(int numElements) {
        return ArrayDeque.nextPowerOfTwo(Math.max(8, numElements));
    }

    private static int nextPowerOfTwo(int num) {
        return Integer.highestOneBit(num) << 1;
    }

    public ArrayDeque() {
        this.array = new Object[8];
    }

    public ArrayDeque(int numElements) {
        this.array = new Object[ArrayDeque.nextArrayLength(numElements)];
    }

    public ArrayDeque(Collection<? extends E> c) {
        this(c.size());
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public void addFirst(E e) {
        InternalPreconditions.checkCriticalNotNull(e);
        this.head = this.head - 1 & this.array.length - 1;
        this.array[this.head] = e;
        this.ensureCapacity();
    }

    @Override
    public void addLast(E e) {
        InternalPreconditions.checkCriticalNotNull(e);
        this.array[this.tail] = e;
        this.tail = this.tail + 1 & this.array.length - 1;
        this.ensureCapacity();
    }

    @Override
    public void clear() {
        if (this.head == this.tail) {
            return;
        }
        this.array = new Object[8];
        this.head = 0;
        this.tail = 0;
    }

    public Object clone() {
        return new ArrayDeque<E>(this);
    }

    @Override
    public boolean contains(Object o) {
        return this.contains(this.iterator(), o);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIteratorImpl();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E getFirst() {
        E e = this.peekFirstElement();
        InternalPreconditions.checkElement(e != null);
        return e;
    }

    @Override
    public E getLast() {
        E e = this.peekLastElement();
        InternalPreconditions.checkElement(e != null);
        return e;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E peekFirst() {
        return this.peekFirstElement();
    }

    @Override
    public E peekLast() {
        return this.peekLastElement();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E pollFirst() {
        E e = this.peekFirstElement();
        if (e == null) {
            return null;
        }
        this.array[this.head] = null;
        this.head = this.head + 1 & this.array.length - 1;
        return e;
    }

    @Override
    public E pollLast() {
        E e = this.peekLastElement();
        if (e == null) {
            return null;
        }
        this.tail = this.tail - 1 & this.array.length - 1;
        this.array[this.tail] = null;
        return e;
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public E removeFirst() {
        E e = this.pollFirst();
        InternalPreconditions.checkElement(e != null);
        return e;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(this.iterator(), o);
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        InternalPreconditions.checkElement(e != null);
        return e;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.remove(this.descendingIterator(), o);
    }

    @Override
    public int size() {
        return this.tail - this.head & this.array.length - 1;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 272);
    }

    @Override
    public <T> T[] toArray(T[] out) {
        int size = this.size();
        if (out.length < size) {
            out = ArrayHelper.createFrom(out, size);
        }
        this.copyElements(out, size);
        if (out.length > size) {
            out[size] = null;
        }
        return out;
    }

    private boolean contains(Iterator<E> it, Object o) {
        if (o == null) {
            return false;
        }
        while (it.hasNext()) {
            if (!o.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    private boolean remove(Iterator<E> it, Object o) {
        if (this.contains(it, o)) {
            it.remove();
            return true;
        }
        return false;
    }

    private E peekFirstElement() {
        return this.array[this.head];
    }

    private E peekLastElement() {
        return this.array[this.tail - 1 & this.array.length - 1];
    }

    private void copyElements(Object[] dest, int count) {
        int mask = this.array.length - 1;
        int i = this.head;
        for (int dstIdx = 0; dstIdx < count; ++dstIdx) {
            dest[dstIdx] = this.array[i];
            i = i + 1 & mask;
        }
    }

    private void ensureCapacity() {
        if (this.head != this.tail) {
            return;
        }
        int numElements = this.array.length;
        int newLength = ArrayDeque.nextArrayLength(numElements);
        if (this.head != 0) {
            Object[] newArray = ArrayHelper.createFrom(this.array, newLength);
            this.copyElements(newArray, numElements);
            this.array = newArray;
            this.head = 0;
        } else {
            this.array = ArrayHelper.setLength(this.array, newLength);
        }
        this.tail = numElements;
    }

    private int removeAtIndex(int i) {
        int mask = this.array.length - 1;
        int headDistance = i - this.head & mask;
        int tailDistance = this.tail - i & mask;
        int size = this.tail - this.head & mask;
        ArrayDeque.checkConcurrentModification(headDistance < size);
        if (headDistance >= tailDistance) {
            this.shiftLeftAtIndex(i);
            return -1;
        }
        this.shiftRightAtIndex(i);
        return 1;
    }

    private void shiftLeftAtIndex(int i) {
        int mask = this.array.length - 1;
        this.tail = this.tail - 1 & mask;
        while (i != this.tail) {
            int nextOffset = i + 1 & mask;
            this.array[i] = this.array[nextOffset];
            i = nextOffset;
        }
        this.array[this.tail] = null;
    }

    private void shiftRightAtIndex(int i) {
        int mask = this.array.length - 1;
        while (i != this.head) {
            int prevOffset = i - 1 & mask;
            this.array[i] = this.array[prevOffset];
            i = prevOffset;
        }
        this.array[this.head] = null;
        this.head = this.head + 1 & mask;
    }

    private final class DescendingIteratorImpl
    implements Iterator<E> {
        private int currentIndex;
        private int fence;
        private int lastIndex;

        private DescendingIteratorImpl() {
            this.currentIndex = ArrayDeque.this.tail;
            this.fence = ArrayDeque.this.head;
            this.lastIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != this.fence;
        }

        @Override
        public E next() {
            InternalPreconditions.checkCriticalElement(this.hasNext());
            this.currentIndex = this.currentIndex - 1 & ArrayDeque.this.array.length - 1;
            Object e = ArrayDeque.this.array[this.currentIndex];
            ArrayDeque.checkConcurrentModification(this.fence == ArrayDeque.this.head && e != null);
            this.lastIndex = this.currentIndex;
            return e;
        }

        @Override
        public void remove() {
            InternalPreconditions.checkState(this.lastIndex >= 0);
            if (ArrayDeque.this.removeAtIndex(this.lastIndex) > 0) {
                this.currentIndex = this.currentIndex + 1 & ArrayDeque.this.array.length - 1;
                this.fence = ArrayDeque.this.head;
            }
            this.lastIndex = -1;
        }
    }

    private final class IteratorImpl
    implements Iterator<E> {
        private int currentIndex;
        private int fence;
        private int lastIndex;

        private IteratorImpl() {
            this.currentIndex = ArrayDeque.this.head;
            this.fence = ArrayDeque.this.tail;
            this.lastIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != this.fence;
        }

        @Override
        public E next() {
            InternalPreconditions.checkCriticalElement(this.hasNext());
            Object e = ArrayDeque.this.array[this.currentIndex];
            ArrayDeque.checkConcurrentModification(this.fence == ArrayDeque.this.tail && e != null);
            this.lastIndex = this.currentIndex;
            this.currentIndex = this.currentIndex + 1 & ArrayDeque.this.array.length - 1;
            return e;
        }

        @Override
        public void remove() {
            InternalPreconditions.checkState(this.lastIndex >= 0);
            if (ArrayDeque.this.removeAtIndex(this.lastIndex) < 0) {
                this.currentIndex = this.currentIndex - 1 & ArrayDeque.this.array.length - 1;
                this.fence = ArrayDeque.this.tail;
            }
            this.lastIndex = -1;
        }
    }
}

