/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import javaemul.internal.ArrayHelper;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.LongUtils;

public class BitSet
implements Cloneable {
    private static final int WORD_MASK = Integer.MAX_VALUE;
    private static final int BITS_PER_WORD = 31;
    private int[] array;
    private int wordLength;

    public BitSet() {
        this.array = new int[0];
    }

    public BitSet(int nbits) {
        InternalPreconditions.checkArraySize(nbits);
        int length = BitSet.wordIndex(nbits - 1) + 1;
        this.array = ArrayHelper.setLength(new int[0], length);
    }

    private BitSet(int[] array) {
        this.array = array;
        this.wordLength = array.length;
        this.updateWordLength();
    }

    private void updateWordLength() {
        int i;
        for (i = this.wordLength - 1; i >= 0 && BitSet.wordAt(this.array, i) == 0; --i) {
        }
        this.wordLength = i + 1;
    }

    private static void checkIndex(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < 0 || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex);
        }
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex / 31;
    }

    private static int bitIndex(int wordIndex) {
        return wordIndex * 31;
    }

    private static int bitOffset(int bitIndex) {
        return bitIndex % 31;
    }

    private void setInternal(int fromIndex, int toIndex) {
        int first = BitSet.wordIndex(fromIndex);
        int last = BitSet.wordIndex(toIndex);
        this.maybeGrowArrayToIndex(last);
        int startBit = BitSet.bitOffset(fromIndex);
        int endBit = BitSet.bitOffset(toIndex);
        if (first == last) {
            BitSet.maskInWord(this.array, first, startBit, endBit);
        } else {
            BitSet.maskInWord(this.array, first, startBit, 31);
            Arrays.fill(this.array, first + 1, last, Integer.MAX_VALUE);
            BitSet.maskInWord(this.array, last, 0, endBit);
        }
        if (last >= this.wordLength) {
            this.wordLength = last + 1;
        }
    }

    private void maybeGrowArrayToIndex(int newMaxIndex) {
        int newLength = newMaxIndex + 1;
        if (newLength > this.array.length) {
            this.array = ArrayHelper.grow(this.array, newLength);
        }
    }

    private static void flipMaskedWord(int[] array, int index, int from, int to) {
        if (from == to) {
            return;
        }
        to = 32 - to;
        int word = BitSet.wordAt(array, index);
        array[index] = (word ^= -1 >>> from << from + to >>> to) & Integer.MAX_VALUE;
    }

    private static void maskInWord(int[] array, int index, int from, int to) {
        if (from == to) {
            return;
        }
        to = 32 - to;
        int word = BitSet.wordAt(array, index);
        array[index] = (word |= -1 >>> from << from + to >>> to) & Integer.MAX_VALUE;
    }

    private static void maskOutWord(int[] array, int index, int from, int to) {
        if (from == to) {
            return;
        }
        int word = BitSet.wordAt(array, index);
        if (word == 0) {
            return;
        }
        int mask = from != 0 ? -1 >>> 32 - from : 0;
        if (to != 32) {
            mask |= -1 << to;
        }
        array[index] = (word &= mask) & Integer.MAX_VALUE;
    }

    private static int wordAt(int[] array, int index) {
        return array[index] | 0;
    }

    public void and(BitSet set) {
        if (this == set) {
            return;
        }
        int limit = Math.min(this.wordLength, set.wordLength);
        for (int index = 0; index < limit; ++index) {
            int word = BitSet.wordAt(this.array, index);
            if (word == 0) continue;
            this.array[index] = word & BitSet.wordAt(set.array, index);
        }
        Arrays.fill(this.array, limit, this.wordLength, 0);
        this.updateWordLength();
    }

    public void andNot(BitSet set) {
        if (this == set) {
            this.clear();
            return;
        }
        int limit = Math.min(this.wordLength, set.wordLength);
        for (int index = 0; index < limit; ++index) {
            int word;
            int otherWord = BitSet.wordAt(set.array, index);
            if (otherWord == 0 || (word = BitSet.wordAt(this.array, index)) == 0) continue;
            this.array[index] = word & (~otherWord & Integer.MAX_VALUE);
        }
        this.updateWordLength();
    }

    public int cardinality() {
        int count = 0;
        for (int i = 0; i < this.wordLength; ++i) {
            count += Integer.bitCount(BitSet.wordAt(this.array, i));
        }
        return count;
    }

    public void clear() {
        Arrays.fill(this.array, 0, this.wordLength, 0);
        this.wordLength = 0;
    }

    public void clear(int bitIndex) {
        BitSet.checkIndex(bitIndex);
        int index = BitSet.wordIndex(bitIndex);
        if (index >= this.wordLength) {
            return;
        }
        int word = BitSet.wordAt(this.array, index);
        if (word != 0) {
            this.array[index] = word & ~(1 << BitSet.bitOffset(bitIndex)) & Integer.MAX_VALUE;
        }
        this.updateWordLength();
    }

    public void clear(int fromIndex, int toIndex) {
        BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int first = BitSet.wordIndex(fromIndex);
        if (first >= this.wordLength) {
            return;
        }
        int last = BitSet.wordIndex(toIndex);
        if (last >= this.wordLength) {
            toIndex = this.length();
            last = BitSet.wordIndex(toIndex);
            this.wordLength = first + 1;
        }
        int startBit = BitSet.bitOffset(fromIndex);
        int endBit = BitSet.bitOffset(toIndex);
        if (first == last) {
            BitSet.maskOutWord(this.array, first, startBit, endBit);
        } else {
            BitSet.maskOutWord(this.array, first, startBit, 31);
            Arrays.fill(this.array, first + 1, last, 0);
            BitSet.maskOutWord(this.array, last, 0, endBit);
        }
        this.updateWordLength();
    }

    public Object clone() {
        return new BitSet(Arrays.copyOf(this.array, this.wordLength));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BitSet)) {
            return false;
        }
        BitSet other = (BitSet)obj;
        if (this.wordLength != other.wordLength) {
            return false;
        }
        for (int index = 0; index < this.wordLength; ++index) {
            if (BitSet.wordAt(this.array, index) == BitSet.wordAt(other.array, index)) continue;
            return false;
        }
        return true;
    }

    public void flip(int bitIndex) {
        BitSet.checkIndex(bitIndex);
        int index = BitSet.wordIndex(bitIndex);
        int offset = BitSet.bitOffset(bitIndex);
        this.maybeGrowArrayToIndex(index);
        int word = BitSet.wordAt(this.array, index);
        word = (word >>> offset & 1) == 1 ? (word &= ~(1 << offset)) : (word |= 1 << offset);
        this.array[index] = word & Integer.MAX_VALUE;
        if (index >= this.wordLength) {
            this.wordLength = index + 1;
        } else {
            this.updateWordLength();
        }
    }

    public void flip(int fromIndex, int toIndex) {
        BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int length = this.length();
        if (fromIndex >= length) {
            this.setInternal(fromIndex, toIndex);
            return;
        }
        if (toIndex >= length) {
            this.setInternal(length, toIndex);
            toIndex = length;
        }
        int first = BitSet.wordIndex(fromIndex);
        int last = BitSet.wordIndex(toIndex);
        int startBit = BitSet.bitOffset(fromIndex);
        int endBit = BitSet.bitOffset(toIndex);
        if (first == last) {
            BitSet.flipMaskedWord(this.array, first, startBit, endBit);
        } else {
            BitSet.flipMaskedWord(this.array, first, startBit, 31);
            for (int i = first + 1; i < last; ++i) {
                this.array[i] = ~BitSet.wordAt(this.array, i) & Integer.MAX_VALUE;
            }
            BitSet.flipMaskedWord(this.array, last, 0, endBit);
        }
        this.updateWordLength();
    }

    public boolean get(int bitIndex) {
        BitSet.checkIndex(bitIndex);
        int index = BitSet.wordIndex(bitIndex);
        return index < this.wordLength && (BitSet.wordAt(this.array, index) >>> BitSet.bitOffset(bitIndex) & 1) == 1;
    }

    public BitSet get(int fromIndex, int toIndex) {
        BitSet.checkRange(fromIndex, toIndex);
        int length = this.length();
        if (length <= fromIndex || fromIndex == toIndex) {
            return new BitSet(0);
        }
        toIndex = Math.min(toIndex, length);
        int rightShift = BitSet.bitOffset(fromIndex);
        if (rightShift == 0) {
            int subFrom = BitSet.wordIndex(fromIndex);
            int subTo = BitSet.wordIndex(toIndex + 31);
            int[] subArray = Arrays.copyOfRange(this.array, subFrom, subTo);
            int leftOvers = BitSet.bitOffset(toIndex);
            BitSet.maskOutWord(subArray, subTo - subFrom - 1, leftOvers, 31);
            return new BitSet(subArray);
        }
        int first = BitSet.wordIndex(fromIndex);
        int last = BitSet.wordIndex(toIndex);
        int[] subArray = new int[last - first + 1];
        if (first == last) {
            int end = 32 - BitSet.bitOffset(toIndex);
            int word = BitSet.wordAt(this.array, first);
            subArray[0] = word << end >>> rightShift + end;
        } else {
            int word = BitSet.wordAt(this.array, first);
            int current = word >>> rightShift;
            int subIndex = 0;
            int leftShift = 31 - rightShift;
            for (int i = first + 1; i <= last; ++i) {
                word = BitSet.wordAt(this.array, i);
                subArray[subIndex++] = (current |= word << leftShift) & Integer.MAX_VALUE;
                current = word >>> rightShift;
            }
            int end = 32 - BitSet.bitOffset(toIndex);
            current = current << rightShift + end >>> rightShift + end;
            subArray[subIndex] = current & Integer.MAX_VALUE;
        }
        return new BitSet(subArray);
    }

    public int hashCode() {
        int fnvOffset = -2128831035;
        int fnvPrime = 16777619;
        int lastIndex = this.wordLength - 1;
        int hash = 0x811C9DC5 ^ lastIndex;
        for (int i = 0; i <= lastIndex; ++i) {
            int value = BitSet.wordAt(this.array, i);
            hash = hash * 16777619 ^ value & 0xFF;
            hash = hash * 16777619 ^ value >>> 8 & 0xFF;
            hash = hash * 16777619 ^ value >>> 16 & 0xFF;
            hash = hash * 16777619 ^ value >>> 24;
        }
        return hash;
    }

    public boolean intersects(BitSet set) {
        if (this == set) {
            return this.length() > 0;
        }
        int limit = Math.min(this.wordLength, set.wordLength);
        for (int index = 0; index < limit; ++index) {
            int word = BitSet.wordAt(this.array, index);
            if (word == 0 || (word & BitSet.wordAt(set.array, index)) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public int length() {
        int lastIndex = this.wordLength - 1;
        if (lastIndex == -1) {
            return 0;
        }
        int word = BitSet.wordAt(this.array, lastIndex);
        return BitSet.bitIndex(lastIndex) + (32 - Integer.numberOfLeadingZeros(word));
    }

    public int nextClearBit(int fromIndex) {
        BitSet.checkIndex(fromIndex);
        int index = BitSet.wordIndex(fromIndex);
        int length = this.wordLength;
        if (index >= length) {
            return fromIndex;
        }
        int word = ~BitSet.wordAt(this.array, index) & Integer.MAX_VALUE;
        word &= Integer.MAX_VALUE << BitSet.bitOffset(fromIndex);
        while (word == 0) {
            if (++index >= length) {
                return BitSet.bitIndex(index);
            }
            word = ~BitSet.wordAt(this.array, index) & Integer.MAX_VALUE;
        }
        return BitSet.bitIndex(index) + Integer.numberOfTrailingZeros(word);
    }

    public int nextSetBit(int fromIndex) {
        BitSet.checkIndex(fromIndex);
        int index = BitSet.wordIndex(fromIndex);
        int length = this.wordLength;
        if (index >= length) {
            return -1;
        }
        int word = BitSet.wordAt(this.array, index) & Integer.MAX_VALUE << BitSet.bitOffset(fromIndex);
        while (word == 0) {
            if (++index >= length) {
                return -1;
            }
            word = BitSet.wordAt(this.array, index);
        }
        return BitSet.bitIndex(index) + Integer.numberOfTrailingZeros(word);
    }

    public int previousClearBit(int fromIndex) {
        if (fromIndex == -1) {
            return -1;
        }
        BitSet.checkIndex(fromIndex);
        int index = BitSet.wordIndex(fromIndex);
        if (index >= this.wordLength) {
            return fromIndex;
        }
        int word = ~BitSet.wordAt(this.array, index) & Integer.MAX_VALUE;
        word &= Integer.MAX_VALUE >>> 31 - BitSet.bitOffset(fromIndex) - 1;
        while (word == 0) {
            if (--index < 0) {
                return -1;
            }
            word = ~BitSet.wordAt(this.array, index) & Integer.MAX_VALUE;
        }
        return BitSet.bitIndex(index) + (32 - Integer.numberOfLeadingZeros(word)) - 1;
    }

    public int previousSetBit(int fromIndex) {
        if (fromIndex == -1) {
            return -1;
        }
        BitSet.checkIndex(fromIndex);
        int index = BitSet.wordIndex(fromIndex);
        if (index >= this.wordLength) {
            return this.length() - 1;
        }
        int word = BitSet.wordAt(this.array, index) & Integer.MAX_VALUE >>> 31 - BitSet.bitOffset(fromIndex) - 1;
        while (word == 0) {
            if (--index < 0) {
                return -1;
            }
            word = BitSet.wordAt(this.array, index);
        }
        return BitSet.bitIndex(index) + (32 - Integer.numberOfLeadingZeros(word)) - 1;
    }

    public void or(BitSet set) {
        if (this == set) {
            return;
        }
        this.maybeGrowArrayToIndex(set.wordLength - 1);
        for (int index = 0; index < set.wordLength; ++index) {
            int word = BitSet.wordAt(set.array, index);
            if (word == 0) continue;
            this.array[index] = BitSet.wordAt(this.array, index) | word;
        }
        this.wordLength = Math.max(this.wordLength, set.wordLength);
    }

    public void set(int bitIndex) {
        BitSet.checkIndex(bitIndex);
        int index = BitSet.wordIndex(bitIndex);
        this.maybeGrowArrayToIndex(index);
        this.array[index] = BitSet.wordAt(this.array, index) | 1 << BitSet.bitOffset(bitIndex);
        if (index >= this.wordLength) {
            this.wordLength = index + 1;
        }
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex != toIndex) {
            this.setInternal(fromIndex, toIndex);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public int size() {
        return this.array.length * 32;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        int next = this.nextSetBit(0);
        sb.append(next);
        while ((next = this.nextSetBit(next + 1)) != -1) {
            sb.append(", ");
            sb.append(next);
        }
        sb.append("}");
        return sb.toString();
    }

    public void xor(BitSet set) {
        if (this == set) {
            this.clear();
            return;
        }
        this.maybeGrowArrayToIndex(set.wordLength - 1);
        for (int index = 0; index < set.wordLength; ++index) {
            int word = BitSet.wordAt(set.array, index);
            if (word == 0) continue;
            this.array[index] = BitSet.wordAt(this.array, index) ^ word;
        }
        if (this.wordLength <= set.wordLength) {
            this.wordLength = set.wordLength;
            this.updateWordLength();
        }
    }

    public byte[] toByteArray() {
        int nbits = this.length();
        int nbytes = nbits / 8;
        if (nbits % 8 != 0) {
            ++nbytes;
        }
        byte[] bytes = new byte[nbytes];
        int bitOffset = 0;
        for (int i = 0; i < nbytes; ++i) {
            bytes[i] = BitSet.getByte(this.array, bitOffset);
            bitOffset += 8;
        }
        return bytes;
    }

    public long[] toLongArray() {
        int nbits = this.length();
        int nlongs = nbits / 64;
        if (nbits % 64 != 0) {
            ++nlongs;
        }
        long[] longs = new long[nlongs];
        int bitOffset = 0;
        for (int i = 0; i < nlongs; ++i) {
            longs[i] = BitSet.getLong(this.array, bitOffset);
            bitOffset += 64;
        }
        return longs;
    }

    private static byte getByte(int[] words, int bitIndex) {
        int wordIndex = BitSet.wordIndex(bitIndex);
        if (wordIndex >= words.length) {
            return 0;
        }
        int bitOffset = BitSet.bitOffset(bitIndex);
        int word = BitSet.wordAt(words, wordIndex);
        int b = word >>> bitOffset;
        int leftBits = -23 + bitOffset;
        if (leftBits > 0 && wordIndex + 1 < words.length && (word = BitSet.wordAt(words, wordIndex + 1)) != 0) {
            word &= ~(Integer.MAX_VALUE << leftBits);
            b |= (word <<= 8 - leftBits);
        }
        return (byte)(b & 0xFF);
    }

    private static int getInt(int[] words, int bitIndex) {
        byte b1 = BitSet.getByte(words, bitIndex);
        byte b2 = BitSet.getByte(words, bitIndex + 8);
        byte b3 = BitSet.getByte(words, bitIndex + 16);
        byte b4 = BitSet.getByte(words, bitIndex + 24);
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    private static long getLong(int[] words, int bitIndex) {
        int low = BitSet.getInt(words, bitIndex);
        int high = BitSet.getInt(words, bitIndex + 32);
        return LongUtils.fromBits(low, high);
    }

    public static BitSet valueOf(byte[] words) {
        int len;
        for (len = words.length; len > 0 && words[len - 1] == 0; --len) {
        }
        int[] array = new int[len * 8];
        int bitIndex = 0;
        for (int i = 0; i < len; ++i) {
            BitSet.addByte(array, words[i], bitIndex);
            bitIndex += 8;
        }
        return new BitSet(array);
    }

    public static BitSet valueOf(long[] words) {
        int len;
        for (len = words.length; len > 0 && words[len - 1] == 0L; --len) {
        }
        int[] array = new int[len * 64];
        int bitIndex = 0;
        for (int i = 0; i < len; ++i) {
            BitSet.addLong(array, words[i], bitIndex);
            bitIndex += 64;
        }
        return new BitSet(array);
    }

    private static void addByte(int[] words, byte bits, int bitIndex) {
        if (bits != 0) {
            int second;
            int wordIndex = BitSet.wordIndex(bitIndex);
            int bitOffset = BitSet.bitOffset(bitIndex);
            int first = (bits & 0xFF) << bitOffset & Integer.MAX_VALUE;
            if (first != 0) {
                words[wordIndex] = BitSet.wordAt(words, wordIndex) | first;
            }
            int n = second = bitOffset == 0 ? 0 : (bits & 0xFF) >>> 31 - bitOffset;
            if (second != 0) {
                words[wordIndex + 1] = BitSet.wordAt(words, wordIndex + 1) | second;
            }
        }
    }

    private static void addInt(int[] words, int bits, int bitIndex) {
        if (bits != 0) {
            BitSet.addByte(words, (byte)(bits & 0xFF), bitIndex);
            BitSet.addByte(words, (byte)(bits >> 8 & 0xFF), bitIndex + 8);
            BitSet.addByte(words, (byte)(bits >> 16 & 0xFF), bitIndex + 16);
            BitSet.addByte(words, (byte)(bits >> 24 & 0xFF), bitIndex + 24);
        }
    }

    private static void addLong(int[] words, long bits, int bitIndex) {
        if (bits != 0L) {
            int low = (int)bits;
            BitSet.addInt(words, low, bitIndex);
            int high = (int)(bits >>> 32);
            BitSet.addInt(words, high, bitIndex + 32);
        }
    }
}

