/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Supplier;
import javaemul.internal.Platform;

public final class Objects {
    private Objects() {
    }

    public static <T> int compare(T a, T b, Comparator<? super T> c) {
        return a == b ? 0 : c.compare(a, b);
    }

    public static boolean deepEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class<?> class1 = a.getClass();
        Class<?> class2 = b.getClass();
        if (!class1.isArray() || !class2.isArray()) {
            return a.equals(b);
        }
        boolean isObjectArray1 = a instanceof Object[];
        boolean isObjectArray2 = b instanceof Object[];
        if (isObjectArray1 || isObjectArray2) {
            return isObjectArray1 && isObjectArray2 && Arrays.deepEquals((Object[])a, (Object[])b);
        }
        if (!class1.equals(class2)) {
            return false;
        }
        if (a instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof char[]) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a instanceof short[]) {
            return Arrays.equals((short[])a, (short[])b);
        }
        if (a instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof long[]) {
            return Arrays.equals((long[])a, (long[])b);
        }
        if (a instanceof float[]) {
            return Arrays.equals((float[])a, (float[])b);
        }
        return Arrays.equals((double[])a, (double[])b);
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean equals(String a, String b) {
        return Platform.objectsStringEquals(a, b);
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static boolean nonNull(Object obj) {
        return obj != null;
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, Supplier<String> messageSupplier) {
        if (obj == null) {
            throw new NullPointerException(messageSupplier.get());
        }
        return obj;
    }

    public static String toString(Object o) {
        return String.valueOf(o);
    }

    public static String toString(Object o, String nullDefault) {
        return o != null ? o.toString() : nullDefault;
    }
}

