/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import javaemul.internal.InternalPreconditions;

public final class OptionalDouble {
    private static final OptionalDouble EMPTY = new OptionalDouble();
    private final double ref;
    private final boolean present;

    public static OptionalDouble empty() {
        return EMPTY;
    }

    public static OptionalDouble of(double value) {
        return new OptionalDouble(value);
    }

    private OptionalDouble() {
        this.ref = 0.0;
        this.present = false;
    }

    private OptionalDouble(double value) {
        this.ref = value;
        this.present = true;
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isEmpty() {
        return !this.present;
    }

    public double getAsDouble() {
        InternalPreconditions.checkCriticalElement(this.present);
        return this.ref;
    }

    public void ifPresent(DoubleConsumer consumer) {
        if (this.present) {
            consumer.accept(this.ref);
        }
    }

    public void ifPresentOrElse(DoubleConsumer action, Runnable emptyAction) {
        if (this.isPresent()) {
            action.accept(this.ref);
        } else {
            emptyAction.run();
        }
    }

    public double orElse(double other) {
        return this.present ? this.ref : other;
    }

    public double orElseGet(DoubleSupplier other) {
        return this.present ? this.ref : other.getAsDouble();
    }

    public double orElseThrow() {
        return this.getAsDouble();
    }

    public <X extends Throwable> double orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.present) {
            return this.ref;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public DoubleStream stream() {
        if (this.isPresent()) {
            return DoubleStream.of(this.ref);
        }
        return DoubleStream.empty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OptionalDouble)) {
            return false;
        }
        OptionalDouble other = (OptionalDouble)obj;
        return this.present == other.present && Double.compare(this.ref, other.ref) == 0;
    }

    public int hashCode() {
        return this.present ? Double.hashCode(this.ref) : 0;
    }

    public String toString() {
        return this.present ? "OptionalDouble.of(" + Double.toString(this.ref) + ")" : "OptionalDouble.empty()";
    }
}

