/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javaemul.internal.InternalPreconditions;

public final class OptionalLong {
    private static final OptionalLong EMPTY = new OptionalLong();
    private final long ref;
    private final boolean present;

    public static OptionalLong empty() {
        return EMPTY;
    }

    public static OptionalLong of(long value) {
        return new OptionalLong(value);
    }

    private OptionalLong() {
        this.ref = 0L;
        this.present = false;
    }

    private OptionalLong(long value) {
        this.ref = value;
        this.present = true;
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isEmpty() {
        return !this.present;
    }

    public long getAsLong() {
        InternalPreconditions.checkCriticalElement(this.present);
        return this.ref;
    }

    public void ifPresent(LongConsumer consumer) {
        if (this.present) {
            consumer.accept(this.ref);
        }
    }

    public void ifPresentOrElse(LongConsumer action, Runnable emptyAction) {
        if (this.present) {
            action.accept(this.ref);
        } else {
            emptyAction.run();
        }
    }

    public long orElse(long other) {
        return this.present ? this.ref : other;
    }

    public long orElseGet(LongSupplier other) {
        return this.present ? this.ref : other.getAsLong();
    }

    public long orElseThrow() {
        return this.getAsLong();
    }

    public <X extends Throwable> long orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.present) {
            return this.ref;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public LongStream stream() {
        if (this.present) {
            return LongStream.of(this.ref);
        }
        return LongStream.empty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OptionalLong)) {
            return false;
        }
        OptionalLong other = (OptionalLong)obj;
        return this.present == other.present && Long.compare(this.ref, other.ref) == 0;
    }

    public int hashCode() {
        return this.present ? Long.hashCode(this.ref) : 0;
    }

    public String toString() {
        return this.present ? "OptionalLong.of(" + Long.toString(this.ref) + ")" : "OptionalLong.empty()";
    }
}

