/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Comparators;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import javaemul.internal.InternalPreconditions;

public class PriorityQueue<E>
extends AbstractQueue<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private Comparator<? super E> cmp;
    private ArrayList<E> heap;

    private static int getLeftChild(int node) {
        return 2 * node + 1;
    }

    private static int getParent(int node) {
        return (node - 1) / 2;
    }

    private static int getRightChild(int node) {
        return 2 * node + 2;
    }

    private static boolean isLeaf(int node, int size) {
        return node * 2 + 1 >= size;
    }

    public PriorityQueue() {
        this(11);
    }

    public PriorityQueue(Collection<? extends E> c) {
        this(c.size());
        this.addAll(c);
    }

    public PriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityQueue(int initialCapacity, Comparator<? super E> cmp) {
        this.heap = new ArrayList(initialCapacity);
        this.cmp = Comparators.nullToNaturalOrder(cmp);
    }

    public PriorityQueue(Comparator<? super E> comparator) {
        this(11, comparator);
    }

    public PriorityQueue(PriorityQueue<? extends E> c) {
        this(c.size(), c.comparator());
        this.addAll(c);
    }

    public PriorityQueue(SortedSet<? extends E> c) {
        this(c.size(), c.comparator());
        this.addAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        InternalPreconditions.checkNotNull(c);
        InternalPreconditions.checkArgument(c != this);
        int oldSize = this.heap.size();
        for (E e : c) {
            this.heap.add(InternalPreconditions.checkCriticalNotNull(e));
        }
        if (oldSize != this.heap.size()) {
            this.makeHeap(0);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.heap.clear();
    }

    public Comparator<? super E> comparator() {
        return Comparators.naturalOrderToNull(this.cmp);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int i = 0;
            int last = -1;

            @Override
            public boolean hasNext() {
                return this.i < PriorityQueue.this.heap.size();
            }

            @Override
            public E next() {
                InternalPreconditions.checkElement(this.hasNext());
                this.last = this.i++;
                return PriorityQueue.this.heap.get(this.last);
            }

            @Override
            public void remove() {
                InternalPreconditions.checkState(this.last != -1);
                this.i = this.last;
                PriorityQueue.this.removeAtIndex(this.i);
                this.last = -1;
            }
        };
    }

    @Override
    public boolean offer(E e) {
        InternalPreconditions.checkCriticalNotNull(e);
        int node = this.heap.size();
        this.heap.add(e);
        while (node > 0) {
            int childNode = node;
            if (this.cmp.compare(this.heap.get(node = PriorityQueue.getParent(node)), e) <= 0) {
                this.heap.set(childNode, (Object)e);
                return true;
            }
            this.heap.set(childNode, this.heap.get(node));
        }
        this.heap.set(node, (Object)e);
        return true;
    }

    @Override
    public E peek() {
        return (E)(this.heap.isEmpty() ? null : this.heap.get(0));
    }

    @Override
    public E poll() {
        E value = this.peek();
        if (value != null) {
            this.removeAtIndex(0);
        }
        return value;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        this.removeAtIndex(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.heap.removeAll(c)) {
            this.makeHeap(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.heap.retainAll(c)) {
            this.makeHeap(0);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.heap.size();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 256);
    }

    @Override
    public Object[] toArray() {
        return this.heap.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.heap.toArray((Object[])a);
    }

    private void makeHeap(int node) {
        if (this.isLeaf(node)) {
            return;
        }
        this.makeHeap(PriorityQueue.getLeftChild(node));
        int rightChild = PriorityQueue.getRightChild(node);
        if (rightChild < this.heap.size()) {
            this.makeHeap(rightChild);
        }
        this.mergeHeaps(node);
    }

    private void mergeHeaps(int node) {
        int smallestChild;
        int heapSize = this.heap.size();
        Object value = this.heap.get(node);
        while (!PriorityQueue.isLeaf(node, heapSize) && this.cmp.compare(value, this.heap.get(smallestChild = this.getSmallestChild(node, heapSize))) >= 0) {
            this.heap.set(node, this.heap.get(smallestChild));
            node = smallestChild;
        }
        this.heap.set(node, value);
    }

    private int getSmallestChild(int node, int heapSize) {
        int leftChild = PriorityQueue.getLeftChild(node);
        int rightChild = leftChild + 1;
        int smallestChild = leftChild;
        if (rightChild < heapSize && this.cmp.compare(this.heap.get(rightChild), this.heap.get(leftChild)) < 0) {
            smallestChild = rightChild;
        }
        return smallestChild;
    }

    private int indexOf(Object o) {
        return o == null ? -1 : this.heap.indexOf(o);
    }

    private boolean isLeaf(int node) {
        return PriorityQueue.isLeaf(node, this.heap.size());
    }

    private void removeAtIndex(int index) {
        Object lastValue = this.heap.remove(this.heap.size() - 1);
        if (index < this.heap.size()) {
            this.heap.set(index, lastValue);
            this.mergeHeaps(index);
        }
    }
}

