/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicLong
extends Number
implements Serializable {
    private long value;

    public AtomicLong(long initialValue) {
        this.value = initialValue;
    }

    public AtomicLong() {
    }

    public final long get() {
        return this.value;
    }

    public final void set(long newValue) {
        this.value = newValue;
    }

    public final void lazySet(long newValue) {
        this.set(newValue);
    }

    public final long getAndSet(long newValue) {
        long current = this.value;
        this.value = newValue;
        return current;
    }

    public final boolean compareAndSet(long expect, long update) {
        if (this.value == expect) {
            this.value = update;
            return true;
        }
        return false;
    }

    public final long getAndIncrement() {
        return this.value++;
    }

    public final long getAndDecrement() {
        return this.value--;
    }

    public final long getAndAdd(long delta) {
        long current = this.value;
        this.value += delta;
        return current;
    }

    public final long incrementAndGet() {
        return ++this.value;
    }

    public final long decrementAndGet() {
        return --this.value;
    }

    public final long addAndGet(long delta) {
        this.value += delta;
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }
}

