/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleConsoleLogHandler;

public class LogManager {
    private static LogManager singleton;
    private HashMap<String, Logger> loggerMap = new HashMap();

    public static LogManager getLogManager() {
        if (singleton == null) {
            singleton = new LogManager();
            Logger rootLogger = new Logger("", null);
            rootLogger.setLevel(Level.INFO);
            singleton.addLoggerImpl(rootLogger);
        }
        return singleton;
    }

    protected LogManager() {
    }

    public boolean addLogger(Logger logger) {
        if (this.getLogger(logger.getName()) != null) {
            return false;
        }
        this.addLoggerAndEnsureParents(logger);
        return true;
    }

    public Logger getLogger(String name) {
        return (Logger)this.loggerMap.get(name);
    }

    public Enumeration<String> getLoggerNames() {
        return Collections.enumeration(this.loggerMap.keySet());
    }

    private void addLoggerAndEnsureParents(Logger logger) {
        String name = logger.getName();
        String parentName = name.substring(0, Math.max(0, name.lastIndexOf(46)));
        logger.setParent(this.ensureLogger(parentName));
        this.addLoggerImpl(logger);
    }

    private void addLoggerImpl(Logger logger) {
        if (System.getProperty("jre.logging.simpleConsoleHandler").equals("ENABLED") && logger.getName().isEmpty()) {
            logger.addHandler(new SimpleConsoleLogHandler());
        }
        this.loggerMap.put((Object)logger.getName(), (Object)logger);
    }

    Logger ensureLogger(String name) {
        Logger logger = this.getLogger(name);
        if (logger == null) {
            Logger newLogger = new Logger(name, null);
            this.addLoggerAndEnsureParents(newLogger);
            return newLogger;
        }
        return logger;
    }
}

