/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.StreamImpl;
import java.util.stream.StreamSupport;
import javaemul.internal.InternalPreconditions;

public interface Stream<T>
extends BaseStream<T, Stream<T>> {
    public static <T> Builder<T> builder() {
        return new Builder<T>(){
            private ArrayList<T> items = new ArrayList();

            @Override
            public void accept(T t) {
                InternalPreconditions.checkState(this.items != null, "Builder already built");
                this.items.add(t);
            }

            @Override
            public Stream<T> build() {
                InternalPreconditions.checkState(this.items != null, "Builder already built");
                Stream stream = this.items.stream();
                this.items = null;
                return stream;
            }
        };
    }

    public static <T> Stream<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        final Spliterator<Stream> spliteratorOfStreams = Arrays.asList(a, b).spliterator();
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 0){
            Spliterator<? extends T> next;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance(n -> {
                        if (n != null) {
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        StreamImpl result = new StreamImpl(null, spliterator);
        return (Stream)((Stream)result.onClose(a::close)).onClose(b::close);
    }

    public static <T> Stream<T> empty() {
        return new StreamImpl.Empty(null);
    }

    public static <T> Stream<T> generate(final Supplier<T> s) {
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                action.accept(s.get());
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> iterate(T seed, UnaryOperator<T> f) {
        return Stream.iterate(seed, ignore -> true, f);
    }

    public static <T> Stream<T> iterate(final T seed, final Predicate<? super T> hasNext, final UnaryOperator<T> f) {
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            private T next;
            private boolean isFirst;
            private boolean isTerminated;
            {
                super(size, characteristics);
                this.next = seed;
                this.isFirst = true;
                this.isTerminated = false;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (this.isTerminated) {
                    return false;
                }
                if (!this.isFirst) {
                    this.next = f.apply(this.next);
                }
                this.isFirst = false;
                if (!hasNext.test(this.next)) {
                    this.isTerminated = true;
                    return false;
                }
                action.accept(this.next);
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> of(T t) {
        return Collections.singleton(t).stream();
    }

    public static <T> Stream<T> of(T ... values) {
        return Arrays.stream(values);
    }

    public static <T> Stream<T> ofNullable(T t) {
        if (t == null) {
            return Stream.empty();
        }
        return Stream.of(t);
    }

    public boolean allMatch(Predicate<? super T> var1);

    public boolean anyMatch(Predicate<? super T> var1);

    public <R, A> R collect(Collector<? super T, A, R> var1);

    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    public long count();

    public Stream<T> distinct();

    public Stream<T> filter(Predicate<? super T> var1);

    public Optional<T> findAny();

    public Optional<T> findFirst();

    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    public void forEach(Consumer<? super T> var1);

    public void forEachOrdered(Consumer<? super T> var1);

    public Stream<T> limit(long var1);

    public <R> Stream<R> map(Function<? super T, ? extends R> var1);

    public DoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    public IntStream mapToInt(ToIntFunction<? super T> var1);

    public LongStream mapToLong(ToLongFunction<? super T> var1);

    public Optional<T> max(Comparator<? super T> var1);

    public Optional<T> min(Comparator<? super T> var1);

    public boolean noneMatch(Predicate<? super T> var1);

    public Stream<T> peek(Consumer<? super T> var1);

    public Optional<T> reduce(BinaryOperator<T> var1);

    public T reduce(T var1, BinaryOperator<T> var2);

    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    public Stream<T> skip(long var1);

    public Stream<T> sorted();

    public Stream<T> sorted(Comparator<? super T> var1);

    default public Stream<T> dropWhile(final Predicate<? super T> predicate) {
        final Spliterator prev = this.spliterator();
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(prev.estimateSize(), prev.characteristics() & 0xFFFFBFBF){
            private boolean dropping;
            private boolean found;
            {
                super(size, characteristics);
                this.dropping = true;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (!this.dropping) {
                    return prev.tryAdvance(action);
                }
                this.found = false;
                while (this.dropping && prev.tryAdvance(item -> {
                    if (!predicate.test(item)) {
                        this.dropping = false;
                        this.found = true;
                        action.accept(item);
                    }
                })) {
                }
                return this.found;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    default public Stream<T> takeWhile(final Predicate<? super T> predicate) {
        final Spliterator original = this.spliterator();
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(original.estimateSize(), original.characteristics() & 0xFFFFBFBF){
            private boolean taking;
            private boolean found;
            {
                super(size, characteristics);
                this.taking = true;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (!this.taking) {
                    return false;
                }
                this.found = false;
                original.tryAdvance(item -> {
                    if (predicate.test(item)) {
                        this.found = true;
                        action.accept(item);
                    } else {
                        this.taking = false;
                    }
                });
                return this.found;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public Object[] toArray();

    public <A> A[] toArray(IntFunction<A[]> var1);

    public static interface Builder<T>
    extends Consumer<T> {
        @Override
        public void accept(T var1);

        default public Builder<T> add(T t) {
            this.accept(t);
            return this;
        }

        public Stream<T> build();
    }
}

