/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import java.util.Arrays;
import java.util.StringJoiner;
import javaemul.internal.ArrayHelper;
import javaemul.internal.ArrayStamper;
import javaemul.internal.Constructor;
import javaemul.internal.JsUtils;
import jsinterop.annotations.JsMethod;

public abstract class ValueType {
    private static boolean COMPILED = "true".equals(System.getProperty("COMPILED", "false"));

    public boolean equals(Object o) {
        return ValueType.equals(this, o);
    }

    public int hashCode() {
        return ValueType.hashCode(this);
    }

    public String toString() {
        return ValueType.toString(this);
    }

    static boolean equals(ValueType thisObject, Object o) {
        if (o == null || o.getClass() != thisObject.getClass()) {
            return false;
        }
        ValueType thatObject = (ValueType)JsUtils.uncheckedCast(o);
        String[] thisKeys = ValueType.filteredkeys(thisObject);
        if (thisKeys.length != ValueType.filteredkeys(thatObject).length) {
            return false;
        }
        for (String p : thisKeys) {
            Object p2;
            Object p1 = JsUtils.getProperty(thisObject, p);
            if (ValueType.isAutoValueEqual(p1, p2 = JsUtils.getProperty(thatObject, p))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAutoValueEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (ArrayStamper.isStamped(a) && ArrayStamper.isStamped(b)) {
            return a.getClass() == b.getClass() && Arrays.equals((Object[])JsUtils.uncheckedCast(a), (Object[])JsUtils.uncheckedCast(b));
        }
        return a.equals(b);
    }

    static int hashCode(ValueType thisObject) {
        int hashCode = 1;
        for (String key : ValueType.filteredkeys(thisObject)) {
            Object value = JsUtils.getProperty(thisObject, key);
            if (value == null) continue;
            int h = ArrayStamper.isStamped(value) ? Arrays.hashCode((Object[])JsUtils.uncheckedCast(value)) : value.hashCode();
            hashCode = 1000003 * hashCode ^ h;
        }
        return hashCode;
    }

    static String toString(ValueType thisObject) {
        String className = thisObject.getClass().getSimpleName();
        className = className.substring(className.lastIndexOf("AutoValue_") + 1);
        StringJoiner joiner = new StringJoiner(", ", className + "{", "}");
        for (String p : ValueType.filteredkeys(thisObject)) {
            Object value = JsUtils.getProperty(thisObject, p);
            if (ArrayHelper.isArray(value)) {
                value = "[" + value + "]";
            }
            p = ValueType.cleanMangledPropertyName(p);
            joiner.add(p + "=" + value);
        }
        return joiner.toString();
    }

    private static String cleanMangledPropertyName(String name) {
        int index;
        if (COMPILED) {
            return name;
        }
        int n = index = name.startsWith("f_") ? name.indexOf("__", 2) : -1;
        if (index != -1) {
            return name.substring(2, index);
        }
        index = name.lastIndexOf("_$");
        return index == -1 ? name : name.substring(0, index);
    }

    @JsMethod
    private static native String[] filteredkeys(ValueType var0);

    @JsMethod
    private static native void mixin(Constructor var0, Constructor var1, int var2, String ... var3);

    @JsMethod(namespace="goog.reflect")
    static native String objectProperty(String var0, Object var1);

    @JsMethod(name="$J2CL_PRESERVE$", namespace="<global>")
    static native void preserve(Object ... var0);
}

