/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.cache;

import org.apache.log4j.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;

public class MobicentsCache {
    private static Logger logger = Logger.getLogger(MobicentsCache.class);
    private final Cache jBossCache;
    private boolean localMode;
    private final boolean managedCache;

    public MobicentsCache(Configuration cacheConfiguration) {
        this.jBossCache = new DefaultCacheFactory().createCache(cacheConfiguration, false);
        this.managedCache = false;
        this.startCache();
    }

    public MobicentsCache(String cacheConfigurationLocation) {
        this.jBossCache = new DefaultCacheFactory().createCache(cacheConfigurationLocation, false);
        this.managedCache = false;
        this.startCache();
    }

    @Deprecated
    public MobicentsCache(CacheManager haCacheManager, String cacheName) throws Exception {
        this.jBossCache = haCacheManager.getCache(cacheName, true);
        this.jBossCache.create();
        this.managedCache = true;
        this.startCache();
    }

    public MobicentsCache(CacheManager haCacheManager, String cacheName, boolean managedCache) throws Exception {
        this.jBossCache = haCacheManager.getCache(cacheName, true);
        this.jBossCache.create();
        this.managedCache = managedCache;
        this.startCache();
    }

    public MobicentsCache(Cache cache, String cacheName) {
        this.jBossCache = cache;
        this.managedCache = true;
        this.startCache();
    }

    protected void startCache() {
        if (this.jBossCache.getConfiguration().getCacheMode() == Configuration.CacheMode.LOCAL) {
            this.localMode = true;
        }
        if (!this.managedCache && CacheStatus.STARTED != this.jBossCache.getCacheStatus()) {
            this.jBossCache.start();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Mobicents Cache started, status: " + this.jBossCache.getCacheStatus() + ", Mode: " + this.jBossCache.getConfiguration().getCacheModeString()));
        }
    }

    public Cache getJBossCache() {
        return this.jBossCache;
    }

    public void stop() {
        if (!this.managedCache) {
            this.jBossCache.stop();
            this.jBossCache.destroy();
        }
    }

    public boolean isLocalMode() {
        return this.localMode;
    }

    public void setReplicationClassLoader(Fqn regionFqn, ClassLoader classLoader) {
        if (!this.isLocalMode()) {
            Region region = this.jBossCache.getRegion(regionFqn, true);
            region.registerContextClassLoader(classLoader);
            region.activate();
        }
    }

    public void setReplicationClassLoader(ClassLoader classLoader) {
        this.setReplicationClassLoader(Fqn.ROOT, classLoader);
    }

    public void unsetReplicationClassLoader(Fqn regionFqn, ClassLoader classLoader) {
        if (!this.isLocalMode()) {
            Region region = this.jBossCache.getRegion(regionFqn, true);
            region.unregisterContextClassLoader();
            region.deactivate();
        }
    }

    public void unsetReplicationClassLoader(ClassLoader classLoader) {
        this.unsetReplicationClassLoader(Fqn.ROOT, classLoader);
    }
}

