/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.jboss.shrinkwrap.api.asset;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.asset.Asset;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.asset.ByteArrayIOUtil;

public class ByteArrayAsset
implements Asset {
    private static final Logger log = Logger.getLogger(ByteArrayAsset.class.getName());
    private final byte[] content;

    public ByteArrayAsset(byte[] content) throws IllegalArgumentException {
        if (content == null) {
            throw new IllegalArgumentException("content must be specified");
        }
        int length = content.length;
        byte[] newArray = new byte[length];
        System.arraycopy(content, 0, newArray, 0, length);
        this.content = newArray;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Created " + this + " with backing byte array of size " + length + "b");
        }
    }

    public ByteArrayAsset(InputStream stream) {
        this(ByteArrayIOUtil.asByteArray(stream));
    }

    public InputStream openStream() {
        return new ByteArrayInputStream(this.content);
    }

    public byte[] getSource() {
        return this.content;
    }

    public String toString() {
        return ByteArrayAsset.class.getSimpleName() + " [content size=" + this.content.length + "bytes]";
    }
}

