/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BranchInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BranchInfo> {
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchName").getter(BranchInfo.getter(BranchInfo::branchName)).setter(BranchInfo.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()}).build();
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitId").getter(BranchInfo.getter(BranchInfo::commitId)).setter(BranchInfo.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_NAME_FIELD, COMMIT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String branchName;
    private final String commitId;

    private BranchInfo(BuilderImpl builder) {
        this.branchName = builder.branchName;
        this.commitId = builder.commitId;
    }

    public final String branchName() {
        return this.branchName;
    }

    public final String commitId() {
        return this.commitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BranchInfo)) {
            return false;
        }
        BranchInfo other = (BranchInfo)obj;
        return Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.commitId(), other.commitId());
    }

    public final String toString() {
        return ToString.builder((String)"BranchInfo").add("BranchName", (Object)this.branchName()).add("CommitId", (Object)this.commitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BranchInfo, T> g) {
        return obj -> g.apply((BranchInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String branchName;
        private String commitId;

        private BuilderImpl() {
        }

        private BuilderImpl(BranchInfo model) {
            this.branchName(model.branchName);
            this.commitId(model.commitId);
        }

        public final String getBranchName() {
            return this.branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getCommitId() {
            return this.commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public BranchInfo build() {
            return new BranchInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BranchInfo> {
        public Builder branchName(String var1);

        public Builder commitId(String var1);
    }
}

