/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Location
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Location> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(Location.getter(Location::filePath)).setter(Location.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<Long> FILE_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("filePosition").getter(Location.getter(Location::filePosition)).setter(Location.setter(Builder::filePosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePosition").build()}).build();
    private static final SdkField<String> RELATIVE_FILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relativeFileVersion").getter(Location.getter(Location::relativeFileVersionAsString)).setter(Location.setter(Builder::relativeFileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativeFileVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, FILE_POSITION_FIELD, RELATIVE_FILE_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final Long filePosition;
    private final String relativeFileVersion;

    private Location(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.filePosition = builder.filePosition;
        this.relativeFileVersion = builder.relativeFileVersion;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final Long filePosition() {
        return this.filePosition;
    }

    public final RelativeFileVersionEnum relativeFileVersion() {
        return RelativeFileVersionEnum.fromValue(this.relativeFileVersion);
    }

    public final String relativeFileVersionAsString() {
        return this.relativeFileVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeFileVersionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.filePosition(), other.filePosition()) && Objects.equals(this.relativeFileVersionAsString(), other.relativeFileVersionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Location").add("FilePath", (Object)this.filePath()).add("FilePosition", (Object)this.filePosition()).add("RelativeFileVersion", (Object)this.relativeFileVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "filePosition": {
                return Optional.ofNullable(clazz.cast(this.filePosition()));
            }
            case "relativeFileVersion": {
                return Optional.ofNullable(clazz.cast(this.relativeFileVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filePath;
        private Long filePosition;
        private String relativeFileVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            this.filePath(model.filePath);
            this.filePosition(model.filePosition);
            this.relativeFileVersion(model.relativeFileVersion);
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Long getFilePosition() {
            return this.filePosition;
        }

        public final void setFilePosition(Long filePosition) {
            this.filePosition = filePosition;
        }

        @Override
        public final Builder filePosition(Long filePosition) {
            this.filePosition = filePosition;
            return this;
        }

        public final String getRelativeFileVersion() {
            return this.relativeFileVersion;
        }

        public final void setRelativeFileVersion(String relativeFileVersion) {
            this.relativeFileVersion = relativeFileVersion;
        }

        @Override
        public final Builder relativeFileVersion(String relativeFileVersion) {
            this.relativeFileVersion = relativeFileVersion;
            return this;
        }

        @Override
        public final Builder relativeFileVersion(RelativeFileVersionEnum relativeFileVersion) {
            this.relativeFileVersion(relativeFileVersion == null ? null : relativeFileVersion.toString());
            return this;
        }

        public Location build() {
            return new Location(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Location> {
        public Builder filePath(String var1);

        public Builder filePosition(Long var1);

        public Builder relativeFileVersion(String var1);

        public Builder relativeFileVersion(RelativeFileVersionEnum var1);
    }
}

