/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReplacementTypeEnum {
    KEEP_BASE("KEEP_BASE"),
    KEEP_SOURCE("KEEP_SOURCE"),
    KEEP_DESTINATION("KEEP_DESTINATION"),
    USE_NEW_CONTENT("USE_NEW_CONTENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReplacementTypeEnum> VALUE_MAP;
    private final String value;

    private ReplacementTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReplacementTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReplacementTypeEnum> knownValues() {
        EnumSet<ReplacementTypeEnum> knownValues = EnumSet.allOf(ReplacementTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReplacementTypeEnum.class, ReplacementTypeEnum::toString);
    }
}

