/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse;

public class GetDifferencesPublisher
implements SdkPublisher<GetDifferencesResponse> {
    private final CodeCommitAsyncClient client;
    private final GetDifferencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDifferencesPublisher(CodeCommitAsyncClient client, GetDifferencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDifferencesPublisher(CodeCommitAsyncClient client, GetDifferencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDifferencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDifferencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetDifferencesResponseFetcher
    implements AsyncPageFetcher<GetDifferencesResponse> {
        private GetDifferencesResponseFetcher() {
        }

        public boolean hasNextPage(GetDifferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetDifferencesResponse> nextPage(GetDifferencesResponse previousPage) {
            if (previousPage == null) {
                return GetDifferencesPublisher.this.client.getDifferences(GetDifferencesPublisher.this.firstRequest);
            }
            return GetDifferencesPublisher.this.client.getDifferences((GetDifferencesRequest)((Object)GetDifferencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

