/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair;

public class ListRepositoriesIterable
implements SdkIterable<ListRepositoriesResponse> {
    private final CodeCommitClient client;
    private final ListRepositoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRepositoriesIterable(CodeCommitClient client, ListRepositoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRepositoriesResponseFetcher();
    }

    public Iterator<ListRepositoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RepositoryNameIdPair> repositories() {
        Function<ListRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositories() != null) {
                return response.repositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRepositoriesResponseFetcher
    implements SyncPageFetcher<ListRepositoriesResponse> {
        private ListRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRepositoriesResponse nextPage(ListRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoriesIterable.this.client.listRepositories(ListRepositoriesIterable.this.firstRequest);
            }
            return ListRepositoriesIterable.this.client.listRepositories((ListRepositoriesRequest)((Object)ListRepositoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

