/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOnPremisesInstancesResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, ListOnPremisesInstancesResponse> {
    private static final SdkField<List<String>> INSTANCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceNames").getter(ListOnPremisesInstancesResponse.getter(ListOnPremisesInstancesResponse::instanceNames)).setter(ListOnPremisesInstancesResponse.setter(Builder::instanceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOnPremisesInstancesResponse.getter(ListOnPremisesInstancesResponse::nextToken)).setter(ListOnPremisesInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> instanceNames;
    private final String nextToken;

    private ListOnPremisesInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceNames = builder.instanceNames;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceNames() {
        return this.instanceNames != null && !(this.instanceNames instanceof SdkAutoConstructList);
    }

    public final List<String> instanceNames() {
        return this.instanceNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceNames() ? this.instanceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOnPremisesInstancesResponse)) {
            return false;
        }
        ListOnPremisesInstancesResponse other = (ListOnPremisesInstancesResponse)((Object)obj);
        return this.hasInstanceNames() == other.hasInstanceNames() && Objects.equals(this.instanceNames(), other.instanceNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOnPremisesInstancesResponse").add("InstanceNames", this.hasInstanceNames() ? this.instanceNames() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceNames": {
                return Optional.ofNullable(clazz.cast(this.instanceNames()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOnPremisesInstancesResponse, T> g) {
        return obj -> g.apply((ListOnPremisesInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<String> instanceNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOnPremisesInstancesResponse model) {
            super(model);
            this.instanceNames(model.instanceNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getInstanceNames() {
            if (this.instanceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceNames;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOnPremisesInstancesResponse build() {
            return new ListOnPremisesInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOnPremisesInstancesResponse> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

