/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.internal.UserAgentUtils;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;

public class ListApplicationRevisionsPublisher
implements SdkPublisher<ListApplicationRevisionsResponse> {
    private final CodeDeployAsyncClient client;
    private final ListApplicationRevisionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationRevisionsPublisher(CodeDeployAsyncClient client, ListApplicationRevisionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationRevisionsPublisher(CodeDeployAsyncClient client, ListApplicationRevisionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationRevisionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationRevisionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RevisionLocation> revisions() {
        Function<ListApplicationRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.revisions() != null) {
                return response.revisions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationRevisionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationRevisionsResponseFetcher
    implements AsyncPageFetcher<ListApplicationRevisionsResponse> {
        private ListApplicationRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationRevisionsResponse> nextPage(ListApplicationRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationRevisionsPublisher.this.client.listApplicationRevisions(ListApplicationRevisionsPublisher.this.firstRequest);
            }
            return ListApplicationRevisionsPublisher.this.client.listApplicationRevisions((ListApplicationRevisionsRequest)((Object)ListApplicationRevisionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

