/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProvisionedConcurrencyConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<PutProvisionedConcurrencyConfigResponse.Builder, PutProvisionedConcurrencyConfigResponse> {
    private static final SdkField<Integer> REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RequestedProvisionedConcurrentExecutions")
            .getter(getter(PutProvisionedConcurrencyConfigResponse::requestedProvisionedConcurrentExecutions))
            .setter(setter(Builder::requestedProvisionedConcurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RequestedProvisionedConcurrentExecutions").build()).build();

    private static final SdkField<Integer> AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableProvisionedConcurrentExecutions")
            .getter(getter(PutProvisionedConcurrencyConfigResponse::availableProvisionedConcurrentExecutions))
            .setter(setter(Builder::availableProvisionedConcurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AvailableProvisionedConcurrentExecutions").build()).build();

    private static final SdkField<Integer> ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedProvisionedConcurrentExecutions")
            .getter(getter(PutProvisionedConcurrencyConfigResponse::allocatedProvisionedConcurrentExecutions))
            .setter(setter(Builder::allocatedProvisionedConcurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AllocatedProvisionedConcurrentExecutions").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PutProvisionedConcurrencyConfigResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(PutProvisionedConcurrencyConfigResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModified").getter(getter(PutProvisionedConcurrencyConfigResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD,
            ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, LAST_MODIFIED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer requestedProvisionedConcurrentExecutions;

    private final Integer availableProvisionedConcurrentExecutions;

    private final Integer allocatedProvisionedConcurrentExecutions;

    private final String status;

    private final String statusReason;

    private final String lastModified;

    private PutProvisionedConcurrencyConfigResponse(BuilderImpl builder) {
        super(builder);
        this.requestedProvisionedConcurrentExecutions = builder.requestedProvisionedConcurrentExecutions;
        this.availableProvisionedConcurrentExecutions = builder.availableProvisionedConcurrentExecutions;
        this.allocatedProvisionedConcurrentExecutions = builder.allocatedProvisionedConcurrentExecutions;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastModified = builder.lastModified;
    }

    /**
     * <p>
     * The amount of provisioned concurrency requested.
     * </p>
     * 
     * @return The amount of provisioned concurrency requested.
     */
    public final Integer requestedProvisionedConcurrentExecutions() {
        return requestedProvisionedConcurrentExecutions;
    }

    /**
     * <p>
     * The amount of provisioned concurrency available.
     * </p>
     * 
     * @return The amount of provisioned concurrency available.
     */
    public final Integer availableProvisionedConcurrentExecutions() {
        return availableProvisionedConcurrentExecutions;
    }

    /**
     * <p>
     * The amount of provisioned concurrency allocated. When a weighted alias is used during linear and canary
     * deployments, this value fluctuates depending on the amount of concurrency that is provisioned for the function
     * versions.
     * </p>
     * 
     * @return The amount of provisioned concurrency allocated. When a weighted alias is used during linear and canary
     *         deployments, this value fluctuates depending on the amount of concurrency that is provisioned for the
     *         function versions.
     */
    public final Integer allocatedProvisionedConcurrentExecutions() {
        return allocatedProvisionedConcurrentExecutions;
    }

    /**
     * <p>
     * The status of the allocation process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedConcurrencyStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the allocation process.
     * @see ProvisionedConcurrencyStatusEnum
     */
    public final ProvisionedConcurrencyStatusEnum status() {
        return ProvisionedConcurrencyStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * The status of the allocation process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedConcurrencyStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the allocation process.
     * @see ProvisionedConcurrencyStatusEnum
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * For failed allocations, the reason that provisioned concurrency could not be allocated.
     * </p>
     * 
     * @return For failed allocations, the reason that provisioned concurrency could not be allocated.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The date and time that a user last updated the configuration, in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.
     * </p>
     * 
     * @return The date and time that a user last updated the configuration, in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.
     */
    public final String lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestedProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(availableProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProvisionedConcurrencyConfigResponse)) {
            return false;
        }
        PutProvisionedConcurrencyConfigResponse other = (PutProvisionedConcurrencyConfigResponse) obj;
        return Objects.equals(requestedProvisionedConcurrentExecutions(), other.requestedProvisionedConcurrentExecutions())
                && Objects.equals(availableProvisionedConcurrentExecutions(), other.availableProvisionedConcurrentExecutions())
                && Objects.equals(allocatedProvisionedConcurrentExecutions(), other.allocatedProvisionedConcurrentExecutions())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(lastModified(), other.lastModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutProvisionedConcurrencyConfigResponse")
                .add("RequestedProvisionedConcurrentExecutions", requestedProvisionedConcurrentExecutions())
                .add("AvailableProvisionedConcurrentExecutions", availableProvisionedConcurrentExecutions())
                .add("AllocatedProvisionedConcurrentExecutions", allocatedProvisionedConcurrentExecutions())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("LastModified", lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestedProvisionedConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(requestedProvisionedConcurrentExecutions()));
        case "AvailableProvisionedConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(availableProvisionedConcurrentExecutions()));
        case "AllocatedProvisionedConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(allocatedProvisionedConcurrentExecutions()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestedProvisionedConcurrentExecutions", REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD);
        map.put("AvailableProvisionedConcurrentExecutions", AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD);
        map.put("AllocatedProvisionedConcurrentExecutions", ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutProvisionedConcurrencyConfigResponse, T> g) {
        return obj -> g.apply((PutProvisionedConcurrencyConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutProvisionedConcurrencyConfigResponse> {
        /**
         * <p>
         * The amount of provisioned concurrency requested.
         * </p>
         * 
         * @param requestedProvisionedConcurrentExecutions
         *        The amount of provisioned concurrency requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions);

        /**
         * <p>
         * The amount of provisioned concurrency available.
         * </p>
         * 
         * @param availableProvisionedConcurrentExecutions
         *        The amount of provisioned concurrency available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions);

        /**
         * <p>
         * The amount of provisioned concurrency allocated. When a weighted alias is used during linear and canary
         * deployments, this value fluctuates depending on the amount of concurrency that is provisioned for the
         * function versions.
         * </p>
         * 
         * @param allocatedProvisionedConcurrentExecutions
         *        The amount of provisioned concurrency allocated. When a weighted alias is used during linear and
         *        canary deployments, this value fluctuates depending on the amount of concurrency that is provisioned
         *        for the function versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions);

        /**
         * <p>
         * The status of the allocation process.
         * </p>
         * 
         * @param status
         *        The status of the allocation process.
         * @see ProvisionedConcurrencyStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedConcurrencyStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the allocation process.
         * </p>
         * 
         * @param status
         *        The status of the allocation process.
         * @see ProvisionedConcurrencyStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedConcurrencyStatusEnum
         */
        Builder status(ProvisionedConcurrencyStatusEnum status);

        /**
         * <p>
         * For failed allocations, the reason that provisioned concurrency could not be allocated.
         * </p>
         * 
         * @param statusReason
         *        For failed allocations, the reason that provisioned concurrency could not be allocated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The date and time that a user last updated the configuration, in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.
         * </p>
         * 
         * @param lastModified
         *        The date and time that a user last updated the configuration, in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(String lastModified);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private Integer requestedProvisionedConcurrentExecutions;

        private Integer availableProvisionedConcurrentExecutions;

        private Integer allocatedProvisionedConcurrentExecutions;

        private String status;

        private String statusReason;

        private String lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProvisionedConcurrencyConfigResponse model) {
            super(model);
            requestedProvisionedConcurrentExecutions(model.requestedProvisionedConcurrentExecutions);
            availableProvisionedConcurrentExecutions(model.availableProvisionedConcurrentExecutions);
            allocatedProvisionedConcurrentExecutions(model.allocatedProvisionedConcurrentExecutions);
            status(model.status);
            statusReason(model.statusReason);
            lastModified(model.lastModified);
        }

        public final Integer getRequestedProvisionedConcurrentExecutions() {
            return requestedProvisionedConcurrentExecutions;
        }

        public final void setRequestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions) {
            this.requestedProvisionedConcurrentExecutions = requestedProvisionedConcurrentExecutions;
        }

        @Override
        public final Builder requestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions) {
            this.requestedProvisionedConcurrentExecutions = requestedProvisionedConcurrentExecutions;
            return this;
        }

        public final Integer getAvailableProvisionedConcurrentExecutions() {
            return availableProvisionedConcurrentExecutions;
        }

        public final void setAvailableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions) {
            this.availableProvisionedConcurrentExecutions = availableProvisionedConcurrentExecutions;
        }

        @Override
        public final Builder availableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions) {
            this.availableProvisionedConcurrentExecutions = availableProvisionedConcurrentExecutions;
            return this;
        }

        public final Integer getAllocatedProvisionedConcurrentExecutions() {
            return allocatedProvisionedConcurrentExecutions;
        }

        public final void setAllocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions) {
            this.allocatedProvisionedConcurrentExecutions = allocatedProvisionedConcurrentExecutions;
        }

        @Override
        public final Builder allocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions) {
            this.allocatedProvisionedConcurrentExecutions = allocatedProvisionedConcurrentExecutions;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedConcurrencyStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getLastModified() {
            return lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public PutProvisionedConcurrencyConfigResponse build() {
            return new PutProvisionedConcurrencyConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
