/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeadBucketResponse extends S3Response implements
        ToCopyableBuilder<HeadBucketResponse.Builder, HeadBucketResponse> {
    private static final SdkField<String> BUCKET_LOCATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BucketLocationType")
            .getter(getter(HeadBucketResponse::bucketLocationTypeAsString))
            .setter(setter(Builder::bucketLocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-bucket-location-type")
                    .unmarshallLocationName("x-amz-bucket-location-type").build()).build();

    private static final SdkField<String> BUCKET_LOCATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BucketLocationName")
            .getter(getter(HeadBucketResponse::bucketLocationName))
            .setter(setter(Builder::bucketLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-bucket-location-name")
                    .unmarshallLocationName("x-amz-bucket-location-name").build()).build();

    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BucketRegion")
            .getter(getter(HeadBucketResponse::bucketRegion))
            .setter(setter(Builder::bucketRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-bucket-region")
                    .unmarshallLocationName("x-amz-bucket-region").build()).build();

    private static final SdkField<Boolean> ACCESS_POINT_ALIAS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AccessPointAlias")
            .getter(getter(HeadBucketResponse::accessPointAlias))
            .setter(setter(Builder::accessPointAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-access-point-alias")
                    .unmarshallLocationName("x-amz-access-point-alias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_LOCATION_TYPE_FIELD,
            BUCKET_LOCATION_NAME_FIELD, BUCKET_REGION_FIELD, ACCESS_POINT_ALIAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("x-amz-bucket-location-type", BUCKET_LOCATION_TYPE_FIELD);
                    put("x-amz-bucket-location-name", BUCKET_LOCATION_NAME_FIELD);
                    put("x-amz-bucket-region", BUCKET_REGION_FIELD);
                    put("x-amz-access-point-alias", ACCESS_POINT_ALIAS_FIELD);
                }
            });

    private final String bucketLocationType;

    private final String bucketLocationName;

    private final String bucketRegion;

    private final Boolean accessPointAlias;

    private HeadBucketResponse(BuilderImpl builder) {
        super(builder);
        this.bucketLocationType = builder.bucketLocationType;
        this.bucketLocationName = builder.bucketLocationName;
        this.bucketRegion = builder.bucketRegion;
        this.accessPointAlias = builder.accessPointAlias;
    }

    /**
     * <p>
     * The type of location where the bucket is created.
     * </p>
     * <note>
     * <p>
     * This functionality is only supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #bucketLocationType} will return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #bucketLocationTypeAsString}.
     * </p>
     * 
     * @return The type of location where the bucket is created.</p> <note>
     *         <p>
     *         This functionality is only supported by directory buckets.
     *         </p>
     * @see LocationType
     */
    public final LocationType bucketLocationType() {
        return LocationType.fromValue(bucketLocationType);
    }

    /**
     * <p>
     * The type of location where the bucket is created.
     * </p>
     * <note>
     * <p>
     * This functionality is only supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #bucketLocationType} will return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #bucketLocationTypeAsString}.
     * </p>
     * 
     * @return The type of location where the bucket is created.</p> <note>
     *         <p>
     *         This functionality is only supported by directory buckets.
     *         </p>
     * @see LocationType
     */
    public final String bucketLocationTypeAsString() {
        return bucketLocationType;
    }

    /**
     * <p>
     * The name of the location where the bucket will be created.
     * </p>
     * <p>
     * For directory buckets, the AZ ID of the Availability Zone where the bucket is created. An example AZ ID value is
     * <code>usw2-az1</code>.
     * </p>
     * <note>
     * <p>
     * This functionality is only supported by directory buckets.
     * </p>
     * </note>
     * 
     * @return The name of the location where the bucket will be created.</p>
     *         <p>
     *         For directory buckets, the AZ ID of the Availability Zone where the bucket is created. An example AZ ID
     *         value is <code>usw2-az1</code>.
     *         </p>
     *         <note>
     *         <p>
     *         This functionality is only supported by directory buckets.
     *         </p>
     */
    public final String bucketLocationName() {
        return bucketLocationName;
    }

    /**
     * <p>
     * The Region that the bucket is located.
     * </p>
     * 
     * @return The Region that the bucket is located.
     */
    public final String bucketRegion() {
        return bucketRegion;
    }

    /**
     * <p>
     * Indicates whether the bucket name used in the request is an access point alias.
     * </p>
     * <note>
     * <p>
     * For directory buckets, the value of this field is <code>false</code>.
     * </p>
     * </note>
     * 
     * @return Indicates whether the bucket name used in the request is an access point alias.</p> <note>
     *         <p>
     *         For directory buckets, the value of this field is <code>false</code>.
     *         </p>
     */
    public final Boolean accessPointAlias() {
        return accessPointAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucketLocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bucketLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketRegion());
        hashCode = 31 * hashCode + Objects.hashCode(accessPointAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeadBucketResponse)) {
            return false;
        }
        HeadBucketResponse other = (HeadBucketResponse) obj;
        return Objects.equals(bucketLocationTypeAsString(), other.bucketLocationTypeAsString())
                && Objects.equals(bucketLocationName(), other.bucketLocationName())
                && Objects.equals(bucketRegion(), other.bucketRegion())
                && Objects.equals(accessPointAlias(), other.accessPointAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HeadBucketResponse").add("BucketLocationType", bucketLocationTypeAsString())
                .add("BucketLocationName", bucketLocationName()).add("BucketRegion", bucketRegion())
                .add("AccessPointAlias", accessPointAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketLocationType":
            return Optional.ofNullable(clazz.cast(bucketLocationTypeAsString()));
        case "BucketLocationName":
            return Optional.ofNullable(clazz.cast(bucketLocationName()));
        case "BucketRegion":
            return Optional.ofNullable(clazz.cast(bucketRegion()));
        case "AccessPointAlias":
            return Optional.ofNullable(clazz.cast(accessPointAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HeadBucketResponse, T> g) {
        return obj -> g.apply((HeadBucketResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Response.Builder, SdkPojo, CopyableBuilder<Builder, HeadBucketResponse> {
        /**
         * <p>
         * The type of location where the bucket is created.
         * </p>
         * <note>
         * <p>
         * This functionality is only supported by directory buckets.
         * </p>
         * </note>
         * 
         * @param bucketLocationType
         *        The type of location where the bucket is created.</p> <note>
         *        <p>
         *        This functionality is only supported by directory buckets.
         *        </p>
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder bucketLocationType(String bucketLocationType);

        /**
         * <p>
         * The type of location where the bucket is created.
         * </p>
         * <note>
         * <p>
         * This functionality is only supported by directory buckets.
         * </p>
         * </note>
         * 
         * @param bucketLocationType
         *        The type of location where the bucket is created.</p> <note>
         *        <p>
         *        This functionality is only supported by directory buckets.
         *        </p>
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder bucketLocationType(LocationType bucketLocationType);

        /**
         * <p>
         * The name of the location where the bucket will be created.
         * </p>
         * <p>
         * For directory buckets, the AZ ID of the Availability Zone where the bucket is created. An example AZ ID value
         * is <code>usw2-az1</code>.
         * </p>
         * <note>
         * <p>
         * This functionality is only supported by directory buckets.
         * </p>
         * </note>
         * 
         * @param bucketLocationName
         *        The name of the location where the bucket will be created.</p>
         *        <p>
         *        For directory buckets, the AZ ID of the Availability Zone where the bucket is created. An example AZ
         *        ID value is <code>usw2-az1</code>.
         *        </p>
         *        <note>
         *        <p>
         *        This functionality is only supported by directory buckets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketLocationName(String bucketLocationName);

        /**
         * <p>
         * The Region that the bucket is located.
         * </p>
         * 
         * @param bucketRegion
         *        The Region that the bucket is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketRegion(String bucketRegion);

        /**
         * <p>
         * Indicates whether the bucket name used in the request is an access point alias.
         * </p>
         * <note>
         * <p>
         * For directory buckets, the value of this field is <code>false</code>.
         * </p>
         * </note>
         * 
         * @param accessPointAlias
         *        Indicates whether the bucket name used in the request is an access point alias.</p> <note>
         *        <p>
         *        For directory buckets, the value of this field is <code>false</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointAlias(Boolean accessPointAlias);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private String bucketLocationType;

        private String bucketLocationName;

        private String bucketRegion;

        private Boolean accessPointAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(HeadBucketResponse model) {
            super(model);
            bucketLocationType(model.bucketLocationType);
            bucketLocationName(model.bucketLocationName);
            bucketRegion(model.bucketRegion);
            accessPointAlias(model.accessPointAlias);
        }

        public final String getBucketLocationType() {
            return bucketLocationType;
        }

        public final void setBucketLocationType(String bucketLocationType) {
            this.bucketLocationType = bucketLocationType;
        }

        @Override
        public final Builder bucketLocationType(String bucketLocationType) {
            this.bucketLocationType = bucketLocationType;
            return this;
        }

        @Override
        public final Builder bucketLocationType(LocationType bucketLocationType) {
            this.bucketLocationType(bucketLocationType == null ? null : bucketLocationType.toString());
            return this;
        }

        public final String getBucketLocationName() {
            return bucketLocationName;
        }

        public final void setBucketLocationName(String bucketLocationName) {
            this.bucketLocationName = bucketLocationName;
        }

        @Override
        public final Builder bucketLocationName(String bucketLocationName) {
            this.bucketLocationName = bucketLocationName;
            return this;
        }

        public final String getBucketRegion() {
            return bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        public final Boolean getAccessPointAlias() {
            return accessPointAlias;
        }

        public final void setAccessPointAlias(Boolean accessPointAlias) {
            this.accessPointAlias = accessPointAlias;
        }

        @Override
        public final Builder accessPointAlias(Boolean accessPointAlias) {
            this.accessPointAlias = accessPointAlias;
            return this;
        }

        @Override
        public HeadBucketResponse build() {
            return new HeadBucketResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
