/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpConnection.class)
public class HttpConnection {
    public static final TypeArg<HttpConnection> __TYPE_ARG = new TypeArg(obj -> new HttpConnection((io.vertx.core.http.HttpConnection)obj), HttpConnection::getDelegate);
    private final io.vertx.core.http.HttpConnection delegate;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpConnection that = (HttpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
        this.delegate = delegate;
    }

    public HttpConnection(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpConnection)delegate;
    }

    public io.vertx.core.http.HttpConnection getDelegate() {
        return this.delegate;
    }

    public int getWindowSize() {
        int ret = this.delegate.getWindowSize();
        return ret;
    }

    public HttpConnection setWindowSize(int windowSize) {
        this.delegate.setWindowSize(windowSize);
        return this;
    }

    public HttpConnection goAway(long errorCode) {
        this.delegate.goAway(errorCode);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId) {
        this.delegate.goAway(errorCode, lastStreamId);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        this.delegate.goAway(errorCode, lastStreamId, debugData.getDelegate());
        return this;
    }

    public HttpConnection goAwayHandler(Handler<GoAway> handler) {
        this.delegate.goAwayHandler(handler);
        return this;
    }

    public HttpConnection shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    public void shutdown(Handler<AsyncResult<Void>> handler) {
        this.delegate.shutdown(handler);
    }

    public void shutdown() {
        this.shutdown((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxShutdown() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.shutdown((Handler<AsyncResult<Void>>)fut)));
    }

    @Deprecated
    public void shutdown(long timeout, Handler<AsyncResult<Void>> handler) {
        this.delegate.shutdown(timeout, handler);
    }

    @Deprecated
    public void shutdown(long timeout) {
        this.shutdown(timeout, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Deprecated
    public Single<Void> rxShutdown(long timeout) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.shutdown(timeout, (Handler<AsyncResult<Void>>)fut)));
    }

    public void shutdown(long timeout, TimeUnit unit, Handler<AsyncResult<Void>> handler) {
        this.delegate.shutdown(timeout, unit, handler);
    }

    public void shutdown(long timeout, TimeUnit unit) {
        this.shutdown(timeout, unit, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxShutdown(long timeout, TimeUnit unit) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.shutdown(timeout, unit, (Handler<AsyncResult<Void>>)fut)));
    }

    public HttpConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public Http2Settings settings() {
        Http2Settings ret = this.delegate.settings();
        return ret;
    }

    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.updateSettings(settings, completionHandler);
        return this;
    }

    public HttpConnection updateSettings(Http2Settings settings) {
        return this.updateSettings(settings, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxUpdateSettings(Http2Settings settings) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateSettings(settings, (Handler<AsyncResult<Void>>)fut)));
    }

    public Http2Settings remoteSettings() {
        Http2Settings ret = this.delegate.remoteSettings();
        return ret;
    }

    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        this.delegate.remoteSettingsHandler(handler);
        return this;
    }

    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        this.delegate.ping(data.getDelegate(), (Handler)new DelegatingHandler(pongHandler, ar -> ar.map(event -> Buffer.newInstance(event))));
        return this;
    }

    public HttpConnection ping(Buffer data) {
        return this.ping(data, (Handler<AsyncResult<Buffer>>)((Handler)ar -> {}));
    }

    public Single<Buffer> rxPing(Buffer data) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.ping(data, (Handler<AsyncResult<Buffer>>)fut)));
    }

    public HttpConnection pingHandler(Handler<Buffer> handler) {
        this.delegate.pingHandler((Handler)new DelegatingHandler(handler, event -> Buffer.newInstance(event)));
        return this;
    }

    public HttpConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress remoteAddress(boolean real) {
        SocketAddress ret = SocketAddress.newInstance(this.delegate.remoteAddress(real));
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public SocketAddress localAddress(boolean real) {
        SocketAddress ret = SocketAddress.newInstance(this.delegate.localAddress(real));
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
        return arg != null ? new HttpConnection(arg) : null;
    }
}

