/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.http.ClientWebSocket;
import io.vertx.rxjava.core.http.WebSocket;
import io.vertx.rxjava.core.metrics.Measured;
import rx.Single;

@RxGen(value=io.vertx.core.http.WebSocketClient.class)
public class WebSocketClient
implements Measured {
    public static final TypeArg<WebSocketClient> __TYPE_ARG = new TypeArg(obj -> new WebSocketClient((io.vertx.core.http.WebSocketClient)obj), WebSocketClient::getDelegate);
    private final io.vertx.core.http.WebSocketClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketClient that = (WebSocketClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public WebSocketClient(io.vertx.core.http.WebSocketClient delegate) {
        this.delegate = delegate;
    }

    public WebSocketClient(Object delegate) {
        this.delegate = (io.vertx.core.http.WebSocketClient)delegate;
    }

    public io.vertx.core.http.WebSocketClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ClientWebSocket webSocket() {
        ClientWebSocket ret = ClientWebSocket.newInstance(this.delegate.webSocket());
        return ret;
    }

    public void connect(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(port, host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    public void connect(int port, String host, String requestURI) {
        this.connect(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxConnect(int port, String host, String requestURI) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public void connect(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    public void connect(String host, String requestURI) {
        this.connect(host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxConnect(String host, String requestURI) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect(host, requestURI, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public void connect(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    public void connect(String requestURI) {
        this.connect(requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxConnect(String requestURI) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect(requestURI, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public void connect(WebSocketConnectOptions options, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(options, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    public void connect(WebSocketConnectOptions options) {
        this.connect(options, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxConnect(WebSocketConnectOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.connect(options, (Handler<AsyncResult<WebSocket>>)fut)));
    }

    public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, handler);
    }

    public void updateSSLOptions(SSLOptions options) {
        this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateSSLOptions(options, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public void updateSSLOptions(SSLOptions options, boolean force, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.updateSSLOptions(options, force, handler);
    }

    public void updateSSLOptions(SSLOptions options, boolean force) {
        this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)((Handler)ar -> {}));
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options, boolean force) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.updateSSLOptions(options, force, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxClose() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public static WebSocketClient newInstance(io.vertx.core.http.WebSocketClient arg) {
        return arg != null ? new WebSocketClient(arg) : null;
    }
}

