/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.fit.pdfdom.resource.HtmlResource;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.FontVerter;
import org.mabb.fontverter.pdf.PdfFontExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontTable {
    private static Logger log = LoggerFactory.getLogger(FontTable.class);
    private static Pattern fontFamilyRegex = Pattern.compile("([^+^-]*)[+-]([^+]*)");
    private List<Entry> entries = new ArrayList<Entry>();

    public void addEntry(PDFont font) {
        Entry entry = this.get(font);
        if (entry == null) {
            String fontName = font.getName();
            String family = this.findFontFamily(fontName);
            String usedName = this.nextUsedName(family);
            Entry newEntry = new Entry(font.getName(), usedName, font);
            if (newEntry.isEntryValid()) {
                this.add(newEntry);
            }
        }
    }

    public Entry get(PDFont find) {
        for (Entry entryOn : this.entries) {
            if (!entryOn.equalToPDFont(find)) continue;
            return entryOn;
        }
        return null;
    }

    public List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries);
    }

    public String getUsedName(PDFont font) {
        Entry entry = this.get(font);
        if (entry == null) {
            return null;
        }
        return entry.usedName;
    }

    protected String nextUsedName(String fontName) {
        int i = 1;
        String usedName = fontName;
        while (this.isNameUsed(usedName)) {
            usedName = fontName + i;
            ++i;
        }
        return usedName;
    }

    protected boolean isNameUsed(String name) {
        for (Entry entryOn : this.entries) {
            if (!entryOn.usedName.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected void add(Entry entry) {
        this.entries.add(entry);
    }

    private String findFontFamily(String fontName) {
        String familyName = fontName;
        Matcher familyMatcher = fontFamilyRegex.matcher(fontName);
        if (familyMatcher.find()) {
            familyName = familyMatcher.group(1) + " " + familyMatcher.group(2);
        }
        return familyName.replaceAll("[+]", " ");
    }

    public class Entry
    extends HtmlResource {
        public String fontName;
        public String usedName;
        public PDFontDescriptor descriptor;
        private PDFont baseFont;
        private byte[] cachedFontData;
        private String mimeType;
        private String fileEnding;

        public Entry(String fontName, String usedName, PDFont font) {
            super(fontName);
            this.mimeType = "x-font-truetype";
            this.fontName = fontName;
            this.usedName = usedName;
            this.descriptor = font.getFontDescriptor();
            this.baseFont = font;
        }

        @Override
        public byte[] getData() throws IOException {
            if (this.cachedFontData != null) {
                return this.cachedFontData;
            }
            if (this.descriptor.getFontFile2() != null && this.baseFont instanceof PDType0Font) {
                this.cachedFontData = this.loadType0TtfDescendantFont();
            } else if (this.descriptor.getFontFile2() != null) {
                this.cachedFontData = this.loadTrueTypeFont(this.descriptor.getFontFile2());
            } else if (this.descriptor.getFontFile() != null) {
                this.cachedFontData = this.loadType1Font(this.descriptor.getFontFile());
            } else if (this.descriptor.getFontFile3() != null) {
                this.cachedFontData = this.loadOtherTypeFont(this.descriptor.getFontFile3());
            }
            return this.cachedFontData;
        }

        public boolean isEntryValid() {
            byte[] fontData = new byte[]{};
            try {
                fontData = this.getData();
            }
            catch (IOException e) {
                log.warn("Error loading font '{}' Message: {} {}", new Object[]{this.fontName, e.getMessage(), e.getClass()});
            }
            return fontData != null && fontData.length != 0;
        }

        private byte[] loadTrueTypeFont(PDStream fontFile) throws IOException {
            this.mimeType = "application/x-font-truetype";
            this.fileEnding = "otf";
            byte[] fontData = fontFile.toByteArray();
            FVFont font = FontVerter.readFont((byte[])fontData);
            byte[] fvFontData = this.tryNormalizeFVFont(font);
            if (fvFontData.length != 0) {
                fontData = fvFontData;
            }
            return fontData;
        }

        private byte[] loadType0TtfDescendantFont() throws IOException {
            this.mimeType = "application/x-font-truetype";
            this.fileEnding = "ttf";
            try {
                FVFont font = PdfFontExtractor.convertType0FontToOpenType((PDType0Font)((PDType0Font)this.baseFont));
                byte[] fontData = this.tryNormalizeFVFont(font);
                if (fontData.length != 0) {
                    return fontData;
                }
            }
            catch (Exception ex) {
                log.warn("Error loading type 0 with ttf descendant font '{}' Message: {} {}", new Object[]{this.fontName, ex.getMessage(), ex.getClass()});
            }
            return this.descriptor.getFontFile2().toByteArray();
        }

        private byte[] loadType1Font(PDStream fontFile) throws IOException {
            log.warn("Type 1 fonts are not supported by Pdf2Dom.");
            return new byte[0];
        }

        private byte[] loadOtherTypeFont(PDStream fontFile) throws IOException {
            try {
                FVFont font = FontVerter.convertFont((byte[])fontFile.toByteArray(), (FontVerter.FontFormat)FontVerter.FontFormat.WOFF1);
                this.mimeType = "application/x-font-woff";
                this.fileEnding = font.getProperties().getFileEnding();
                return font.getData();
            }
            catch (Exception ex) {
                log.error("Issue converting Bare CFF font or the font type is not supportedby Pdf2Dom, Font: {} Exception: {} {}", new Object[]{this.fontName, ex.getMessage(), ex.getClass()});
                return new byte[0];
            }
        }

        private byte[] tryNormalizeFVFont(FVFont font) {
            try {
                if (!font.isValid()) {
                    font.normalize();
                }
                return font.getData();
            }
            catch (Exception ex) {
                log.warn("Error normalizing font '{}' Message: {} {}", new Object[]{this.fontName, ex.getMessage(), ex.getClass()});
                return new byte[0];
            }
        }

        public boolean equalToPDFont(PDFont compare) {
            return compare.getName().equals(this.baseFont.getName()) && compare.getType().equals(this.baseFont.getType()) && compare.getSubType().equals(this.baseFont.getSubType());
        }

        public int hashCode() {
            return this.fontName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.fontName == null ? other.fontName != null : !this.fontName.equals(other.fontName));
        }

        @Override
        public String getFileEnding() {
            return this.fileEnding;
        }

        private FontTable getOuterType() {
            return FontTable.this;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }
    }
}

