/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.util;

import org.aesh.readline.util.Parser;
import org.aesh.readline.util.ShortHelper;
import org.junit.Assert;
import org.junit.Test;

public class ShortHelperTest {
    @Test
    public void testShortConverter() {
        this.testString("foo");
        this.testString("as')(#/&!\"=#)dfae09fajfjdf aeufa3jas");
    }

    private void testString(String input) {
        int[] ints;
        short[] shorts = ShortHelper.toShortPoints((String)input);
        Assert.assertTrue((shorts.length == (ints = Parser.toCodePoints((String)input)).length ? 1 : 0) != 0);
        for (int i = 0; i < shorts.length; ++i) {
            Assert.assertTrue((shorts[i] == ints[i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFromShortToString() {
        this.fromShortToString("foo");
        this.fromShortToString("as')(#/&!\"=#)dfae09fajfjdf aeufa3jas");
    }

    private void fromShortToString(String input) {
        short[] shorts = ShortHelper.toShortPoints((String)input);
        String out = ShortHelper.fromShortPoints((short[])shorts);
        Assert.assertEquals((Object)input, (Object)out);
    }
}

