/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import org.apache.cxf.common.util.ReflectionUtil;

public class ReflectionInvokationHandler
implements InvocationHandler {
    private Object target;

    public ReflectionInvokationHandler(Object obj) {
        this.target = obj;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        WrapReturn wr = method.getAnnotation(WrapReturn.class);
        try {
            Method m = this.target.getClass().getMethod(method.getName(), this.getParameterTypes(method, args));
            ReflectionUtil.setAccessible(m);
            return ReflectionInvokationHandler.wrapReturn(wr, m.invoke(this.target, args));
        }
        catch (NoSuchMethodException e) {
            for (Method m2 : this.target.getClass().getMethods()) {
                if (!m2.getName().equals(method.getName()) || m2.getParameterTypes().length != method.getParameterTypes().length) continue;
                boolean found = true;
                for (int x = 0; x < m2.getParameterTypes().length; ++x) {
                    if (args[x] == null || m2.getParameterTypes()[x].isInstance(args[x])) continue;
                    found = false;
                }
                if (!found) continue;
                ReflectionUtil.setAccessible(m2);
                return ReflectionInvokationHandler.wrapReturn(wr, m2.invoke(this.target, args));
            }
            throw e;
        }
    }

    private Class<?>[] getParameterTypes(Method method, Object[] args) {
        Class<?>[] types = method.getParameterTypes();
        for (int x = 0; x < types.length; ++x) {
            UnwrapParam p = this.getUnwrapParam(method.getParameterAnnotations()[x]);
            if (p == null) continue;
            String s = p.methodName();
            String tn = p.typeMethodName();
            try {
                Method m = args[x].getClass().getMethod(s, new Class[0]);
                if ("#default".equals(tn)) {
                    types[x] = m.getReturnType();
                } else {
                    Method m2 = args[x].getClass().getMethod(tn, new Class[0]);
                    types[x] = (Class)ReflectionUtil.setAccessible(m2).invoke(args[x], new Object[0]);
                }
                args[x] = ReflectionUtil.setAccessible(m).invoke(args[x], new Object[0]);
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return types;
    }

    private UnwrapParam getUnwrapParam(Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof UnwrapParam)) continue;
            return (UnwrapParam)a;
        }
        return null;
    }

    private static Object wrapReturn(WrapReturn wr, Object t) {
        if (wr == null || t == null) {
            return t;
        }
        if (wr.iterator()) {
            return new WrapperIterator(wr.value(), (Iterator)t);
        }
        return ReflectionInvokationHandler.createProxyWrapper(t, wr.value());
    }

    public static final <T> T createProxyWrapper(Object target, Class<T> inf) {
        ReflectionInvokationHandler h = new ReflectionInvokationHandler(target);
        return inf.cast(Proxy.newProxyInstance(inf.getClassLoader(), new Class[]{inf}, (InvocationHandler)h));
    }

    private static class WrapperIterator
    implements Iterator<Object> {
        Class<?> cls;
        Iterator<?> internal;

        public WrapperIterator(Class<?> c, Iterator<?> it) {
            this.internal = it;
            this.cls = c;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        @Override
        public Object next() {
            Object obj = this.internal.next();
            return ReflectionInvokationHandler.createProxyWrapper(obj, this.cls);
        }

        @Override
        public void remove() {
            this.internal.remove();
        }
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface UnwrapParam {
        public String methodName() default "getValue";

        public String typeMethodName() default "#default";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface WrapReturn {
        public Class<?> value();

        public boolean iterator() default false;
    }
}

