/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileOpenSaveDialog {
    private final Component mainUI;
    private static final JFileChooser fileChooser = new JFileChooser(){

        @Override
        public void approveSelection() {
            int result;
            File selectedFile = this.getSelectedFile();
            if (selectedFile.exists() && this.getDialogType() == 1 && (result = JOptionPane.showConfirmDialog(this, "Do you want to overwrite?", "File already exists", 0)) != 0) {
                this.cancelSelection();
                return;
            }
            super.approveSelection();
        }
    };

    public FileOpenSaveDialog(Component parentUI, FileFilter fileFilter) {
        this.mainUI = parentUI;
        fileChooser.setFileFilter(fileFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFile(byte[] bytes) throws IOException {
        int result = fileChooser.showSaveDialog(this.mainUI);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(selectedFile);
                outputStream.write(bytes);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            return true;
        }
        return false;
    }

    public File openFile() throws IOException {
        int result = fileChooser.showOpenDialog(this.mainUI);
        if (result == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }
}

