/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.debugger.ui.ArrayEntry;
import org.apache.pdfbox.debugger.ui.DocumentEntry;
import org.apache.pdfbox.debugger.ui.MapEntry;
import org.apache.pdfbox.debugger.ui.PageEntry;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PDFTreeModel
implements TreeModel {
    private Object root;

    public PDFTreeModel() {
    }

    public PDFTreeModel(PDDocument doc) {
        this.root = doc.getDocument().getTrailer();
    }

    public PDFTreeModel(DocumentEntry docEntry) {
        this.root = docEntry;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object retval = null;
        if (parent instanceof COSArray) {
            ArrayEntry entry = new ArrayEntry();
            entry.setIndex(index);
            entry.setValue(((COSArray)parent).getObject(index));
            entry.setItem(((COSArray)parent).get(index));
            retval = entry;
        } else if (parent instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)parent;
            ArrayList keys = new ArrayList(dict.keySet());
            Collections.sort(keys);
            COSName key = (COSName)keys.get(index);
            COSBase value = dict.getDictionaryObject(key);
            MapEntry entry = new MapEntry();
            entry.setKey(key);
            entry.setValue(value);
            entry.setItem(dict.getItem(key));
            retval = entry;
        } else if (parent instanceof MapEntry) {
            retval = this.getChild(((MapEntry)parent).getValue(), index);
        } else if (parent instanceof ArrayEntry) {
            retval = this.getChild(((ArrayEntry)parent).getValue(), index);
        } else if (parent instanceof COSDocument) {
            retval = ((COSDocument)parent).getObjects().get(index);
        } else if (parent instanceof DocumentEntry) {
            retval = ((DocumentEntry)parent).getPage(index);
        } else if (parent instanceof PageEntry) {
            retval = this.getChild(((PageEntry)parent).getDict(), index);
        } else if (parent instanceof COSObject) {
            retval = ((COSObject)parent).getObject();
        } else {
            throw new IllegalArgumentException("Unknown COS type " + parent.getClass().getName());
        }
        return retval;
    }

    @Override
    public int getChildCount(Object parent) {
        int retval = 0;
        if (parent instanceof COSArray) {
            retval = ((COSArray)parent).size();
        } else if (parent instanceof COSDictionary) {
            retval = ((COSDictionary)parent).size();
        } else if (parent instanceof MapEntry) {
            retval = this.getChildCount(((MapEntry)parent).getValue());
        } else if (parent instanceof ArrayEntry) {
            retval = this.getChildCount(((ArrayEntry)parent).getValue());
        } else if (parent instanceof COSDocument) {
            retval = ((COSDocument)parent).getObjects().size();
        } else if (parent instanceof DocumentEntry) {
            retval = ((DocumentEntry)parent).getPageCount();
        } else if (parent instanceof PageEntry) {
            retval = this.getChildCount(((PageEntry)parent).getDict());
        } else if (parent instanceof COSObject) {
            retval = 1;
        }
        return retval;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int retval = -1;
        if (parent != null && child != null) {
            if (parent instanceof COSArray) {
                COSArray array = (COSArray)parent;
                if (child instanceof ArrayEntry) {
                    ArrayEntry arrayEntry = (ArrayEntry)child;
                    retval = arrayEntry.getIndex();
                } else {
                    retval = array.indexOf((COSBase)child);
                }
            } else if (parent instanceof COSDictionary) {
                MapEntry entry = (MapEntry)child;
                COSDictionary dict = (COSDictionary)parent;
                ArrayList keys = new ArrayList(dict.keySet());
                Collections.sort(keys);
                for (int i = 0; retval == -1 && i < keys.size(); ++i) {
                    if (!((COSName)keys.get(i)).equals((Object)entry.getKey())) continue;
                    retval = i;
                }
            } else if (parent instanceof MapEntry) {
                retval = this.getIndexOfChild(((MapEntry)parent).getValue(), child);
            } else if (parent instanceof ArrayEntry) {
                retval = this.getIndexOfChild(((ArrayEntry)parent).getValue(), child);
            } else if (parent instanceof COSDocument) {
                retval = ((COSDocument)parent).getObjects().indexOf(child);
            } else if (parent instanceof DocumentEntry) {
                retval = ((DocumentEntry)parent).indexOf((PageEntry)child);
            } else if (parent instanceof PageEntry) {
                retval = this.getIndexOfChild(((PageEntry)parent).getDict(), child);
            } else if (parent instanceof COSObject) {
                retval = 0;
            } else {
                throw new IllegalArgumentException("Unknown COS type " + parent.getClass().getName());
            }
        }
        return retval;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean isLeaf = !(node instanceof COSDictionary || node instanceof COSArray || node instanceof COSDocument || node instanceof DocumentEntry || node instanceof PageEntry || node instanceof COSObject || node instanceof MapEntry && !this.isLeaf(((MapEntry)node).getValue()) || node instanceof ArrayEntry && !this.isLeaf(((ArrayEntry)node).getValue()));
        return isLeaf;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

