/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Booleans;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractBooleanAssert<S extends AbstractBooleanAssert<S>>
extends AbstractAssert<S, Boolean> {
    @VisibleForTesting
    Booleans booleans = Booleans.instance();

    protected AbstractBooleanAssert(Boolean actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isTrue() {
        return this.isEqualTo(true);
    }

    public S isFalse() {
        return this.isEqualTo(false);
    }

    public S isEqualTo(boolean expected) {
        this.booleans.assertEqual(this.info, (Boolean)this.actual, expected);
        return (S)((AbstractBooleanAssert)this.myself);
    }

    public S isNotEqualTo(boolean other) {
        this.booleans.assertNotEqual(this.info, (Boolean)this.actual, other);
        return (S)((AbstractBooleanAssert)this.myself);
    }

    @Override
    @Deprecated
    public final S usingComparator(Comparator<? super Boolean> customComparator) {
        throw new UnsupportedOperationException("custom Comparator is not supported for Boolean comparison");
    }
}

