/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.OptionalDouble;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.error.OptionalDoubleShouldHaveValueCloseTo;
import org.assertj.core.error.OptionalShouldBeEmpty;
import org.assertj.core.error.OptionalShouldBePresent;
import org.assertj.core.error.OptionalShouldContain;
import org.assertj.core.internal.Doubles;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractOptionalDoubleAssert<S extends AbstractOptionalDoubleAssert<S>>
extends AbstractAssert<S, OptionalDouble> {
    @VisibleForTesting
    Doubles doubles = Doubles.instance();

    protected AbstractOptionalDoubleAssert(OptionalDouble actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isPresent() {
        this.isNotNull();
        if (!((OptionalDouble)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBePresent.shouldBePresent(this.actual));
        }
        return (S)((AbstractOptionalDoubleAssert)this.myself);
    }

    public S isEmpty() {
        this.isNotNull();
        if (((OptionalDouble)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBeEmpty.shouldBeEmpty((OptionalDouble)this.actual));
        }
        return (S)((AbstractOptionalDoubleAssert)this.myself);
    }

    public S hasValue(double expectedValue) {
        this.isNotNull();
        if (!((OptionalDouble)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (expectedValue != ((OptionalDouble)this.actual).getAsDouble()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain((OptionalDouble)this.actual, expectedValue));
        }
        return (S)((AbstractOptionalDoubleAssert)this.myself);
    }

    public S hasValueCloseTo(Double expectedValue, Offset<Double> offset) {
        this.isNotNull();
        if (!((OptionalDouble)this.actual).isPresent()) {
            this.throwAssertionError(OptionalDoubleShouldHaveValueCloseTo.shouldHaveValueCloseTo(expectedValue));
        }
        try {
            this.doubles.assertIsCloseTo((AssertionInfo)this.info, ((OptionalDouble)this.actual).getAsDouble(), expectedValue, offset);
        }
        catch (AssertionError assertionError) {
            this.throwAssertionError(OptionalDoubleShouldHaveValueCloseTo.shouldHaveValueCloseTo((OptionalDouble)this.actual, expectedValue, offset, Math.abs(expectedValue - ((OptionalDouble)this.actual).getAsDouble())));
        }
        return (S)((AbstractOptionalDoubleAssert)this.myself);
    }
}

