/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.nio.charset.Charset;
import java.nio.file.Path;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.internal.Paths;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractPathAssert<S extends AbstractPathAssert<S>>
extends AbstractComparableAssert<S, Path> {
    @VisibleForTesting
    protected Paths paths = Paths.instance();
    @VisibleForTesting
    Charset charset = Charset.defaultCharset();

    protected AbstractPathAssert(Path actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S hasSameContentAs(Path expected) {
        this.paths.assertHasSameContentAs(this.info, (Path)this.actual, expected);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S hasBinaryContent(byte[] expected) {
        this.paths.assertHasBinaryContent(this.info, (Path)this.actual, expected);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S usingCharset(String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            throw new IllegalArgumentException(String.format("Charset:<'%s'> is not supported on this system", charsetName));
        }
        return this.usingCharset(Charset.forName(charsetName));
    }

    public S usingCharset(Charset charset) {
        this.charset = Preconditions.checkNotNull(charset, "The charset should not be null");
        return (S)((AbstractPathAssert)this.myself);
    }

    public S hasContent(String expected) {
        this.paths.assertHasContent(this.info, (Path)this.actual, expected, this.charset);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isReadable() {
        this.paths.assertIsReadable(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isWritable() {
        this.paths.assertIsWritable(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isExecutable() {
        this.paths.assertIsExecutable(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S exists() {
        this.paths.assertExists(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S existsNoFollowLinks() {
        this.paths.assertExistsNoFollowLinks(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S doesNotExist() {
        this.paths.assertDoesNotExist(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isRegularFile() {
        this.paths.assertIsRegularFile(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isDirectory() {
        this.paths.assertIsDirectory(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isSymbolicLink() {
        this.paths.assertIsSymbolicLink(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isAbsolute() {
        this.paths.assertIsAbsolute(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isRelative() {
        this.paths.assertIsRelative(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isNormalized() {
        this.paths.assertIsNormalized(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S isCanonical() {
        this.paths.assertIsCanonical(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S hasFileName(String fileName) {
        this.paths.assertHasFileName(this.info, (Path)this.actual, fileName);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S hasParent(Path expected) {
        this.paths.assertHasParent(this.info, (Path)this.actual, expected);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S hasParentRaw(Path expected) {
        this.paths.assertHasParentRaw(this.info, (Path)this.actual, expected);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S hasNoParent() {
        this.paths.assertHasNoParent(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S hasNoParentRaw() {
        this.paths.assertHasNoParentRaw(this.info, (Path)this.actual);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S startsWith(Path other) {
        this.paths.assertStartsWith(this.info, (Path)this.actual, other);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S startsWithRaw(Path other) {
        this.paths.assertStartsWithRaw(this.info, (Path)this.actual, other);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S endsWith(Path other) {
        this.paths.assertEndsWith(this.info, (Path)this.actual, other);
        return (S)((AbstractPathAssert)this.myself);
    }

    public S endsWithRaw(Path other) {
        this.paths.assertEndsWithRaw(this.info, (Path)this.actual, other);
        return (S)((AbstractPathAssert)this.myself);
    }
}

