/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldBeEqualWithinOffset;
import org.assertj.core.error.ShouldBeEqualWithinPercentage;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;
import org.assertj.core.util.VisibleForTesting;

public class Shorts
extends Numbers<Short> {
    private static final Shorts INSTANCE = new Shorts();

    public static Shorts instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Shorts() {
    }

    public Shorts(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Short zero() {
        return (short)0;
    }

    @Override
    public void assertIsCloseTo(AssertionInfo info, Short actual, Short expected, Offset<Short> offset) {
        Shorts.assertNotNull(info, actual);
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        Short absDiff = (short)Math.abs(expected - actual);
        if (absDiff > (Short)offset.value) {
            throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, absDiff));
        }
    }

    @Override
    public void assertIsCloseToPercentage(AssertionInfo info, Short actual, Short other, Percentage percentage) {
        Shorts.assertNotNull(info, actual);
        CommonValidations.checkPercentageIsNotNull(percentage);
        CommonValidations.checkNumberIsNotNull(other);
        Offset<Double> calculatedOffset = Offset.offset(percentage.value * (double)other.shortValue() / 100.0);
        short absDiff = (short)Math.abs(other - actual);
        if ((double)absDiff > (Double)calculatedOffset.value) {
            throw this.failures.failure(info, ShouldBeEqualWithinPercentage.shouldBeEqualWithinPercentage(actual, other, percentage, absDiff));
        }
    }
}

