/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core;

class LoggingLevel {
    public static final int ALL_LEVEL_ENABLED = 31;
    public static final int ALL_LEVEL_DISABLED = 0;
    public static final int TRACE_ENABLED = 1;
    public static final int DEBUG_ENABLED = 2;
    public static final int INFO_ENABLED = 4;
    public static final int WARN_ENABLED = 8;
    public static final int ERROR_ENABLED = 16;
    public static final LoggingLevel TRACE = new LoggingLevel(1);
    public static final LoggingLevel DEBUG = new LoggingLevel(2);
    public static final LoggingLevel INFO = new LoggingLevel(4);
    public static final LoggingLevel WARN = new LoggingLevel(8);
    public static final LoggingLevel ERROR = new LoggingLevel(16);
    private static final LoggingLevel ALL_LEVEL = new LoggingLevel(31);
    Integer flags;

    LoggingLevel(int flags) {
        this.flags = flags;
    }

    boolean matchPartialy(Integer flags) {
        return (this.flags & flags) != 0;
    }

    boolean partialyMatch(LoggingLevel level) {
        return this.matchPartialy(level.flags);
    }

    static LoggingLevel fromLabel(String label) {
        if (label.toLowerCase().contains(Label.TRACE.name().toLowerCase())) {
            return TRACE;
        }
        if (label.toLowerCase().contains(Label.DEBUG.name().toLowerCase())) {
            return DEBUG;
        }
        if (label.toLowerCase().contains(Label.INFO.name().toLowerCase())) {
            return INFO;
        }
        if (label.toLowerCase().contains(Label.WARN.name().toLowerCase())) {
            return WARN;
        }
        if (label.toLowerCase().contains(Label.ERROR.name().toLowerCase())) {
            return ERROR;
        }
        if (label.toLowerCase().contains("all-levels")) {
            return ALL_LEVEL;
        }
        return null;
    }

    public static enum Label {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    static class Mutable
    extends LoggingLevel {
        Mutable(int flags) {
            super(flags);
        }

        void add(Integer flags) {
            this.flags = this.flags | flags;
        }

        void remove(Integer flags) {
            this.flags = this.flags & (0x1F ^ flags);
        }

        void set(Integer flags) {
            this.flags = flags;
        }
    }
}

