/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.burningwave.core.LoggingLevel;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JManagedLoggerRepository
extends ManagedLogger.Repository.Abst {
    private Map<String, Map.Entry<Logger, LoggingLevel.Mutable>> loggers;

    public SLF4JManagedLoggerRepository(Properties properties) {
        super(properties);
    }

    @Override
    void initSpecificElements(Properties properties) {
        this.loggers = new HashMap<String, Map.Entry<Logger, LoggingLevel.Mutable>>();
    }

    @Override
    void resetSpecificElements() {
        this.loggers.clear();
    }

    @Override
    public void setLoggingLevelFlags(Class<?> cls, Integer flags) {
        this.getLoggerEntry(cls.getName()).getValue().set(flags);
    }

    @Override
    public Integer getLoggingLevelFlags(Class<?> cls) {
        return this.getLoggerEntry((String)cls.getName()).getValue().flags;
    }

    @Override
    public void addLoggingLevelFor(LoggingLevel logLevel, String ... classNames) {
        for (String className : classNames) {
            this.getLoggerEntry(className).getValue().add(logLevel.flags);
        }
    }

    @Override
    public void removeLoggingLevelFor(LoggingLevel logLevel, String ... classNames) {
        for (String className : classNames) {
            this.getLoggerEntry(className).getValue().remove(logLevel.flags);
        }
    }

    @Override
    public void setLoggingLevelFor(LoggingLevel level, String ... classNames) {
        for (String className : classNames) {
            this.getLoggerEntry(className).getValue().set(level.flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<Logger, LoggingLevel.Mutable> getLoggerEntry(String clientName) {
        Map.Entry<Logger, LoggingLevel.Mutable> loggerEntry = this.loggers.get(clientName);
        if (loggerEntry == null) {
            Map<String, Map.Entry<Logger, LoggingLevel.Mutable>> map = this.loggers;
            synchronized (map) {
                loggerEntry = this.loggers.get(clientName);
                if (loggerEntry == null) {
                    loggerEntry = new AbstractMap.SimpleEntry<Logger, LoggingLevel.Mutable>(LoggerFactory.getLogger((String)clientName), new LoggingLevel.Mutable(31));
                    this.loggers.put(clientName, loggerEntry);
                }
            }
        }
        return loggerEntry;
    }

    private void log(Supplier<String> clientNameSupplier, LoggingLevel loggingLevel, BiConsumer<Logger, StackTraceElement> loggerConsumer) {
        if (!this.isEnabled) {
            return;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[3].getClassName().equals(ManagedLogger.class.getName()) ? stackTraceElements[4] : stackTraceElements[3];
        String clientName = clientNameSupplier.get();
        Optional.ofNullable(this.getLogger(clientName, loggingLevel)).ifPresent(logger -> loggerConsumer.accept((Logger)logger, stackTraceElement));
    }

    private Logger getLogger(String clientName, LoggingLevel loggingLevel) {
        Map.Entry<Logger, LoggingLevel.Mutable> loggerEntry = this.getLoggerEntry(clientName);
        return loggerEntry.getValue().partialyMatch(loggingLevel) ? loggerEntry.getKey() : null;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void disableLogging() {
        this.isEnabled = false;
    }

    @Override
    public void enableLogging() {
        this.isEnabled = true;
    }

    @Override
    public void disableLogging(String clientName) {
        this.getLoggerEntry(clientName).getValue().set(0);
    }

    @Override
    public void enableLogging(String clientName) {
        this.getLoggerEntry(clientName).getValue().set(31);
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, String message, Throwable exc, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, (logger, stackTraceElement) -> logger.error(this.addDetailsToMessage(StaticComponentContainer.Strings.compile(message, arguments), (StackTraceElement)stackTraceElement), exc));
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, String message, Throwable exc) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, (logger, stackTraceElement) -> logger.error(this.addDetailsToMessage(message, (StackTraceElement)stackTraceElement), exc));
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, (logger, stackTraceElement) -> logger.error(this.addDetailsToMessage(StaticComponentContainer.Strings.compile(message, arguments), (StackTraceElement)stackTraceElement)));
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, Throwable exc) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, (logger, stackTraceElement) -> logger.error(this.addDetailsToMessage("Exception occurred", (StackTraceElement)stackTraceElement), exc));
    }

    @Override
    public void logError(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.ERROR, (logger, stackTraceElement) -> logger.error(this.addDetailsToMessage(message, (StackTraceElement)stackTraceElement)));
    }

    @Override
    public void logDebug(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.DEBUG, (logger, stackTraceElement) -> logger.debug(this.addDetailsToMessage(message, (StackTraceElement)stackTraceElement)));
    }

    @Override
    public void logDebug(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.DEBUG, (logger, stackTraceElement) -> logger.debug(this.addDetailsToMessage(message, (StackTraceElement)stackTraceElement), arguments));
    }

    @Override
    public void logInfo(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.INFO, (logger, stackTraceElement) -> logger.info(this.addDetailsToMessage(message, (StackTraceElement)stackTraceElement)));
    }

    @Override
    public void logInfo(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.INFO, (logger, stackTraceElement) -> logger.info(this.addDetailsToMessage(message, (StackTraceElement)stackTraceElement), arguments));
    }

    @Override
    public void logWarn(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.WARN, (logger, stackTraceElement) -> logger.warn(this.addDetailsToMessage(message, (StackTraceElement)stackTraceElement)));
    }

    @Override
    public void logWarn(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.WARN, (logger, stackTraceElement) -> logger.warn(this.addDetailsToMessage(message, (StackTraceElement)stackTraceElement), arguments));
    }

    @Override
    public void logTrace(Supplier<String> clientNameSupplier, String message) {
        this.log(clientNameSupplier, LoggingLevel.TRACE, (logger, stackTraceElement) -> logger.trace(this.addDetailsToMessage(message, (StackTraceElement)stackTraceElement)));
    }

    @Override
    public void logTrace(Supplier<String> clientNameSupplier, String message, Object ... arguments) {
        this.log(clientNameSupplier, LoggingLevel.TRACE, (logger, stackTraceElement) -> logger.trace(message, arguments));
    }

    @Override
    public void close() {
        this.loggers.clear();
        super.close();
    }
}

