/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.assembler;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.burningwave.core.Cleanable;
import org.burningwave.core.Component;
import org.burningwave.core.Executable;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ByteCodeHunter;
import org.burningwave.core.classes.ClassFactory;
import org.burningwave.core.classes.ClassHunter;
import org.burningwave.core.classes.ClassPathHelper;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.ClassPathScanner;
import org.burningwave.core.classes.CodeExecutor;
import org.burningwave.core.classes.ExecuteConfig;
import org.burningwave.core.classes.FunctionalInterfaceFactory;
import org.burningwave.core.classes.JavaMemoryCompiler;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchResult;
import org.burningwave.core.concurrent.QueuedTasksExecutor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

public class ComponentContainer
implements ComponentSupplier,
Properties.Listener,
ManagedLogger {
    private static Collection<ComponentContainer> instances = ConcurrentHashMap.newKeySet();
    private Map<Class<?>, Component> components;
    private Supplier<Properties> propertySupplier;
    private org.burningwave.core.iterable.Properties config;
    private boolean isUndestroyable;
    private Consumer<ComponentContainer> preAfterInitCall;
    private QueuedTasksExecutor.Task afterInitTask;
    private String instanceId = this.getId();

    ComponentContainer(Supplier<Properties> propertySupplier) {
        this.propertySupplier = propertySupplier;
        this.components = new ConcurrentHashMap();
        this.config = new org.burningwave.core.iterable.Properties();
        this.listenTo(StaticComponentContainer.GlobalProperties);
        this.listenTo(this.config);
        instances.add(this);
    }

    public static final ComponentContainer create(String configFileName) {
        try {
            return new ComponentContainer(() -> {
                org.burningwave.core.iterable.Properties properties;
                block10: {
                    InputStream inputStream = StaticComponentContainer.Resources.getAsInputStream(ComponentContainer.class.getClassLoader(), configFileName);
                    try {
                        org.burningwave.core.iterable.Properties config = new org.burningwave.core.iterable.Properties();
                        if (inputStream != null) {
                            config.load(inputStream);
                            StaticComponentContainer.ManagedLoggersRepository.logInfo(() -> ComponentContainer.class.getName(), configFileName + " loaded");
                        } else {
                            StaticComponentContainer.ManagedLoggersRepository.logInfo(() -> ComponentContainer.class.getName(), configFileName + " not found");
                        }
                        properties = config;
                        if (inputStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable exc) {
                            return (Properties)StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
                        }
                    }
                    inputStream.close();
                }
                return properties;
            }).init();
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggersRepository.logError(() -> ComponentContainer.class.getName(), "Exception while creating  " + ComponentContainer.class.getSimpleName(), exc);
            return (ComponentContainer)StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
        }
    }

    public static final ComponentContainer create(Properties properties) {
        try {
            return new ComponentContainer(() -> properties).init();
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggersRepository.logError(() -> ComponentContainer.class.getName(), "Exception while creating  " + ComponentContainer.class.getSimpleName(), exc);
            return (ComponentContainer)StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
        }
    }

    public static final ComponentContainer create() {
        return ComponentContainer.create((Properties)null);
    }

    private ComponentContainer init() {
        org.burningwave.core.iterable.Properties config = new org.burningwave.core.iterable.Properties();
        TreeMap<String, Object> defaultProperties = new TreeMap<String, Object>();
        defaultProperties.putAll(Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(CodeExecutor.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(PathHelper.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(JavaMemoryCompiler.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassFactory.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ByteCodeHunter.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassHunter.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassPathHunter.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassPathScanner.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(ClassPathHelper.Configuration.DEFAULT_VALUES);
        defaultProperties.putAll(PathScannerClassLoader.Configuration.DEFAULT_VALUES);
        config.putAll((Map<?, ?>)StaticComponentContainer.GlobalProperties);
        Optional.ofNullable(this.propertySupplier.get()).ifPresent(customConfig -> config.putAll((Map<?, ?>)customConfig));
        for (Map.Entry defVal : defaultProperties.entrySet()) {
            config.putIfAbsent(defVal.getKey(), defVal.getValue());
        }
        StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> StaticComponentContainer.IterableObjectHelper.refresh(this.config, config));
        this.logConfigProperties();
        this.setAfterInitTask();
        return this;
    }

    private ComponentContainer setAfterInitTask() {
        if (this.config.getProperty("component-container.after-init.operations") != null) {
            StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> {
                this.afterInitTask = StaticComponentContainer.BackgroundExecutor.createTask(() -> {
                    Collection tasks;
                    if (this.preAfterInitCall != null) {
                        this.preAfterInitCall.accept(this);
                    }
                    if ((tasks = (Collection)this.resolveProperty(this.config, "component-container.after-init.operations", null)) != null) {
                        for (QueuedTasksExecutor.TaskAbst task : tasks) {
                            task.waitForFinish();
                        }
                    }
                });
            });
        }
        return this;
    }

    public ComponentContainer preAfterInit(Consumer<ComponentContainer> preAfterInitCall) {
        this.preAfterInitCall = preAfterInitCall;
        return this;
    }

    public void logConfigProperties() {
        org.burningwave.core.iterable.Properties componentContainerConfig = new org.burningwave.core.iterable.Properties();
        componentContainerConfig.putAll((Map<?, ?>)this.config);
        componentContainerConfig.keySet().removeAll(StaticComponentContainer.GlobalProperties.keySet());
        StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "\n\n\tConfiguration values for dynamic components:\n\n{}\n\n", componentContainerConfig.toPrettyString(2));
    }

    ComponentContainer markAsUndestroyable() {
        this.isUndestroyable = true;
        return this;
    }

    public void processChangeNotification(org.burningwave.core.iterable.Properties properties, Properties.Event event, Object key, Object newValue, Object oldValue) {
        if (properties == StaticComponentContainer.GlobalProperties) {
            if (event.name().equals(Properties.Event.PUT.name())) {
                this.config.put(key, newValue);
            } else if (event.name().equals(Properties.Event.REMOVE.name())) {
                this.config.remove(key);
            }
        } else if (properties == this.config && event.name().equals(Properties.Event.PUT.name()) && key instanceof String) {
            PathScannerClassLoader pathScannerClassLoader;
            String keyAsString = (String)key;
            if (keyAsString.equals("path-scanner-class-loader.parent")) {
                PathScannerClassLoader pathScannerClassLoader2 = (PathScannerClassLoader)this.components.get(PathScannerClassLoader.class);
                if (pathScannerClassLoader2 != null) {
                    StaticComponentContainer.ClassLoaders.setAsParent(pathScannerClassLoader2, (ClassLoader)this.resolveProperty(this.config, "path-scanner-class-loader.parent"));
                }
            } else if (keyAsString.equals("path-scanner-class-loader.search-config.check-file-option") && (pathScannerClassLoader = (PathScannerClassLoader)this.components.get(PathScannerClassLoader.class)) != null) {
                StaticComponentContainer.Fields.setDirect((Object)pathScannerClassLoader, "classFileCriteriaAndConsumer", (Object)FileSystemItem.Criteria.forClassTypeFiles(this.config.resolveStringValue("path-scanner-class-loader.search-config.check-file-option")));
            }
        }
    }

    private String getMutexForComponentsId() {
        return this.instanceId + "_components";
    }

    public void reset() {
        StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> {
            this.clear();
            this.init();
        });
    }

    public static ComponentContainer getInstance() {
        return LazyHolder.getComponentContainerInstance();
    }

    public String getConfigProperty(String propertyName) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue(this.config, propertyName);
    }

    public String getConfigProperty(String propertyName, Map<String, String> defaultValues) {
        return StaticComponentContainer.IterableObjectHelper.resolveStringValue(this.config, propertyName, defaultValues);
    }

    public Object setConfigProperty(String propertyName, Object propertyValue) {
        return this.config.put(propertyName, propertyValue);
    }

    public Object removeConfigProperty(String propertyName) {
        return this.config.remove(propertyName);
    }

    @Override
    public <I, T extends Component> T getOrCreate(Class<I> cls, Supplier<I> componentSupplier) {
        Component component = this.components.get(cls);
        if (component == null) {
            component = StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> {
                Component componentTemp = this.components.get(cls);
                if (componentTemp == null) {
                    QueuedTasksExecutor.Task afterInitTask = this.afterInitTask;
                    if (afterInitTask != null) {
                        this.afterInitTask = null;
                        afterInitTask.submit();
                    }
                    componentTemp = (Component)componentSupplier.get();
                    this.components.put(cls, componentTemp);
                }
                return componentTemp;
            });
        }
        return (T)component;
    }

    @Override
    public PathScannerClassLoader getPathScannerClassLoader() {
        return (PathScannerClassLoader)this.getOrCreate(PathScannerClassLoader.class, () -> {
            PathScannerClassLoader classLoader = new PathScannerClassLoader((ClassLoader)this.resolveProperty(this.config, "path-scanner-class-loader.parent"), this.getPathHelper(), FileSystemItem.Criteria.forClassTypeFiles(this.config.resolveStringValue("path-scanner-class-loader.search-config.check-file-option")), () -> StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> {
                PathScannerClassLoader cL = (PathScannerClassLoader)this.components.remove(PathScannerClassLoader.class);
                if (cL != null) {
                    cL.unregister(this, true);
                }
            }));
            classLoader.register(this);
            return classLoader;
        });
    }

    @Override
    public ClassFactory getClassFactory() {
        return (ClassFactory)this.getOrCreate(ClassFactory.class, () -> ClassFactory.create(this.getByteCodeHunter(), () -> this.getClassPathHunter(), this.getJavaMemoryCompiler(), this.getPathHelper(), this.getClassPathHelper(), () -> this.resolveProperty(this.config, "class-factory.default-class-loader"), this.config));
    }

    @Override
    public CodeExecutor getCodeExecutor() {
        return (CodeExecutor)this.getOrCreate(CodeExecutor.class, () -> CodeExecutor.create(() -> this.getClassFactory(), this.getPathHelper(), this.config));
    }

    @Override
    public JavaMemoryCompiler getJavaMemoryCompiler() {
        return (JavaMemoryCompiler)this.getOrCreate(JavaMemoryCompiler.class, () -> JavaMemoryCompiler.create(this.getPathHelper(), this.getClassPathHelper(), this.config));
    }

    @Override
    public ClassHunter getClassHunter() {
        return (ClassHunter)this.getOrCreate(ClassHunter.class, () -> ClassHunter.create(this.getPathHelper(), () -> this.resolveProperty(this.config, "class-hunter.default-path-scanner-class-loader"), this.config));
    }

    @Override
    public ClassPathHelper getClassPathHelper() {
        return (ClassPathHelper)this.getOrCreate(ClassPathHelper.class, () -> ClassPathHelper.create(this.getClassPathHunter(), this.config));
    }

    @Override
    public ClassPathHunter getClassPathHunter() {
        return (ClassPathHunter)this.getOrCreate(ClassPathHunter.class, () -> ClassPathHunter.create(this.getPathHelper(), () -> this.resolveProperty(this.config, "class-path-hunter.default-path-scanner-class-loader"), this.config));
    }

    @Override
    public ByteCodeHunter getByteCodeHunter() {
        return (ByteCodeHunter)this.getOrCreate(ByteCodeHunter.class, () -> ByteCodeHunter.create(this.getPathHelper(), () -> this.resolveProperty(this.config, "byte-code-hunter.default-path-scanner-class-loader"), this.config));
    }

    @Override
    public FunctionalInterfaceFactory getFunctionalInterfaceFactory() {
        return (FunctionalInterfaceFactory)this.getOrCreate(FunctionalInterfaceFactory.class, () -> FunctionalInterfaceFactory.create(this.getClassFactory()));
    }

    @Override
    public PathHelper getPathHelper() {
        return (PathHelper)this.getOrCreate(PathHelper.class, () -> PathHelper.create(this.config));
    }

    public <T> T resolveProperty(Properties properties, String configKey) {
        return this.resolveProperty(properties, configKey, null);
    }

    public <T> T resolveProperty(Properties properties, String configKey, Map<?, ?> defaultValues) {
        Object object = StaticComponentContainer.IterableObjectHelper.resolveValue(properties, configKey, null, null, false, defaultValues);
        if (object instanceof String) {
            ExecuteConfig.ForProperties executeConfig = (ExecuteConfig.ForProperties)((ExecuteConfig.ForProperties)((ExecuteConfig.ForProperties)ExecuteConfig.fromDefaultProperties().setPropertyName(configKey).withParameter(this)).useAsParentClassLoader(StaticComponentContainer.Classes.getClassLoader(Executable.class))).setClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(new HashSet());
            if (defaultValues != null) {
                executeConfig.withDefaultPropertyValues(defaultValues);
            }
            return this.getCodeExecutor().execute(executeConfig);
        }
        if (object instanceof Function) {
            return (T)((Supplier<Object>)() -> ((Function)object).apply(this));
        }
        return object;
    }

    public ComponentContainer clear() {
        Map<Class<?>, Component> components = this.components;
        StaticComponentContainer.Synchronizer.execute(this.getMutexForComponentsId(), () -> {
            this.components = new ConcurrentHashMap();
        });
        if (!components.isEmpty()) {
            StaticComponentContainer.BackgroundExecutor.createTask(() -> StaticComponentContainer.IterableObjectHelper.deepClear(components, (type, component) -> {
                try {
                    if (!(component instanceof PathScannerClassLoader)) {
                        component.close();
                    } else {
                        ((PathScannerClassLoader)component).unregister(this, true);
                    }
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred while closing " + component, exc);
                }
            }), 1).submit();
        }
        return this;
    }

    public static void clearAll() {
        for (ComponentContainer componentContainer : instances) {
            try {
                componentContainer.clear();
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(() -> ComponentContainer.class.getName(), "Exception occurred while executing clear on " + componentContainer.toString(), exc);
            }
        }
        StaticComponentContainer.Cache.clear(new Cleanable[0]);
    }

    void close(boolean force) {
        if (force || !this.isUndestroyable) {
            instances.remove(this);
            this.closeResources(() -> this.instanceId == null, () -> {
                this.unregister(StaticComponentContainer.GlobalProperties);
                this.unregister(this.config);
                this.clear();
                this.components = null;
                this.propertySupplier = null;
                this.config = null;
                this.instanceId = null;
            });
        } else {
            StaticComponentContainer.Throwables.throwException("Could not close singleton instance {}", LazyHolder.COMPONENT_CONTAINER_INSTANCE);
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    static void closeAll() {
        for (ComponentContainer componentContainer : instances) {
            try {
                componentContainer.close(true);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(() -> ComponentContainer.class.getName(), "Exception occurred while closing " + componentContainer, exc);
            }
        }
        StaticComponentContainer.Cache.clear(new Cleanable[0]);
        System.gc();
    }

    public static void clearAllCaches() {
        ComponentContainer.clearAllCaches(true, true, true);
    }

    public static void clearAllCaches(boolean closeHuntersResults, boolean closeClassRetrievers) {
        ComponentContainer.clearAllCaches(closeHuntersResults, closeClassRetrievers, true);
    }

    public static void clearAllCaches(boolean closeHuntersResults, boolean closeClassRetrievers, boolean clearFileSystemItemReferences) {
        for (ComponentContainer componentContainer : instances) {
            componentContainer.clearCache(closeHuntersResults, closeClassRetrievers);
        }
        StaticComponentContainer.Cache.clear(true, clearFileSystemItemReferences ? null : StaticComponentContainer.Cache.pathForFileSystemItems);
        System.gc();
    }

    @Override
    public void clearCache(boolean closeHuntersResults, boolean closeClassRetrievers) {
        this.clearHuntersCache(closeHuntersResults);
        ClassFactory classFactory = (ClassFactory)((Object)this.components.get(ClassFactory.class));
        if (classFactory != null) {
            classFactory.reset(closeClassRetrievers);
        }
        System.gc();
    }

    @Override
    public void clearHuntersCache(boolean closeHuntersResults) {
        ClassPathHunter classPathHunter;
        ClassHunter classHunter;
        ByteCodeHunter byteCodeHunter = (ByteCodeHunter)((Object)this.components.get(ByteCodeHunter.class));
        if (byteCodeHunter != null) {
            byteCodeHunter.clearCache(closeHuntersResults);
        }
        if ((classHunter = (ClassHunter)((Object)this.components.get(ClassHunter.class))) != null) {
            classHunter.clearCache(closeHuntersResults);
        }
        if ((classPathHunter = (ClassPathHunter)((Object)this.components.get(ClassPathHunter.class))) != null) {
            classPathHunter.clearCache(closeHuntersResults);
        }
    }

    public boolean isClosed() {
        return !instances.contains(this);
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            defaultValues.put("component-container.after-init.operations.imports", "${code-executor.common.imports};${component-container.after-init.operations.additional-imports};" + Arrays.class.getName() + ";" + SearchResult.class.getName() + ";");
            defaultValues.put("component-container.after-init.operations.executor.name", ComponentContainer.class.getPackage().getName() + ".AfterInitOperationsExecutor");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            public static final String AFTER_INIT = "component-container.after-init.operations";
        }
    }

    public static class PathScannerClassLoader
    extends org.burningwave.core.classes.PathScannerClassLoader {
        Runnable markAsCloseableAlgorithm;

        PathScannerClassLoader(ClassLoader parentClassLoader, PathHelper pathHelper, FileSystemItem.Criteria scanFileCriteria, Runnable markAsCloseableAlgorithm) {
            super(parentClassLoader, pathHelper, scanFileCriteria);
            this.markAsCloseableAlgorithm = markAsCloseableAlgorithm;
        }

        public void markAsCloseable() {
            this.markAsCloseableAlgorithm.run();
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    private static class LazyHolder {
        private static final ComponentContainer COMPONENT_CONTAINER_INSTANCE = ComponentContainer.create("burningwave.properties").markAsUndestroyable();

        private LazyHolder() {
        }

        private static ComponentContainer getComponentContainerInstance() {
            return COMPONENT_CONTAINER_INSTANCE;
        }
    }
}

