/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.assembler;

import io.github.toolfactory.jvm.Driver;
import io.github.toolfactory.jvm.Info;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.burningwave.core.Cache;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.Objects;
import org.burningwave.core.Strings;
import org.burningwave.core.Throwables;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.classes.Classes;
import org.burningwave.core.classes.Constructors;
import org.burningwave.core.classes.Fields;
import org.burningwave.core.classes.Members;
import org.burningwave.core.classes.Methods;
import org.burningwave.core.classes.Modules;
import org.burningwave.core.classes.PropertyAccessor;
import org.burningwave.core.classes.SourceCodeHandler;
import org.burningwave.core.concurrent.QueuedTasksExecutor;
import org.burningwave.core.concurrent.Synchronizer;
import org.burningwave.core.concurrent.Thread;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemHelper;
import org.burningwave.core.io.Resources;
import org.burningwave.core.io.Streams;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.Properties;
import org.burningwave.core.jvm.BufferHandler;

public class StaticComponentContainer {
    private static final Properties.Listener GlobalPropertiesListener;
    public static final QueuedTasksExecutor.Group BackgroundExecutor;
    public static final BufferHandler BufferHandler;
    public static final PropertyAccessor ByFieldOrByMethodPropertyAccessor;
    public static final PropertyAccessor ByMethodOrByFieldPropertyAccessor;
    public static final Cache Cache;
    public static final Classes Classes;
    public static final Classes.Loaders ClassLoaders;
    public static final Driver Driver;
    public static final Constructors Constructors;
    public static final FileSystemHelper FileSystemHelper;
    public static final Fields Fields;
    public static final Properties GlobalProperties;
    public static final IterableObjectHelper IterableObjectHelper;
    public static final Info JVMInfo;
    public static final ManagedLogger.Repository ManagedLoggersRepository;
    public static final Members Members;
    public static final Methods Methods;
    public static final Modules Modules;
    public static final Objects Objects;
    public static final Strings.Paths Paths;
    public static final Resources Resources;
    public static final SourceCodeHandler SourceCodeHandler;
    public static final Streams Streams;
    public static final Strings Strings;
    public static final Synchronizer Synchronizer;
    public static final Thread.Holder ThreadHolder;
    public static final Thread.Supplier ThreadSupplier;
    public static final Throwables Throwables;

    private static String getName(String simpleName) {
        return Optional.ofNullable(GlobalProperties.resolveStringValue("group-name-for-named-elements")).map(nm -> nm + " - ").orElseGet(() -> "") + simpleName;
    }

    private static final QueuedTasksExecutor.Group.TasksMonitorer.Config retrieveAllTasksMonitoringConfig() {
        String probablyDeadLockedThreadsHandlingPolicy = GlobalProperties.resolveStringValue("background-executor.all-tasks-monitoring.probable-dead-locked-tasks-handling.policy");
        return new QueuedTasksExecutor.Group.TasksMonitorer.Config().setAllTasksLoggerEnabled(Objects.toBoolean(GlobalProperties.resolveValue("background-executor.all-tasks-monitoring.logger.enabled"))).setInterval(Objects.toLong(GlobalProperties.resolveValue("background-executor.all-tasks-monitoring.interval"))).setMinimumElapsedTimeToConsiderATaskAsProbablyDeadLocked(Objects.toLong(GlobalProperties.resolveValue("background-executor.all-tasks-monitoring.minimum-elapsed-time-to-consider-a-task-as-probable-dead-locked"))).setMarkAsProbableDeadLocked(probablyDeadLockedThreadsHandlingPolicy.toLowerCase().contains("mark as probable dead locked")).setKillProbableDeadLockedTasks(probablyDeadLockedThreadsHandlingPolicy.toLowerCase().contains("abort"));
    }

    static void showBanner() {
        List<String> bannerList = Arrays.asList(Resources.getAsStringBuffer(StaticComponentContainer.class.getClassLoader(), (String)GlobalProperties.resolveValue("banner.file")).toString().split("-------------------------------------------------------------------------------------------------------------"));
        Collections.shuffle(bannerList);
        System.out.println("\n" + bannerList.get(new Random().nextInt(bannerList.size())));
    }

    static {
        try {
            long startTime = System.nanoTime();
            JVMInfo = Info.Provider.getInfoInstance();
            Strings = org.burningwave.core.Strings.create();
            Throwables = org.burningwave.core.Throwables.create();
            Objects = org.burningwave.core.Objects.create();
            Resources = new Resources();
            Properties properties = new Properties();
            properties.putAll(BufferHandler.Configuration.DEFAULT_VALUES);
            properties.putAll(IterableObjectHelper.Configuration.DEFAULT_VALUES);
            properties.putAll(ManagedLogger.Repository.Configuration.DEFAULT_VALUES);
            properties.putAll(Thread.Supplier.Configuration.DEFAULT_VALUES);
            properties.putAll(Configuration.DEFAULT_VALUES);
            Map.Entry<Properties, URL> propBag = Resources.loadFirstOneFound(properties, "burningwave.static.properties", "burningwave.static.default.properties");
            GlobalProperties = propBag.getKey();
            GlobalPropertiesListener = new Properties.Listener(){

                @Override
                public <K, V> void processChangeNotification(Properties config, Properties.Event event, K key, V newValue, V previousValue) {
                    if (key instanceof String) {
                        String keyAsString = (String)key;
                        if (event.name().equals(Properties.Event.PUT.name())) {
                            if (keyAsString.startsWith("thread-supplier.")) {
                                boolean calledByThreadSupplier = false;
                                boolean mustThrowException = true;
                                for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                                    if (stackTraceElement.getClassName().equals(Thread.Supplier.class.getName())) {
                                        calledByThreadSupplier = true;
                                        if (!stackTraceElement.getMethodName().equals("<init>")) continue;
                                        mustThrowException = false;
                                        continue;
                                    }
                                    if (calledByThreadSupplier) break;
                                }
                                if (mustThrowException) {
                                    Throwables.throwException("The reconfiguration of property '{}' is not allowed", key);
                                }
                            } else if (keyAsString.equals("managed-logger.repository")) {
                                ManagedLogger.Repository toBeReplaced = ManagedLoggersRepository;
                                Fields.setStaticDirect(StaticComponentContainer.class, "ManagedLoggersRepository", ManagedLogger.Repository.create(config));
                                toBeReplaced.close();
                            } else if (keyAsString.startsWith("background-executor.all-tasks-monitoring.enabled".substring(0, "background-executor.all-tasks-monitoring.enabled".lastIndexOf(".")))) {
                                if (keyAsString.equals("background-executor.all-tasks-monitoring.enabled")) {
                                    if (!Objects.toBoolean(config.resolveValue("background-executor.all-tasks-monitoring.enabled"))) {
                                        BackgroundExecutor.stopAllTasksMonitoring();
                                    }
                                } else {
                                    BackgroundExecutor.startAllTasksMonitoring(StaticComponentContainer.retrieveAllTasksMonitoringConfig());
                                }
                            } else if (keyAsString.equals("background-executor.task-creation-tracking.enabled")) {
                                BackgroundExecutor.setTasksCreationTrackingFlag(Objects.toBoolean(config.resolveValue("background-executor.task-creation-tracking.enabled")));
                            } else if (keyAsString.equals("synchronizer.all-threads-monitoring.enabled")) {
                                if (Objects.toBoolean(config.resolveValue("synchronizer.all-threads-monitoring.enabled"))) {
                                    Synchronizer.startAllThreadsMonitoring(Objects.toLong(config.resolveValue("synchronizer.all-threads-monitoring.interval")));
                                } else {
                                    Synchronizer.stopAllThreadsMonitoring();
                                }
                            } else if (keyAsString.equals("synchronizer.all-threads-monitoring.interval")) {
                                Synchronizer.startAllThreadsMonitoring(Objects.toLong(config.resolveValue("synchronizer.all-threads-monitoring.interval")));
                            }
                        }
                    }
                }
            }.listenTo(GlobalProperties);
            IterableObjectHelper = org.burningwave.core.iterable.IterableObjectHelper.create(GlobalProperties);
            String driverClassName = (String)GlobalProperties.resolveValue("jvm.driver");
            Driver = driverClassName != null ? Executor.get(() -> (Driver)StaticComponentContainer.class.getClassLoader().loadClass(driverClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) : Driver.Factory.getNew();
            ThreadSupplier = Thread.Supplier.create(StaticComponentContainer.getName("Thread supplier"), GlobalProperties, true);
            ThreadHolder = new Thread.Holder(ThreadSupplier);
            BackgroundExecutor = QueuedTasksExecutor.Group.create(StaticComponentContainer.getName("BackgroundExecutor"), ThreadSupplier, ThreadSupplier, ThreadSupplier, true, true);
            Synchronizer = org.burningwave.core.concurrent.Synchronizer.create(Optional.ofNullable(GlobalProperties.resolveStringValue("group-name-for-named-elements")).map(nm -> nm + " - ").orElseGet(() -> "") + "Synchronizer", true);
            if (Objects.toBoolean(GlobalProperties.resolveValue("background-executor.task-creation-tracking.enabled"))) {
                BackgroundExecutor.setTasksCreationTrackingFlag(true);
            }
            if (!Objects.toBoolean(GlobalProperties.resolveValue("banner.hide"))) {
                StaticComponentContainer.showBanner();
            }
            ManagedLoggersRepository = ManagedLogger.Repository.create(GlobalProperties);
            URL globalPropertiesFileUrl = propBag.getValue();
            if (globalPropertiesFileUrl != null) {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "Building static components by using " + Executor.get(() -> URLDecoder.decode(globalPropertiesFileUrl.toString(), StandardCharsets.UTF_8.name())));
            } else {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "Building static components by using default configuration");
            }
            ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "Instantiated {}", ManagedLoggersRepository.getClass().getName());
            ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "\n\n\tConfiguration values for static components:\n\n{}\n\n", GlobalProperties.toPrettyString(2));
            Paths = Strings.Paths.create();
            FileSystemHelper = org.burningwave.core.io.FileSystemHelper.create(StaticComponentContainer.getName("FileSystemHelper"));
            BufferHandler = org.burningwave.core.jvm.BufferHandler.create(GlobalProperties);
            Streams = org.burningwave.core.io.Streams.create();
            Classes = org.burningwave.core.classes.Classes.create();
            Cache = org.burningwave.core.Cache.create();
            Members = org.burningwave.core.classes.Members.create();
            Fields = org.burningwave.core.classes.Fields.create();
            Constructors = org.burningwave.core.classes.Constructors.create();
            Methods = org.burningwave.core.classes.Methods.create();
            ClassLoaders = Classes.Loaders.create();
            ByFieldOrByMethodPropertyAccessor = PropertyAccessor.ByFieldOrByMethod.create();
            ByMethodOrByFieldPropertyAccessor = PropertyAccessor.ByMethodOrByField.create();
            SourceCodeHandler = org.burningwave.core.classes.SourceCodeHandler.create();
            Runtime.getRuntime().addShutdownHook(ThreadSupplier.getOrCreate(StaticComponentContainer.getName("Resource releaser")).setExecutable(thread -> Executor.runAndIgnoreExceptions(() -> {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "... Waiting for all tasks ending before closing all component containers");
                BackgroundExecutor.waitForTasksEnding(true, true);
            }, () -> {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "Closing all component containers");
                ComponentContainer.closeAll();
            }, () -> {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "Closing FileSystemHelper");
                FileSystemHelper.close();
            }, () -> {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "... Waiting for all tasks ending before shuting down BackgroundExecutor");
                BackgroundExecutor.waitForTasksEnding(true, true);
            }, () -> {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "Shuting down BackgroundExecutor");
                BackgroundExecutor.shutDown(false);
            }, () -> {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "Stopping all threads monitoring thread");
                Synchronizer.stopAllThreadsMonitoring(false);
            }, () -> {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "Closing ThreadHolder");
                ThreadHolder.close();
            }, () -> {
                ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "Shuting down ThreadSupplier");
                ThreadSupplier.shutDownAll();
            })));
            FileSystemHelper.startSweeping();
            ManagedLoggersRepository.logInfo(StaticComponentContainer.class::getName, "{} initialized in {} seconds", StaticComponentContainer.class.getName(), Double.valueOf((double)(System.nanoTime() - startTime) / 1.0E9).toString());
            if (Objects.toBoolean(GlobalProperties.resolveValue("synchronizer.all-threads-monitoring.enabled"))) {
                Synchronizer.startAllThreadsMonitoring(Objects.toLong(GlobalProperties.resolveValue("synchronizer.all-threads-monitoring.interval")));
            }
            if (Objects.toBoolean(GlobalProperties.resolveValue("background-executor.all-tasks-monitoring.enabled"))) {
                BackgroundExecutor.startAllTasksMonitoring(StaticComponentContainer.retrieveAllTasksMonitoringConfig());
            }
            if (JVMInfo.getVersion() > 8) {
                Modules = org.burningwave.core.classes.Modules.create();
                if (Objects.toBoolean(GlobalProperties.resolveValue("modules.export-all-to-all"))) {
                    try {
                        Modules.exportAllToAll();
                    }
                    catch (Throwable exc) {
                        ManagedLoggersRepository.logError(StaticComponentContainer.class::getName, "Unable to export all modules to all modules", exc);
                    }
                }
            } else {
                Modules = null;
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            throw new RuntimeException(exc);
        }
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues.put("group-name-for-named-elements", "Burningwave");
            defaultValues.put("banner.hide", false);
            defaultValues.put("banner.file", "org/burningwave/banner.bwb");
            defaultValues.put("synchronizer.all-threads-monitoring.enabled", false);
            defaultValues.put("synchronizer.all-threads-monitoring.interval", 90000);
            defaultValues.put("background-executor.all-tasks-monitoring.enabled", true);
            defaultValues.put("background-executor.all-tasks-monitoring.minimum-elapsed-time-to-consider-a-task-as-probable-dead-locked", 300000);
            defaultValues.put("background-executor.all-tasks-monitoring.interval", 30000);
            defaultValues.put("background-executor.all-tasks-monitoring.probable-dead-locked-tasks-handling.policy", "log only");
            defaultValues.put("background-executor.task-creation-tracking.enabled", "${background-executor.all-tasks-monitoring.enabled}");
            defaultValues.put("background-executor.all-tasks-monitoring.logger.enabled", false);
            if (Info.Provider.getInfoInstance().getVersion() > 8) {
                defaultValues.put("modules.export-all-to-all", true);
            }
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            private static final String GROUP_NAME_FOR_NAMED_ELEMENTS = "group-name-for-named-elements";
            private static final String BANNER_HIDE = "banner.hide";
            private static final String BANNER_FILE = "banner.file";
            private static final String BACKGROUND_EXECUTOR_TASK_CREATION_TRACKING_ENABLED = "background-executor.task-creation-tracking.enabled";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_ENABLED = "background-executor.all-tasks-monitoring.enabled";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_MINIMUM_ELAPSED_TIME_TO_CONSIDER_A_TASK_AS_PROBABLE_DEAD_LOCKED = "background-executor.all-tasks-monitoring.minimum-elapsed-time-to-consider-a-task-as-probable-dead-locked";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_LOGGER_ENABLED = "background-executor.all-tasks-monitoring.logger.enabled";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_INTERVAL = "background-executor.all-tasks-monitoring.interval";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_PROBABLE_DEAD_LOCKED_TASKS_HANDLING_POLICY = "background-executor.all-tasks-monitoring.probable-dead-locked-tasks-handling.policy";
            private static final String JVM_DRIVER = "jvm.driver";
            private static final String MODULES_EXPORT_ALL_TO_ALL = "modules.export-all-to-all";
            private static final String SYNCHRONIZER_ALL_THREADS_MONITORING_ENABLED = "synchronizer.all-threads-monitoring.enabled";
            private static final String SYNCHRONIZER_ALL_THREADS_MONITORING_INTERVAL = "synchronizer.all-threads-monitoring.interval";
        }
    }
}

