/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.burningwave.core.classes.ByteCodeHunterImpl;
import org.burningwave.core.classes.ClassHunter;
import org.burningwave.core.classes.ClassPathScannerWithCachingSupport;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchContext;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

public interface ByteCodeHunter
extends ClassPathScannerWithCachingSupport<JavaClass, SearchResult> {
    public static ByteCodeHunter create(PathHelper pathHelper, Object defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, Properties config) {
        return new ByteCodeHunterImpl(pathHelper, defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, config);
    }

    public static class SearchResult
    extends org.burningwave.core.classes.SearchResult<JavaClass> {
        SearchResult(SearchContext<JavaClass> context) {
            super(context);
        }

        public Collection<JavaClass> getClasses() {
            return this.context.getItemsFound();
        }

        public Map<String, JavaClass> getClassesFlatMap() {
            return this.context.getItemsFoundFlatMap();
        }

        public Map<String, ByteBuffer> getByteCodesFlatMap() {
            return this.getClassesFlatMap().entrySet().stream().collect(Collectors.toMap(e -> ((JavaClass)e.getValue()).getName(), e -> ((JavaClass)e.getValue()).getByteCode()));
        }
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues.put("byte-code-hunter.default-path-scanner-class-loader.supplier.imports", "${code-executor.common.imports};${byte-code-hunter.default-path-scanner-class-loader.supplier.additional-imports};" + PathScannerClassLoader.class.getName() + ";");
            defaultValues.put("byte-code-hunter.default-path-scanner-class-loader.supplier.name", ClassHunter.class.getPackage().getName() + ".DefaultPathScannerClassLoaderRetrieverForClassHunter");
            defaultValues.put("byte-code-hunter.default-path-scanner-class-loader", componentSupplier -> componentSupplier.getPathScannerClassLoader());
            defaultValues.put("byte-code-hunter.new-isolated-path-scanner-class-loader.search-config.check-file-option", "${hunters.default-search-config.check-file-option}");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            public static final String NAME_IN_CONFIG_PROPERTIES = "byte-code-hunter";
            public static final String DEFAULT_PATH_SCANNER_CLASS_LOADER = "byte-code-hunter.default-path-scanner-class-loader";
            public static final String PATH_SCANNER_CLASS_LOADER_SEARCH_CONFIG_CHECK_FILE_OPTIONS = "byte-code-hunter.new-isolated-path-scanner-class-loader.search-config.check-file-option";
        }
    }
}

