/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.burningwave.core.Criteria;
import org.burningwave.core.classes.ClassHunterImpl;
import org.burningwave.core.classes.ClassPathScannerWithCachingSupport;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

public interface ClassHunter
extends ClassPathScannerWithCachingSupport<Class<?>, SearchResult> {
    public static ClassHunter create(PathHelper pathHelper, Object defaultPathScannerClassLoaderOrDefaultClassLoaderSupplier, Properties config) {
        return new ClassHunterImpl(pathHelper, defaultPathScannerClassLoaderOrDefaultClassLoaderSupplier, config);
    }

    public static class SearchResult
    extends org.burningwave.core.classes.SearchResult<Class<?>> {
        SearchResult(ClassHunterImpl.SearchContext context) {
            super(context);
        }

        public Map<Class<?>, Map<MemberCriteria<?, ?, ?>, Collection<Member>>> getMembers() {
            return ((ClassHunterImpl.SearchContext)this.context).getMembersFound();
        }

        public Map<MemberCriteria<?, ?, ?>, Collection<Member>> getMembersFlatMap() {
            return ((ClassHunterImpl.SearchContext)this.context).getMembersFoundFlatMap();
        }

        public Collection<Class<?>> getClasses() {
            return this.context.getItemsFound();
        }

        public Map<String, Class<?>> getClassesFlatMap() {
            return this.context.getItemsFoundFlatMap();
        }

        public <M extends Member, C extends MemberCriteria<M, C, T>, T extends Criteria.TestContext<M, C>> Collection<Member> getMembersBy(C criteria) {
            Collection<Member> membersFoundByCriteria = this.getMembersFlatMap().get(criteria);
            if (membersFoundByCriteria != null && membersFoundByCriteria.size() > 0) {
                return membersFoundByCriteria;
            }
            try (MemberCriteria criteriaCopy = this.createCriteriaCopy(criteria);){
                HashSet<Member> membersFoundByCriteriaFinal = new HashSet<Member>();
                ((ClassHunterImpl.SearchContext)this.context).getMembersFoundFlatMap().values().forEach(membersCollection -> membersCollection.stream().filter(member -> ((Criteria.TestContext)criteriaCopy.testWithFalseResultForNullEntityOrTrueResultForNullPredicate(member)).getResult()).collect(Collectors.toCollection(() -> membersFoundByCriteriaFinal)));
                HashSet<Member> hashSet = membersFoundByCriteriaFinal;
                return hashSet;
            }
        }
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues.put("class-hunter.default-path-scanner-class-loader.supplier.imports", "${code-executor.common.imports};${class-hunter.default-path-scanner-class-loader.supplier.additional-imports};" + PathScannerClassLoader.class.getName() + ";");
            defaultValues.put("class-hunter.default-path-scanner-class-loader.supplier.name", ClassHunter.class.getPackage().getName() + ".DefaultPathScannerClassLoaderRetrieverForClassHunter");
            defaultValues.put("class-hunter.default-path-scanner-class-loader", componentSupplier -> componentSupplier.getPathScannerClassLoader());
            defaultValues.put("class-hunter.new-isolated-path-scanner-class-loader.search-config.check-file-option", "${hunters.default-search-config.check-file-option}");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            public static final String NAME_IN_CONFIG_PROPERTIES = "class-hunter";
            public static final String DEFAULT_PATH_SCANNER_CLASS_LOADER = "class-hunter.default-path-scanner-class-loader";
            public static final String PATH_SCANNER_CLASS_LOADER_SEARCH_CONFIG_CHECK_FILE_OPTIONS = "class-hunter.new-isolated-path-scanner-class-loader.search-config.check-file-option";
        }
    }
}

