/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.function.Supplier;
import org.burningwave.core.Closeable;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.concurrent.Synchronizer;

class ClassLoaderManager<C extends ClassLoader>
implements Closeable {
    private Supplier<C> classLoaderSupplier;
    private Object classLoaderOrClassLoaderSupplier;
    private C classLoader;

    ClassLoaderManager(Object classLoaderOrClassLoaderSupplier) {
        this.classLoaderOrClassLoaderSupplier = classLoaderOrClassLoaderSupplier;
    }

    C get() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    C get(Object client) {
        Synchronizer.Mutex mutex;
        block22: {
            block20: {
                Object defaultClassLoaderOrDefaultClassLoaderSupplier;
                block21: {
                    C c;
                    ClassLoader classLoader;
                    Object var2_2 = null;
                    Supplier<C> defaultClassLoaderSupplier = this.classLoaderSupplier;
                    if (defaultClassLoaderSupplier != null && (classLoader = (ClassLoader)defaultClassLoaderSupplier.get()) != this.classLoader) {
                        Synchronizer.Mutex mutex2 = StaticComponentContainer.Synchronizer.getMutex(this.getOperationId("getDefaultClassLoader"));
                        try {
                            void var2_7;
                            ClassLoader classLoader2;
                            Synchronizer.Mutex mutex3 = mutex2;
                            // MONITORENTER : mutex3
                            defaultClassLoaderSupplier = this.classLoaderSupplier;
                            if (defaultClassLoaderSupplier != null && (classLoader2 = (ClassLoader)defaultClassLoaderSupplier.get()) != this.classLoader) {
                                void var2_6;
                                C oldClassLoader = this.classLoader;
                                if (oldClassLoader != null && oldClassLoader instanceof MemoryClassLoader) {
                                    ((MemoryClassLoader)oldClassLoader).unregister(this, true);
                                }
                                if (classLoader2 instanceof MemoryClassLoader) {
                                    if (!((MemoryClassLoader)classLoader2).register(this)) {
                                        C c2 = this.get(client);
                                    } else {
                                        ((MemoryClassLoader)classLoader2).register(client);
                                    }
                                }
                                this.classLoader = var2_6;
                            }
                            // MONITOREXIT : mutex3
                            return var2_7;
                        }
                        finally {
                            StaticComponentContainer.Synchronizer.removeIfUnused(mutex2);
                        }
                    }
                    if (this.classLoader != null) return this.classLoader;
                    mutex = StaticComponentContainer.Synchronizer.getMutex(this.getOperationId("getDefaultClassLoader"));
                    try {
                        Synchronizer.Mutex mutex4 = mutex;
                        // MONITORENTER : mutex4
                        if (this.classLoader != null) break block20;
                        defaultClassLoaderOrDefaultClassLoaderSupplier = ((Supplier)this.classLoaderOrClassLoaderSupplier).get();
                        if (!(defaultClassLoaderOrDefaultClassLoaderSupplier instanceof PathScannerClassLoader)) break block21;
                        this.classLoader = (ClassLoader)defaultClassLoaderOrDefaultClassLoaderSupplier;
                        ((MemoryClassLoader)this.classLoader).register(this);
                        ((MemoryClassLoader)this.classLoader).register(client);
                        c = this.classLoader;
                        // MONITOREXIT : mutex4
                        StaticComponentContainer.Synchronizer.removeIfUnused(mutex);
                    }
                    catch (Throwable throwable) {
                        StaticComponentContainer.Synchronizer.removeIfUnused(mutex);
                        throw throwable;
                    }
                    return c;
                }
                if (defaultClassLoaderOrDefaultClassLoaderSupplier instanceof Supplier) {
                    this.classLoaderSupplier = (Supplier)defaultClassLoaderOrDefaultClassLoaderSupplier;
                    C c = this.get(client);
                    // MONITOREXIT : mutex4
                    StaticComponentContainer.Synchronizer.removeIfUnused(mutex);
                    return c;
                }
                break block22;
            }
            C c = this.classLoader;
            // MONITOREXIT : mutex4
            StaticComponentContainer.Synchronizer.removeIfUnused(mutex);
            return c;
        }
        StaticComponentContainer.Synchronizer.removeIfUnused(mutex);
        return this.classLoader;
    }

    void reset() {
        StaticComponentContainer.Synchronizer.execute(this.getOperationId("getDefaultClassLoader"), () -> {
            C classLoader = this.classLoader;
            if (classLoader != null) {
                this.classLoaderSupplier = null;
                this.classLoader = null;
                if (classLoader instanceof MemoryClassLoader) {
                    ((MemoryClassLoader)classLoader).unregister(this, true);
                }
                try {
                    if (classLoader instanceof ComponentContainer.PathScannerClassLoader) {
                        ((ComponentContainer.PathScannerClassLoader)classLoader).markAsCloseable();
                    }
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Exception occurred while resetting default path scanner classloader: {}", exc.getMessage());
                }
            }
        });
    }

    @Override
    public void close() {
        this.classLoaderOrClassLoaderSupplier = null;
        this.reset();
        this.classLoaderSupplier = null;
        this.classLoader = null;
    }
}

