/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.CacheableSearchConfig;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassPathHelper;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.ClassPathHunterImpl;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchConfig;
import org.burningwave.core.concurrent.QueuedTasksExecutor;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.iterable.Properties;

class ClassPathHelperImpl
implements ClassPathHelper,
Component {
    private String instanceId = UUID.randomUUID().toString();
    private ClassPathHunter classPathHunter;
    private FileSystemItem classPathsBasePath;
    private Properties config;

    ClassPathHelperImpl(ClassPathHunter classPathHunter, Properties config) {
        this.classPathHunter = classPathHunter;
        this.classPathsBasePath = FileSystemItem.of(this.getOrCreateTemporaryFolder("classPaths"));
        this.config = config;
        this.listenTo(config);
    }

    @Override
    public String getTemporaryFolderPrefix() {
        return this.getClass().getName() + "@" + this.instanceId;
    }

    FileSystemItem.CheckingOption getClassFileCheckingOption() {
        return FileSystemItem.CheckingOption.forLabel(this.config.resolveStringValue("class-path-helper.class-path-hunter.search-config.check-file-option", ClassPathHelper.Configuration.DEFAULT_VALUES));
    }

    @Override
    public Supplier<Map<String, String>> computeByClassesSearching(Collection<String> classRepositories) {
        return this.compute(classRepositories, null, (BiPredicate<FileSystemItem, JavaClass>)null);
    }

    @Override
    public Supplier<Map<String, String>> computeByClassesSearching(Collection<String> classRepositories, ClassCriteria classCriteria) {
        return this.computeByClassesSearching(classRepositories, null, classCriteria);
    }

    @Override
    public Supplier<Map<String, String>> computeByClassesSearching(CacheableSearchConfig searchConfig) {
        return this.compute(((ClassPathHunterImpl)this.classPathHunter).retrievePathsToBeScanned(searchConfig), (Collection<String> toBeAdjuested) -> {
            searchConfig.withDefaultScanFileCriteria(FileSystemItem.Criteria.forClassTypeFiles(this.getClassFileCheckingOption()));
            try (ClassPathHunter.SearchResult result = (ClassPathHunter.SearchResult)this.classPathHunter.loadInCache(searchConfig).find();){
                Collection<FileSystemItem> collection = result.getClassPaths();
                return collection;
            }
        });
    }

    @Override
    public Supplier<Map<String, String>> computeByClassesSearching(Collection<String> classRepositories, Collection<String> pathsToBeRefreshed, ClassCriteria classCriteria) {
        CacheableSearchConfig searchConfig = (CacheableSearchConfig)((CacheableSearchConfig)SearchConfig.forPaths(classRepositories).by(classCriteria)).optimizePaths(true);
        if (pathsToBeRefreshed != null) {
            searchConfig.checkForAddedClassesForAllPathThat(pathsToBeRefreshed::contains);
        }
        return this.computeByClassesSearching(searchConfig);
    }

    @Override
    public Supplier<Map<String, String>> computeFromSources(Collection<String> sources, Collection<String> classRepositories) {
        return this.computeFromSources(sources, classRepositories, null, null);
    }

    @Override
    public Supplier<Map<String, String>> computeFromSources(Collection<String> sources, Collection<String> classRepositories, ClassCriteria otherClassCriteria) {
        HashSet<String> imports = new HashSet<String>();
        for (String sourceCode : sources) {
            imports.addAll(StaticComponentContainer.SourceCodeHandler.extractImports(sourceCode));
        }
        ClassCriteria classCriteria = ClassCriteria.create().className(className -> imports.contains(className));
        if (otherClassCriteria != null) {
            classCriteria = classCriteria.or(otherClassCriteria);
        }
        return this.computeByClassesSearching(classRepositories, classCriteria);
    }

    @Override
    @SafeVarargs
    public final Collection<String> searchWithoutTheUseOfCache(ClassCriteria classCriteria, Collection<String> ... pathColls) {
        FileSystemItem.CheckingOption checkFileOption = this.getClassFileCheckingOption();
        HashSet<String> classPaths = new HashSet<String>();
        try (ClassPathHunter.SearchResult result = (ClassPathHunter.SearchResult)this.classPathHunter.findBy((SearchConfig)((SearchConfig)((SearchConfig)((SearchConfig)SearchConfig.withoutUsingCache().addPaths(pathColls)).by(classCriteria)).withScanFileCriteria(FileSystemItem.Criteria.forClassTypeFiles(checkFileOption))).optimizePaths(true));){
            for (FileSystemItem classPath : result.getClassPaths()) {
                classPaths.add(classPath.getAbsolutePath());
                classPath.reset();
            }
        }
        return classPaths;
    }

    @Override
    public Collection<String> searchWithoutTheUseOfCache(ClassCriteria classCriteria, String ... path) {
        return this.searchWithoutTheUseOfCache(classCriteria, Arrays.asList(path));
    }

    @Override
    public Supplier<Map<String, String>> computeFromSources(Collection<String> sources, Collection<String> classRepositories, Predicate<FileSystemItem> pathsToBeRefreshedPredicate, BiPredicate<FileSystemItem, JavaClass> javaClassFilterAdditionalFilter) {
        HashSet<String> imports = new HashSet<String>();
        for (String sourceCode : sources) {
            imports.addAll(StaticComponentContainer.SourceCodeHandler.extractImports(sourceCode));
        }
        BiPredicate<FileSystemItem, JavaClass> javaClassFilter = (classFile, javaClass) -> imports.contains(javaClass.getName());
        if (javaClassFilterAdditionalFilter != null) {
            javaClassFilter = javaClassFilter.or(javaClassFilterAdditionalFilter);
        }
        return this.compute(classRepositories, pathsToBeRefreshedPredicate, javaClassFilter);
    }

    @Override
    public Supplier<Map<String, String>> compute(Collection<String> classRepositories, BiPredicate<FileSystemItem, JavaClass> javaClassProcessor) {
        return this.compute(classRepositories, null, javaClassProcessor);
    }

    @Override
    public Map<String, ClassLoader> computeAndAddAllToClassLoader(ClassLoader classLoader, Collection<String> classRepositories, String className, Collection<String> notFoundClasses) {
        return this.computeAndAddAllToClassLoader(classLoader, classRepositories, null, className, notFoundClasses);
    }

    @Override
    public Map<String, ClassLoader> computeAndAddAllToClassLoader(ClassLoader classLoader, Collection<String> classRepositories, Collection<String> pathsToBeRefreshed, String className, Collection<String> notFoundClasses) {
        String notFoundClassClassPath;
        Predicate<FileSystemItem> pathsToBeRefreshedPredicate = null;
        if (pathsToBeRefreshed != null) {
            pathsToBeRefreshedPredicate = fileSystemItem -> pathsToBeRefreshed.contains(fileSystemItem.getAbsolutePath());
        }
        HashSet notFoundClassClassPaths = new HashSet();
        BiPredicate<FileSystemItem, JavaClass> criteriaOne = (fileSystemItemCls, javaClass) -> {
            if (javaClass.getName().equals(className)) {
                String classAbsolutePath = fileSystemItemCls.getAbsolutePath();
                notFoundClassClassPaths.add(classAbsolutePath.substring(0, classAbsolutePath.lastIndexOf("/" + javaClass.getPath())));
                return true;
            }
            return false;
        };
        HashSet notFoundClassesClassPaths = new HashSet();
        BiPredicate<FileSystemItem, JavaClass> criteriaTwo = (fileSystemItemCls, javaClass) -> {
            for (String notFoundClass : notFoundClasses) {
                if (!javaClass.getName().equals(notFoundClass)) continue;
                String classAbsolutePath = fileSystemItemCls.getAbsolutePath();
                notFoundClassesClassPaths.add(classAbsolutePath.substring(0, classAbsolutePath.lastIndexOf("/" + javaClass.getPath())));
                return true;
            }
            return false;
        };
        Map<String, String> classPaths = this.compute(classRepositories, pathsToBeRefreshedPredicate, criteriaOne.or(criteriaTwo)).get();
        ClassLoader targetClassLoader = classLoader;
        HashSet<String> classPathsToLoad = new HashSet<String>();
        if (!notFoundClassClassPaths.isEmpty() && (targetClassLoader = StaticComponentContainer.ClassLoaders.getClassLoaderOfPath(classLoader, notFoundClassClassPath = (String)notFoundClassClassPaths.stream().findFirst().get())) == null) {
            String notFoundComputedClassClassPath = classPaths.get(notFoundClassClassPath);
            if (!notFoundComputedClassClassPath.equals(notFoundClassClassPath)) {
                targetClassLoader = StaticComponentContainer.ClassLoaders.getClassLoaderOfPath(classLoader, notFoundComputedClassClassPath);
                if (targetClassLoader == null) {
                    classPathsToLoad.add(notFoundComputedClassClassPath);
                }
            } else {
                classPathsToLoad.add(notFoundComputedClassClassPath);
            }
        }
        if (targetClassLoader == null) {
            targetClassLoader = classLoader;
        }
        HashMap<String, ClassLoader> addedClassPathsForClassLoader = new HashMap<String, ClassLoader>();
        if (!(targetClassLoader instanceof PathScannerClassLoader)) {
            for (String classPath : notFoundClassesClassPaths) {
                classPathsToLoad.add(classPaths.get(classPath));
            }
            for (String classPath : classPathsToLoad) {
                if (!StaticComponentContainer.ClassLoaders.addClassPath(targetClassLoader, absolutePath -> pathsToBeRefreshed != null && pathsToBeRefreshed.contains(absolutePath), classPath).isEmpty()) {
                    StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Added class path {} to {}", classPath, targetClassLoader.toString());
                    addedClassPathsForClassLoader.put(classPath, targetClassLoader);
                    continue;
                }
                StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "Class path {} already present in {}", classPath, targetClassLoader.toString());
            }
        } else {
            PathScannerClassLoader pathScannerClassLoader = (PathScannerClassLoader)targetClassLoader;
            classPathsToLoad = new HashSet();
            if (!notFoundClassClassPaths.isEmpty()) {
                classPathsToLoad.addAll(notFoundClassClassPaths);
            }
            if (!notFoundClassesClassPaths.isEmpty()) {
                classPathsToLoad.addAll(notFoundClassesClassPaths);
            }
            for (String addedClassPath : pathScannerClassLoader.scanPathsAndAddAllByteCodesFound(classPathsToLoad, absolutePath -> pathsToBeRefreshed != null && pathsToBeRefreshed.contains(absolutePath))) {
                addedClassPathsForClassLoader.put(addedClassPath, pathScannerClassLoader);
            }
        }
        return addedClassPathsForClassLoader;
    }

    @Override
    public Supplier<Map<String, String>> compute(Collection<String> classRepositories, Predicate<FileSystemItem> pathsToBeRefreshedPredicate, BiPredicate<FileSystemItem, JavaClass> javaClassFilter) {
        FileSystemItem.Criteria classFileFilter = FileSystemItem.Criteria.forClassTypeFiles(this.getClassFileCheckingOption());
        Predicate<FileSystemItem> finalPathsToBeRefreshedPredicate = pathsToBeRefreshedPredicate != null ? pathsToBeRefreshedPredicate : fileSystemItem -> false;
        BiPredicate<FileSystemItem, JavaClass> finalJavaClassFilter = javaClassFilter != null ? javaClassFilter : (fileSystemItem, javaClass) -> true;
        return this.compute(classRepositories, null, (Collection<String> clsRepositories) -> {
            ConcurrentHashMap.KeySetView classPaths = ConcurrentHashMap.newKeySet();
            for (String classRepositoryPath : clsRepositories) {
                FileSystemItem classRepository = FileSystemItem.ofPath(classRepositoryPath);
                if (finalPathsToBeRefreshedPredicate.test(classRepository)) {
                    classRepository.refresh();
                }
                classRepository.findInAllChildren(((FileSystemItem.Criteria)classFileFilter.and()).allFileThat(fileSystemItemCls -> JavaClass.extractByUsing(fileSystemItemCls.toByteBuffer(), javaClass -> {
                    if (finalJavaClassFilter.test((FileSystemItem)fileSystemItemCls, (JavaClass)javaClass)) {
                        String classAbsolutePath = fileSystemItemCls.getAbsolutePath();
                        classPaths.add(FileSystemItem.ofPath(classAbsolutePath.substring(0, classAbsolutePath.lastIndexOf("/" + javaClass.getPath()))));
                        return true;
                    }
                    return false;
                })).setDefaultExceptionHandler());
            }
            return classPaths;
        });
    }

    private Supplier<Map<String, String>> compute(Collection<String> classRepositories, Function<Collection<String>, Collection<FileSystemItem>> adjustedClassPathsSupplier) {
        return this.compute(classRepositories, (FileSystemItem fileSystemItem) -> false, adjustedClassPathsSupplier);
    }

    private Supplier<Map<String, String>> compute(Collection<String> classRepositories, Predicate<FileSystemItem> pathsToBeRefreshedPredicate, Function<Collection<String>, Collection<FileSystemItem>> callRepositoriesSupplier) {
        HashMap<String, String> classPaths = new HashMap<String, String>();
        Collection<FileSystemItem> effectiveClassPaths = callRepositoriesSupplier.apply(classRepositories);
        HashSet pathsCreationTasks = new HashSet();
        if (pathsToBeRefreshedPredicate == null) {
            pathsToBeRefreshedPredicate = fileSystemItem -> false;
        }
        if (!effectiveClassPaths.isEmpty()) {
            for (FileSystemItem fsObject : effectiveClassPaths) {
                if (pathsToBeRefreshedPredicate.test(fsObject)) {
                    fsObject.refresh();
                }
                if (fsObject.isCompressed()) {
                    Executor.run(() -> {
                        ClassPathHelperImpl classPathHelperImpl = this;
                        synchronized (classPathHelperImpl) {
                            FileSystemItem classPath = FileSystemItem.ofPath(this.classPathsBasePath.getAbsolutePath() + "/" + StaticComponentContainer.Paths.toSquaredPath(fsObject.getAbsolutePath(), fsObject.isFolder()));
                            if (!classPath.refresh().exists()) {
                                pathsCreationTasks.add((QueuedTasksExecutor.ProducerTask)StaticComponentContainer.BackgroundExecutor.createTask(() -> {
                                    FileSystemItem copy = fsObject.copyTo(this.classPathsBasePath.getAbsolutePath());
                                    File target = new File(classPath.getAbsolutePath());
                                    new File(copy.getAbsolutePath()).renameTo(target);
                                    return StaticComponentContainer.Paths.clean(target.getAbsolutePath());
                                }).submit());
                            }
                            classPaths.put(fsObject.getAbsolutePath(), classPath.getAbsolutePath());
                            classPath.destroy();
                        }
                    });
                    continue;
                }
                classPaths.put(fsObject.getAbsolutePath(), fsObject.getAbsolutePath());
            }
        }
        return () -> {
            pathsCreationTasks.stream().forEach(pathsCreationTask -> pathsCreationTask.join());
            return classPaths;
        };
    }

    @Override
    public void close() {
        this.closeResources(() -> this.classPathsBasePath == null, () -> {
            this.unregister(this.config);
            StaticComponentContainer.FileSystemHelper.deleteOnExit(this.getOrCreateTemporaryFolder());
            this.classPathsBasePath.destroy();
            this.classPathsBasePath = null;
            this.classPathHunter = null;
            this.config = null;
            this.instanceId = null;
        });
    }
}

