/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.ClassPathScannerWithCachingSupport;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.SearchConfigAbst;
import org.burningwave.core.classes.SearchContext;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

class ClassPathHunterImpl
extends ClassPathScannerWithCachingSupport.Abst<Collection<Class<?>>, SearchContext, ClassPathHunter.SearchResult>
implements ClassPathHunter {
    ClassPathHunterImpl(PathHelper pathHelper, Object defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, Properties config) {
        super(pathHelper, initContext -> SearchContext._create(initContext), context -> new ClassPathHunter.SearchResult((SearchContext)context), defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, config);
    }

    @Override
    String getNameInConfigProperties() {
        return "class-path-hunter";
    }

    @Override
    String getDefaultPathScannerClassLoaderNameInConfigProperties() {
        return "class-path-hunter.default-path-scanner-class-loader";
    }

    @Override
    String getDefaultPathScannerClassLoaderCheckFileOptionsNameInConfigProperties() {
        return "class-path-hunter.new-isolated-path-scanner-class-loader.search-config.check-file-option";
    }

    @Override
    <S extends SearchConfigAbst<S>> ClassCriteria.TestContext testCachedItem(SearchContext context, String baseAbsolutePath, String currentScannedItemAbsolutePath, Collection<Class<?>> classes) {
        ClassCriteria.TestContext testContext;
        for (Class<?> cls : classes) {
            testContext = context.test(context.retrieveClass(cls));
            if (!testContext.getResult().booleanValue()) continue;
            return testContext;
        }
        testContext = context.test(null);
        return testContext;
    }

    @Override
    ClassCriteria.TestContext testPathAndCachedItem(SearchContext context, FileSystemItem[] cachedItemPathAndBasePath, Collection<Class<?>> classes, Predicate<FileSystemItem[]> fileFilterPredicate) {
        AtomicReference criteriaTestContextAR = new AtomicReference();
        cachedItemPathAndBasePath[0].findFirstInAllChildren(FileSystemItem.Criteria.forAllFileThat((child, basePath) -> {
            boolean matchPredicate = false;
            matchPredicate = fileFilterPredicate.test(new FileSystemItem[]{child, basePath});
            if (matchPredicate) {
                criteriaTestContextAR.set(this.testCachedItem(context, cachedItemPathAndBasePath[1].getAbsolutePath(), cachedItemPathAndBasePath[0].getAbsolutePath(), classes));
            }
            return matchPredicate;
        }));
        return criteriaTestContextAR.get() != null ? (ClassCriteria.TestContext)criteriaTestContextAR.get() : context.test(null);
    }

    @Override
    void iterateAndTestCachedPaths(SearchContext context, String basePath, Map<String, Collection<Class<?>>> itemsForPath, FileSystemItem.Criteria fileFilter) {
        if (fileFilter.hasNoExceptionHandler()) {
            fileFilter = fileFilter.createCopy().setDefaultExceptionHandler();
        }
        for (Map.Entry<String, Collection<Class<?>>> cachedItemAsEntry : itemsForPath.entrySet()) {
            String absolutePathOfItem = cachedItemAsEntry.getKey();
            try {
                if (FileSystemItem.ofPath(absolutePathOfItem).findFirstInAllChildren(fileFilter) == null) continue;
                context.addItemFound(basePath, cachedItemAsEntry.getKey(), cachedItemAsEntry.getValue());
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Could not test cached entry of path " + absolutePathOfItem, exc);
            }
        }
    }

    @Override
    void addToContext(SearchContext context, ClassCriteria.TestContext criteriaTestContext, String basePath, FileSystemItem fileSystemItem, JavaClass javaClass) {
        String classPath = fileSystemItem.getAbsolutePath();
        FileSystemItem classPathAsFIS = FileSystemItem.ofPath(classPath.substring(0, classPath.lastIndexOf(javaClass.getPath())));
        context.addItemFound(basePath, classPathAsFIS.getAbsolutePath(), context.loadClass(javaClass.getName()));
    }

    @Override
    public void close() {
        this.closeResources(() -> this.cache == null, () -> super.close());
    }

    static class SearchContext
    extends org.burningwave.core.classes.SearchContext<Collection<Class<?>>> {
        SearchContext(SearchContext.InitContext initContext) {
            super(initContext);
        }

        static SearchContext _create(SearchContext.InitContext initContext) {
            return new SearchContext(initContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void addItemFound(String basePathAsString, String classPathAsFile, Class<?> testedClass) {
            Map testedClassesForClassPathMap = this.retrieveCollectionForPath(this.itemsFoundMap, ConcurrentHashMap::new, basePathAsString);
            ConcurrentHashMap.KeySetView testedClassesForClassPath = (ConcurrentHashMap.KeySetView)testedClassesForClassPathMap.get(classPathAsFile);
            if (testedClassesForClassPath == null) {
                Map map = testedClassesForClassPathMap;
                synchronized (map) {
                    testedClassesForClassPath = (Collection)testedClassesForClassPathMap.get(classPathAsFile);
                    if (testedClassesForClassPath == null) {
                        testedClassesForClassPath = ConcurrentHashMap.newKeySet();
                        testedClassesForClassPathMap.put(classPathAsFile, testedClassesForClassPath);
                    }
                }
            }
            testedClassesForClassPath.add(testedClass);
            this.itemsFoundFlatMap.putAll(testedClassesForClassPathMap);
        }
    }
}

