/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassLoaderManager;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchConfig;
import org.burningwave.core.classes.SearchConfigAbst;
import org.burningwave.core.classes.SearchContext;
import org.burningwave.core.classes.SearchResult;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

public interface ClassPathScanner<I, R extends SearchResult<I>> {
    public R find();

    public R findBy(SearchConfig var1);

    public static abstract class Abst<I, C extends SearchContext<I>, R extends SearchResult<I>>
    implements Component {
        PathHelper pathHelper;
        Function<SearchContext.InitContext, C> contextSupplier;
        Function<C, R> resultSupplier;
        Properties config;
        Collection<SearchResult<I>> searchResults;
        String instanceId;
        ClassLoaderManager<PathScannerClassLoader> defaultPathScannerClassLoaderManager;

        Abst(PathHelper pathHelper, Function<SearchContext.InitContext, C> contextSupplier, Function<C, R> resultSupplier, Object defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, Properties config) {
            this.pathHelper = pathHelper;
            this.contextSupplier = contextSupplier;
            this.resultSupplier = resultSupplier;
            this.config = config;
            this.searchResults = ConcurrentHashMap.newKeySet();
            this.instanceId = StaticComponentContainer.Objects.getCurrentId(this);
            this.defaultPathScannerClassLoaderManager = new ClassLoaderManager(defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier);
            this.listenTo(config);
        }

        @Override
        public <K, V> void processChangeNotification(Properties properties, Properties.Event event, K key, V newValue, V previousValue) {
            String keyAsString;
            if (event.name().equals(Properties.Event.PUT.name()) && key instanceof String && (keyAsString = (String)key).startsWith(this.getNameInConfigProperties() + ".default-path-scanner-class-loader")) {
                this.defaultPathScannerClassLoaderManager.reset();
            }
        }

        abstract String getNameInConfigProperties();

        abstract String getDefaultPathScannerClassLoaderNameInConfigProperties();

        abstract String getDefaultPathScannerClassLoaderCheckFileOptionsNameInConfigProperties();

        PathScannerClassLoader getDefaultPathScannerClassLoader(Object client) {
            return this.defaultPathScannerClassLoaderManager.get(client);
        }

        public R find() {
            return this.findBy(SearchConfig.withoutUsingCache());
        }

        public R findBy(SearchConfig searchConfig) {
            return this.findBy(searchConfig, this::searchInFileSystem);
        }

        R findBy(SearchConfigAbst<?> input, Consumer<C> searcher) {
            if (input.defaultScanFileCriteriaSupplier == null) {
                input.withDefaultScanFileCriteria(FileSystemItem.Criteria.forClassTypeFiles(this.config.resolveStringValue("hunters.default-search-config.check-file-option")));
            }
            Object searchConfig = input.createCopy();
            C context = this.createContext((SearchConfigAbst<?>)searchConfig);
            ((SearchConfigAbst)searchConfig).init(((SearchContext)context).pathScannerClassLoader);
            Collection<String> paths = ((SearchConfigAbst)searchConfig).getPaths();
            if (((SearchConfigAbst)searchConfig).getResourceSupllier() != null) {
                ((SearchConfigAbst)searchConfig).getResourceSupllier().accept(((SearchContext)context).pathScannerClassLoader, paths);
            }
            if (paths.isEmpty()) {
                ((SearchConfigAbst)searchConfig).addPaths(this.pathHelper.getPaths(Configuration.Key.DEFAULT_SEARCH_CONFIG_PATHS));
            }
            if (((SearchConfigAbst)searchConfig).optimizePaths) {
                this.pathHelper.optimize(paths);
            }
            ((SearchContext)context).executeSearch(searcher);
            Collection<String> skippedClassesNames = ((SearchContext)context).getSkippedClassNames();
            if (!skippedClassesNames.isEmpty()) {
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Skipped classes count: {}", skippedClassesNames.size());
            }
            SearchResult searchResult = (SearchResult)this.resultSupplier.apply(context);
            searchResult.setClassPathScanner(this);
            return (R)searchResult;
        }

        Collection<String> retrievePathsToBeScanned(SearchConfigAbst<?> searchConfig) {
            HashSet<String> paths = new HashSet<String>(searchConfig.getPaths());
            if (searchConfig.getResourceSupllier() != null) {
                searchConfig = searchConfig.createCopy();
                try (C context = this.createContext(searchConfig);){
                    searchConfig.getResourceSupllier().accept(((SearchContext)context).pathScannerClassLoader, paths);
                }
            }
            if (paths.isEmpty()) {
                paths.addAll(this.pathHelper.getPaths(Configuration.Key.DEFAULT_SEARCH_CONFIG_PATHS));
            }
            return paths;
        }

        void searchInFileSystem(C context) {
            Object searchConfig = ((SearchContext)context).getSearchConfig();
            FileSystemItem.Criteria filter = this.buildFileAndClassTesterAndExecutor(context, ((SearchConfigAbst)searchConfig).buildScanFileCriteria());
            StaticComponentContainer.IterableObjectHelper.iterateParallelIf(((SearchConfigAbst)((SearchContext)context).getSearchConfig()).getPaths(), basePath -> FileSystemItem.ofPath(basePath).refresh().findInAllChildren(filter), item -> item.size() > 1);
        }

        FileSystemItem.Criteria buildFileAndClassTesterAndExecutor(C context, FileSystemItem.Criteria fileFilter) {
            Predicate<FileSystemItem[]> classFilePredicate = fileFilter.getOriginalPredicateOrTruePredicateIfPredicateIsNull();
            FileSystemItem.Criteria classTesterAndExecutor = FileSystemItem.Criteria.forAllFileThat((child, basePath) -> {
                boolean isClass = false;
                isClass = classFilePredicate.test(new FileSystemItem[]{child, basePath});
                if (isClass) {
                    this.analyzeAndAddItemsToContext(context, (FileSystemItem)child, (FileSystemItem)basePath);
                }
                return isClass;
            });
            if (fileFilter.hasNoExceptionHandler()) {
                classTesterAndExecutor.setDefaultExceptionHandler();
            } else {
                classTesterAndExecutor.setExceptionHandler(fileFilter.getExceptionHandler());
            }
            return classTesterAndExecutor;
        }

        void analyzeAndAddItemsToContext(C context, FileSystemItem child, FileSystemItem basePath) {
            JavaClass.use(child.toByteBuffer(), javaClass -> {
                ClassCriteria.TestContext criteriaTestContext = this.testClassCriteria(context, (JavaClass)javaClass);
                if (criteriaTestContext.getResult().booleanValue()) {
                    this.addToContext(context, criteriaTestContext, basePath.getAbsolutePath(), child, (JavaClass)javaClass);
                }
            });
        }

        C createContext(SearchConfigAbst<?> searchConfig) {
            PathScannerClassLoader defaultPathScannerClassLoader = this.getDefaultPathScannerClassLoader(searchConfig);
            if (searchConfig.useDefaultPathScannerClassLoaderAsParent) {
                searchConfig.parentClassLoaderForPathScannerClassLoader = defaultPathScannerClassLoader;
            }
            SearchContext context = (SearchContext)this.contextSupplier.apply(SearchContext.InitContext.create(defaultPathScannerClassLoader, searchConfig.useDefaultPathScannerClassLoader ? defaultPathScannerClassLoader : PathScannerClassLoader.create(searchConfig.parentClassLoaderForPathScannerClassLoader, this.pathHelper, ((SearchConfigAbst)searchConfig.withDefaultScanFileCriteria(FileSystemItem.Criteria.forClassTypeFiles(this.config.resolveStringValue(this.getDefaultPathScannerClassLoaderCheckFileOptionsNameInConfigProperties())))).buildScanFileCriteria()), searchConfig));
            return (C)context;
        }

        <S extends SearchConfigAbst<S>> ClassCriteria.TestContext testClassCriteria(C context, JavaClass javaClass) {
            return ((SearchContext)context).test(((SearchContext)context).loadClass(javaClass.getName()));
        }

        abstract void addToContext(C var1, ClassCriteria.TestContext var2, String var3, FileSystemItem var4, JavaClass var5);

        boolean register(SearchResult<I> searchResult) {
            this.searchResults.add(searchResult);
            return true;
        }

        boolean unregister(SearchResult<I> searchResult) {
            this.searchResults.remove(searchResult);
            return true;
        }

        public synchronized void closeSearchResults() {
            Collection<SearchResult<I>> searchResults = this.searchResults;
            if (searchResults != null) {
                for (SearchResult<I> searchResult : searchResults) {
                    searchResult.close();
                }
            }
        }

        @Override
        public void close() {
            this.unregister(this.config);
            this.pathHelper = null;
            this.contextSupplier = null;
            this.config = null;
            this.closeSearchResults();
            this.searchResults = null;
        }
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            defaultValues.put(Key.DEFAULT_SEARCH_CONFIG_PATHS, PathHelper.Configuration.Key.MAIN_CLASS_PATHS_PLACE_HOLDER + PathHelper.Configuration.getPathsSeparator() + "${" + PathHelper.Configuration.Key.MAIN_CLASS_PATHS_EXTENSION + "}" + PathHelper.Configuration.getPathsSeparator() + "${" + PathHelper.Configuration.Key.MAIN_CLASS_REPOSITORIES + "}" + PathHelper.Configuration.getPathsSeparator());
            defaultValues.put("hunters.default-search-config.check-file-option", "${path-scanner-class-loader.search-config.check-file-option}");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            public static final String DEFAULT_CHECK_FILE_OPTIONS = "hunters.default-search-config.check-file-option";
            public static final String DEFAULT_SEARCH_CONFIG_PATHS = PathHelper.Configuration.Key.PATHS_PREFIX + "hunters.default-search-config.paths";
        }
    }
}

