/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.CacheableSearchConfig;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassPathScanner;
import org.burningwave.core.classes.SearchConfig;
import org.burningwave.core.classes.SearchConfigAbst;
import org.burningwave.core.classes.SearchContext;
import org.burningwave.core.classes.SearchResult;
import org.burningwave.core.concurrent.Synchronizer;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

public interface ClassPathScannerWithCachingSupport<I, R extends SearchResult<I>>
extends ClassPathScanner<I, R> {
    public void clearCache();

    public CacheScanner<I, R> loadInCache(CacheableSearchConfig var1);

    public R findAndCache();

    public R findBy(CacheableSearchConfig var1);

    public void clearCache(boolean var1);

    @FunctionalInterface
    public static interface CacheScanner<I, R extends SearchResult<I>> {
        public R findBy(CacheableSearchConfig var1);

        default public R find() {
            return this.findBy(null);
        }
    }

    public static abstract class Abst<I, C extends SearchContext<I>, R extends SearchResult<I>>
    extends ClassPathScanner.Abst<I, C, R> {
        Map<String, Map<String, I>> cache = new ConcurrentHashMap<String, Map<String, I>>();

        Abst(PathHelper pathHelper, Function<SearchContext.InitContext, C> contextSupplier, Function<C, R> resultSupplier, Object defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, Properties config) {
            super(pathHelper, contextSupplier, resultSupplier, defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, config);
        }

        public void clearCache() {
            this.clearCache(false);
        }

        public CacheScanner<I, R> loadInCache(CacheableSearchConfig searchConfig) {
            CacheableSearchConfig flatSearchConfig = SearchConfig.forPaths(this.retrievePathsToBeScanned(searchConfig));
            R result = this.findBy(flatSearchConfig);
            if (result != null) {
                ((SearchResult)result).close();
            }
            return srcCfg -> this.findBy(srcCfg == null ? searchConfig : srcCfg);
        }

        public R findAndCache() {
            return this.findBy(SearchConfig.create());
        }

        public R findBy(CacheableSearchConfig searchConfig) {
            return this.findBy(searchConfig, this::searchInCacheOrInFileSystem);
        }

        public void clearCache(boolean closeSearchResults) {
            this.defaultPathScannerClassLoaderManager.reset();
            if (closeSearchResults) {
                this.closeSearchResults();
            }
            HashSet<String> pathsToBeRemoved = new HashSet<String>(this.cache.keySet());
            for (String path : pathsToBeRemoved) {
                StaticComponentContainer.Synchronizer.execute(this.instanceId + "_" + path, () -> {
                    FileSystemItem.ofPath(path).reset();
                    Map<String, I> items = this.cache.remove(path);
                    this.clearItemsForPath(items);
                });
            }
        }

        void searchInCacheOrInFileSystem(C context) {
            StaticComponentContainer.IterableObjectHelper.iterateParallelIf(((SearchConfigAbst)((SearchContext)context).getSearchConfig()).getPaths(), basePath -> this.searchInCacheOrInFileSystem((String)basePath, context), item -> item.size() > 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void searchInCacheOrInFileSystem(String basePath, C context) {
            Map<String, I> classesForPath;
            CacheableSearchConfig searchConfig = (CacheableSearchConfig)((SearchContext)context).getSearchConfig();
            FileSystemItem.Criteria fileFilter = searchConfig.buildScanFileCriteria();
            FileSystemItem.Criteria filterAndExecutor = this.buildFileAndClassTesterAndExecutor(context, fileFilter);
            boolean scanFileCriteriaHasNoPredicate = searchConfig.scanFileCriteriaHasNoPredicate();
            boolean classCriteriaHasNoPredicate = searchConfig.getClassCriteria().hasNoPredicate();
            FileSystemItem currentScannedPath = FileSystemItem.ofPath(basePath);
            BiPredicate<SearchConfigAbst<?>, String> refreshCache = searchConfig.getCheckForAddedClassesPredicate();
            if (refreshCache != null && refreshCache.test(searchConfig, basePath)) {
                StaticComponentContainer.Synchronizer.execute(this.instanceId + "_" + basePath, () -> Optional.ofNullable(this.cache.get(basePath)).ifPresent(classesForPath -> {
                    this.cache.remove(basePath);
                    classesForPath.clear();
                }));
                currentScannedPath.refresh();
            }
            if ((classesForPath = this.cache.get(basePath)) == null) {
                if (classCriteriaHasNoPredicate && scanFileCriteriaHasNoPredicate) {
                    Synchronizer.Mutex mutex;
                    Synchronizer.Mutex mutex2 = mutex = StaticComponentContainer.Synchronizer.getMutex(this.instanceId + "_" + basePath);
                    synchronized (mutex2) {
                        classesForPath = this.cache.get(basePath);
                        if (classesForPath == null) {
                            currentScannedPath.findInAllChildren(filterAndExecutor);
                            ConcurrentHashMap itemsForPath = new ConcurrentHashMap();
                            Map itemsFound = ((SearchContext)context).getItemsFound(basePath);
                            if (itemsFound != null) {
                                itemsForPath.putAll(itemsFound);
                            }
                            this.cache.put(basePath, itemsForPath);
                            StaticComponentContainer.Synchronizer.removeIfUnused(mutex);
                            return;
                        }
                        StaticComponentContainer.Synchronizer.removeIfUnused(mutex);
                    }
                    ((SearchContext)context).addAllItemsFound(basePath, classesForPath);
                    return;
                }
                currentScannedPath.findInAllChildren(filterAndExecutor);
                return;
            }
            if (classCriteriaHasNoPredicate && scanFileCriteriaHasNoPredicate) {
                ((SearchContext)context).addAllItemsFound(basePath, classesForPath);
            } else if (scanFileCriteriaHasNoPredicate) {
                this.iterateAndTestCachedItems(context, basePath, classesForPath);
            } else if (classCriteriaHasNoPredicate) {
                this.iterateAndTestCachedPaths(context, basePath, classesForPath, fileFilter);
            } else {
                this.iterateAndTestCachedPathsAndItems(context, basePath, classesForPath, fileFilter);
            }
        }

        void iterateAndTestCachedPaths(C context, String basePath, Map<String, I> itemsForPath, FileSystemItem.Criteria fileFilter) {
            FileSystemItem basePathFSI = FileSystemItem.ofPath(basePath);
            FileSystemItem[] currentChildPathAndBasePath = new FileSystemItem[]{null, basePathFSI};
            Predicate<FileSystemItem[]> fileFilterPredicate = fileFilter.getPredicateOrTruePredicateIfPredicateIsNull();
            for (Map.Entry<String, I> cachedItemAsEntry : itemsForPath.entrySet()) {
                String absolutePathOfItem = cachedItemAsEntry.getKey();
                try {
                    currentChildPathAndBasePath[0] = FileSystemItem.ofPath(absolutePathOfItem);
                    if (!fileFilterPredicate.test(currentChildPathAndBasePath)) continue;
                    ((SearchContext)context).addItemFound(basePath, cachedItemAsEntry.getKey(), cachedItemAsEntry.getValue());
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Could not test cached entry of path " + absolutePathOfItem, exc);
                }
            }
        }

        final <S extends SearchConfigAbst<S>> void iterateAndTestCachedPathsAndItems(C context, String basePath, Map<String, I> itemsForPath, FileSystemItem.Criteria fileFilter) {
            FileSystemItem basePathFSI = FileSystemItem.ofPath(basePath);
            FileSystemItem[] currentChildPathAndBasePath = new FileSystemItem[]{null, basePathFSI};
            Predicate<FileSystemItem[]> fileFilterPredicate = fileFilter.getPredicateOrTruePredicateIfPredicateIsNull();
            for (Map.Entry<String, I> cachedItemAsEntry : itemsForPath.entrySet()) {
                String absolutePathOfItem = cachedItemAsEntry.getKey();
                try {
                    currentChildPathAndBasePath[0] = FileSystemItem.ofPath(absolutePathOfItem);
                    ClassCriteria.TestContext testContext = this.testPathAndCachedItem(context, currentChildPathAndBasePath, cachedItemAsEntry.getValue(), fileFilterPredicate);
                    if (!testContext.getResult().booleanValue()) continue;
                    this.addCachedItemToContext(context, testContext, basePath, cachedItemAsEntry);
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Could not test cached entry of path " + absolutePathOfItem, exc);
                }
            }
        }

        void iterateAndTestCachedItems(C context, String basePath, Map<String, I> itemsForPath) {
            for (Map.Entry<String, I> cachedItemAsEntry : itemsForPath.entrySet()) {
                String absolutePathOfItem = cachedItemAsEntry.getKey();
                try {
                    ClassCriteria.TestContext testContext = this.testCachedItem(context, basePath, absolutePathOfItem, cachedItemAsEntry.getValue());
                    if (!testContext.getResult().booleanValue()) continue;
                    this.addCachedItemToContext(context, testContext, basePath, cachedItemAsEntry);
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Could not test cached entry of path " + absolutePathOfItem, exc);
                }
            }
        }

        ClassCriteria.TestContext testPath(C context, FileSystemItem[] filesToBeTested, Predicate<FileSystemItem[]> fileFilterPredicate) {
            if (fileFilterPredicate.test(filesToBeTested)) {
                return (ClassCriteria.TestContext)((SearchConfigAbst)((SearchContext)context).getSearchConfig()).getClassCriteria().testWithTrueResultForNullEntityOrTrueResultForNullPredicate(null);
            }
            return ((SearchContext)context).test(null);
        }

        ClassCriteria.TestContext testPathAndCachedItem(C context, FileSystemItem[] filesToBeTested, I item, Predicate<FileSystemItem[]> fileFilterPredicate) {
            if (fileFilterPredicate.test(filesToBeTested)) {
                return this.testCachedItem(context, filesToBeTested[1].getAbsolutePath(), filesToBeTested[0].getAbsolutePath(), item);
            }
            return ((SearchContext)context).test(null);
        }

        <S extends SearchConfigAbst<S>> void addCachedItemToContext(C context, ClassCriteria.TestContext testContext, String path, Map.Entry<String, I> cachedItemAsEntry) {
            ((SearchContext)context).addItemFound(path, cachedItemAsEntry.getKey(), cachedItemAsEntry.getValue());
        }

        abstract <S extends SearchConfigAbst<S>> ClassCriteria.TestContext testCachedItem(C var1, String var2, String var3, I var4);

        void clearItemsForPath(Map<String, I> items) {
            if (items != null) {
                items.clear();
            }
        }

        boolean isClosed() {
            return this.cache == null;
        }

        @Override
        public void close() {
            this.clearCache(false);
            this.cache = null;
            this.pathHelper = null;
            this.contextSupplier = null;
            super.close();
        }
    }
}

