/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.burningwave.core.Closeable;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.MembersRetriever;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.classes.MethodCriteria;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemItem;

public class Classes
implements MembersRetriever {
    Field[] emtpyFieldsArray = new Field[0];
    Method[] emptyMethodsArray = new Method[0];
    Constructor<?>[] emptyConstructorsArray = new Constructor[0];

    private Classes() {
    }

    public static Classes create() {
        return new Classes();
    }

    public <T> Class<T> retrieveFrom(Object object) {
        return object != null ? object.getClass() : null;
    }

    public Class<?>[] retrieveFrom(Object ... objects) {
        Class[] classes = null;
        if (objects != null) {
            classes = new Class[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) continue;
                classes[i] = this.retrieveFrom(objects[i]);
            }
        } else {
            classes = new Class[]{null};
        }
        return classes;
    }

    public String retrieveName(Throwable exc) {
        String className = exc.getMessage();
        if (className != null) {
            if (className.contains("Could not initialize class ")) {
                className = className.replace("Could not initialize class ", "");
            }
            if (className.contains("NoClassDefFoundError: ")) {
                className = className.substring(className.lastIndexOf("NoClassDefFoundError: ") + "NoClassDefFoundError: ".length());
            }
            if (className.contains("class: ")) {
                className = className.substring(className.lastIndexOf("class: ") + "class: ".length());
            }
            return className.contains(" ") ? null : className.replace("/", ".");
        }
        return className;
    }

    public Collection<String> retrieveNames(Throwable exc) {
        LinkedHashSet<String> classesName = new LinkedHashSet<String>();
        Optional.ofNullable(this.retrieveName(exc)).map(classesName::add);
        if (exc.getCause() != null) {
            classesName.addAll(this.retrieveNames(exc.getCause()));
        }
        return classesName;
    }

    public String retrievePackageName(String className) {
        String packageName = null;
        if (className.contains(".")) {
            packageName = className.substring(0, className.lastIndexOf("."));
        }
        return packageName;
    }

    public String retrieveSimpleName(String className) {
        String classSimpleName = null;
        classSimpleName = className.contains(".") ? className.substring(className.lastIndexOf(".") + 1) : className;
        if (classSimpleName.contains("$")) {
            classSimpleName = classSimpleName.substring(classSimpleName.lastIndexOf("$") + 1);
        }
        return classSimpleName;
    }

    public String toPath(Class<?> cls) {
        String path = cls.getSimpleName().replace(".", "$");
        Package pckg = cls.getPackage();
        if (pckg != null) {
            path = pckg.getName().replace(".", "/") + "/" + path + ".class";
        }
        return path;
    }

    public String toPath(String className) {
        return className.replace(".", "/");
    }

    public String retrieveName(byte[] classFileBuffer) {
        return io.github.toolfactory.jvm.util.Classes.retrieveName((byte[])classFileBuffer);
    }

    public String retrieveName(ByteBuffer classFileBuffer) {
        return io.github.toolfactory.jvm.util.Classes.retrieveName((ByteBuffer)classFileBuffer);
    }

    public ClassLoader getClassLoader(Class<?> cls) {
        ClassLoader clsLoader = cls.getClassLoader();
        if (clsLoader == null) {
            clsLoader = ClassLoader.getSystemClassLoader();
        }
        return clsLoader;
    }

    public ByteBuffer getByteCode(Class<?> cls) {
        if (cls.isPrimitive()) {
            return null;
        }
        ClassLoader clsLoader = this.getClassLoader(cls);
        InputStream inputStream = clsLoader.getResourceAsStream(cls.getName().replace(".", "/") + ".class");
        return StaticComponentContainer.Streams.toByteBuffer(Objects.requireNonNull(inputStream, "Could not acquire bytecode for class " + cls.getName()));
    }

    public <T> T newInstance(Constructor<T> ctor, Object ... params) {
        if (params == null) {
            params = new Object[]{null};
        }
        try {
            return ctor.newInstance(params);
        }
        catch (Throwable exc) {
            return (T)StaticComponentContainer.Driver.newInstance(ctor, params);
        }
    }

    @Override
    public Field[] getDeclaredFields(Class<?> cls) {
        return StaticComponentContainer.Cache.classLoaderForFields.getOrUploadIfAbsent(this.getClassLoader(cls), this.getCacheKey(cls), () -> {
            try {
                return StaticComponentContainer.Driver.getDeclaredFields(cls);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not retrieve fields of class {}. Cause: {}", cls.getName(), exc.getMessage());
                return this.emtpyFieldsArray;
            }
        });
    }

    @Override
    public <T> Constructor<T>[] getDeclaredConstructors(Class<T> cls) {
        return StaticComponentContainer.Cache.classLoaderForConstructors.getOrUploadIfAbsent(this.getClassLoader(cls), this.getCacheKey(cls), () -> {
            try {
                return StaticComponentContainer.Driver.getDeclaredConstructors(cls);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not retrieve constructors of class {}. Cause: {}", cls.getName(), exc.getMessage());
                return this.emptyConstructorsArray;
            }
        });
    }

    @Override
    public Method[] getDeclaredMethods(Class<?> cls) {
        return StaticComponentContainer.Cache.classLoaderForMethods.getOrUploadIfAbsent(this.getClassLoader(cls), this.getCacheKey(cls), () -> {
            try {
                return StaticComponentContainer.Driver.getDeclaredMethods(cls);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not retrieve methods of class {}. Cause: {}", cls.getName(), exc.getMessage());
                return this.emptyMethodsArray;
            }
        });
    }

    String getCacheKey(Class<?> cls) {
        return cls.getName().replace(".", "/");
    }

    public boolean isLoadedBy(Class<?> cls, ClassLoader classLoader) {
        ClassLoader parentClassLoader = null;
        if (cls.getClassLoader() == classLoader) {
            return true;
        }
        if (classLoader != null && (parentClassLoader = StaticComponentContainer.ClassLoaders.getParent(classLoader)) != null) {
            return this.isLoadedBy(cls, parentClassLoader);
        }
        return false;
    }

    public boolean isAssignableFrom(Class<?> cls_01, Class<?> cls_02) {
        return this.getClassOrWrapper(cls_01).isAssignableFrom(this.getClassOrWrapper(cls_02));
    }

    public Class<?> getClassOrWrapper(Class<?> cls) {
        if (cls.isPrimitive()) {
            if (cls == Integer.TYPE) {
                return Integer.class;
            }
            if (cls == Long.TYPE) {
                return Long.class;
            }
            if (cls == Float.TYPE) {
                return Float.class;
            }
            if (cls == Double.TYPE) {
                return Double.class;
            }
            if (cls == Boolean.TYPE) {
                return Boolean.class;
            }
            if (cls == Byte.TYPE) {
                return Byte.class;
            }
            if (cls == Character.TYPE) {
                return Character.class;
            }
        }
        return cls;
    }

    public static class Loaders
    implements Closeable {
        protected Map<ClassLoader, Collection<Class<?>>> classLoadersClasses = new HashMap();
        protected Map<ClassLoader, Map<String, ?>> classLoadersPackages = new HashMap();
        protected Map<String, MethodHandle> classLoadersMethods = new HashMap<String, MethodHandle>();
        protected Field builtinClassLoaderClassParentField;

        private Loaders() {
            Class builtinClassLoaderClass = StaticComponentContainer.Driver.getBuiltinClassLoaderClass();
            if (builtinClassLoaderClass != null) {
                this.builtinClassLoaderClassParentField = StaticComponentContainer.Fields.findFirstAndMakeItAccessible(builtinClassLoaderClass, "parent", builtinClassLoaderClass);
            }
        }

        public static Loaders create() {
            return new Loaders();
        }

        public Collection<ClassLoader> getAllParents(ClassLoader classLoader) {
            return this.getHierarchy(classLoader, false);
        }

        public Collection<ClassLoader> getHierarchy(ClassLoader classLoader) {
            return this.getHierarchy(classLoader, true);
        }

        private Collection<ClassLoader> getHierarchy(ClassLoader classLoader, boolean includeClassLoader) {
            LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
            if (includeClassLoader) {
                classLoaders.add(classLoader);
            }
            while ((classLoader = this.getParent(classLoader)) != null) {
                classLoaders.add(classLoader);
            }
            return classLoaders;
        }

        public Function<Boolean, ClassLoader> setAsMaster(ClassLoader classLoader, ClassLoader futureParent) {
            return this.setAsParent(this.getMaster(classLoader), futureParent);
        }

        public Function<Boolean, ClassLoader> setAsParent(ClassLoader target, ClassLoader originalFutureParent) {
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(target)) {
                return this.setAsParent((ClassLoader)StaticComponentContainer.Fields.getDirect((Object)target, "classLoader"), originalFutureParent);
            }
            ClassLoader futureParentTemp = originalFutureParent;
            if (this.isBuiltinClassLoader(target)) {
                futureParentTemp = this.checkAndConvertBuiltinClassLoader(futureParentTemp);
            }
            ClassLoader targetExParent = (ClassLoader)StaticComponentContainer.Fields.get((Object)target, "parent");
            ClassLoader futureParent = futureParentTemp;
            this.checkAndRegisterOrUnregisterMemoryClassLoaders(target, targetExParent, originalFutureParent);
            StaticComponentContainer.Fields.setDirect((Object)target, "parent", (Object)futureParent);
            return reset -> {
                if (reset.booleanValue()) {
                    this.checkAndRegisterOrUnregisterMemoryClassLoaders(target, originalFutureParent, targetExParent);
                    StaticComponentContainer.Fields.setDirect((Object)target, "parent", (Object)targetExParent);
                }
                return targetExParent;
            };
        }

        private void checkAndRegisterOrUnregisterMemoryClassLoaders(ClassLoader target, ClassLoader exParent, ClassLoader futureParent) {
            MemoryClassLoader targetMemoryClassLoader;
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(target)) {
                target = (ClassLoader)StaticComponentContainer.Fields.getDirect((Object)target, "classLoader");
            }
            if (exParent != null && StaticComponentContainer.Driver.isClassLoaderDelegate(exParent)) {
                exParent = (ClassLoader)StaticComponentContainer.Fields.getDirect((Object)exParent, "classLoader");
            }
            if (futureParent != null && StaticComponentContainer.Driver.isClassLoaderDelegate(futureParent)) {
                futureParent = (ClassLoader)StaticComponentContainer.Fields.getDirect((Object)futureParent, "classLoader");
            }
            MemoryClassLoader exParentMC = exParent instanceof MemoryClassLoader ? (MemoryClassLoader)exParent : null;
            MemoryClassLoader futureParentMC = futureParent instanceof MemoryClassLoader ? (MemoryClassLoader)futureParent : null;
            MemoryClassLoader memoryClassLoader = targetMemoryClassLoader = target instanceof MemoryClassLoader ? (MemoryClassLoader)target : null;
            if (targetMemoryClassLoader != null) {
                if (futureParentMC != null) {
                    futureParentMC.register(targetMemoryClassLoader);
                }
                if (exParentMC != null) {
                    exParentMC.unregister(targetMemoryClassLoader, false);
                }
            }
        }

        private ClassLoader checkAndConvertBuiltinClassLoader(ClassLoader classLoader) {
            if (!this.isBuiltinClassLoader(classLoader)) {
                try {
                    Collection methods = StaticComponentContainer.Members.findAll(((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(cls -> cls.getName().equals(ClassLoader.class.getName())).name("loadClass"::equals)).and()).parameterTypesAreAssignableFrom(String.class, Boolean.TYPE), classLoader.getClass());
                    classLoader = (ClassLoader)StaticComponentContainer.Constructors.newInstanceOf(StaticComponentContainer.Driver.getClassLoaderDelegateClass(), null, classLoader, StaticComponentContainer.Methods.findDirectHandle((Method)methods.stream().skip(methods.size() - 1).findFirst().get()));
                }
                catch (Throwable exc) {
                    StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
                }
            }
            return classLoader;
        }

        public ClassLoader getParent(ClassLoader classLoader) {
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(classLoader)) {
                return this.getParent((ClassLoader)StaticComponentContainer.Fields.getDirect((Object)classLoader, "classLoader"));
            }
            if (this.isBuiltinClassLoader(classLoader)) {
                return Executor.get(() -> (ClassLoader)this.builtinClassLoaderClassParentField.get(classLoader));
            }
            return classLoader.getParent();
        }

        public ClassLoader getMaster(ClassLoader classLoader) {
            ClassLoader parentClassLoader = null;
            while ((parentClassLoader = this.getParent(classLoader)) != null) {
                classLoader = parentClassLoader;
            }
            return classLoader;
        }

        public MethodHandle getDefinePackageMethod(ClassLoader classLoader) {
            return this.getMethod(classLoader.getClass().getName() + "_definePackage", () -> this.findDefinePackageMethodAndMakeItAccesible(classLoader));
        }

        private MethodHandle findDefinePackageMethodAndMakeItAccesible(ClassLoader classLoader) {
            return StaticComponentContainer.Methods.findFirstDirectHandle((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(cls -> cls.getName().equals(ClassLoader.class.getName())).name("definePackage"::equals)).and()).parameterTypesAreAssignableFrom(String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class), classLoader.getClass());
        }

        public MethodHandle getDefineClassMethod(ClassLoader classLoader) {
            return this.getMethod(StaticComponentContainer.Classes.getClassLoader(classLoader.getClass()) + "_" + classLoader + "_defineClass", () -> this.findDefineClassMethodAndMakeItAccesible(classLoader));
        }

        Object getClassLoadingLock(ClassLoader classLoader, String className) {
            try {
                return this.getGetClassLoadingLockMethod(classLoader).invoke(classLoader, className);
            }
            catch (Throwable exc) {
                return StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
            }
        }

        public MethodHandle getGetClassLoadingLockMethod(ClassLoader classLoader) {
            return this.getMethod(StaticComponentContainer.Classes.getClassLoader(classLoader.getClass()) + "_" + classLoader + "_getClassLoadingLock", () -> this.findGetClassLoadingLockMethodAndMakeItAccesible(classLoader));
        }

        private MethodHandle findDefineClassMethodAndMakeItAccesible(ClassLoader classLoader) {
            return StaticComponentContainer.Methods.findFirstDirectHandle(((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(cls -> cls.getName().equals(ClassLoader.class.getName())).name((classLoader instanceof MemoryClassLoader ? "_defineClass" : "defineClass")::equals)).and()).parameterTypes(params -> ((Class[])params).length == 3)).and()).parameterTypesAreAssignableFrom(String.class, ByteBuffer.class, ProtectionDomain.class)).and()).returnType(cls -> cls.getName().equals(Class.class.getName())), classLoader.getClass());
        }

        private MethodHandle findGetClassLoadingLockMethodAndMakeItAccesible(ClassLoader classLoader) {
            return StaticComponentContainer.Methods.findFirstDirectHandle((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(cls -> cls.getName().equals(ClassLoader.class.getName())).name("getClassLoadingLock"::equals)).and()).parameterTypes(params -> ((Class[])params).length == 1)).and()).parameterTypesAreAssignableFrom(String.class), classLoader.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MethodHandle getMethod(String key, Supplier<MethodHandle> methodSupplier) {
            MethodHandle method = this.classLoadersMethods.get(key);
            if (method == null) {
                Map<String, MethodHandle> map = this.classLoadersMethods;
                synchronized (map) {
                    method = this.classLoadersMethods.get(key);
                    if (method == null) {
                        method = methodSupplier.get();
                        this.classLoadersMethods.put(key, method);
                    }
                }
            }
            return method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Class<?>> retrieveLoadedClasses(ClassLoader classLoader) {
            Collection<Class<?>> classes = this.classLoadersClasses.get(classLoader);
            if (classes != null) {
                return classes;
            }
            classes = this.classLoadersClasses.get(classLoader);
            if (classes == null) {
                Map<ClassLoader, Collection<Class<?>>> map = this.classLoadersClasses;
                synchronized (map) {
                    classes = this.classLoadersClasses.get(classLoader);
                    if (classes == null) {
                        classes = StaticComponentContainer.Driver.retrieveLoadedClasses(classLoader);
                        this.classLoadersClasses.put(classLoader, classes);
                        return classes;
                    }
                }
            }
            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "'classes' collection has not been initialized on {}: trying recursive call", classLoader);
            return this.retrieveLoadedClasses(classLoader);
        }

        public Collection<Class<?>> retrieveAllLoadedClasses(ClassLoader classLoader) {
            LinkedHashSet allLoadedClasses = new LinkedHashSet();
            allLoadedClasses.addAll(this.retrieveLoadedClasses(classLoader));
            ClassLoader parentClassLoader = this.getParent(classLoader);
            if (parentClassLoader != null) {
                allLoadedClasses.addAll(this.retrieveAllLoadedClasses(parentClassLoader));
            }
            return allLoadedClasses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, ?> retrieveLoadedPackages(ClassLoader classLoader) {
            Map packages = this.classLoadersPackages.get(classLoader);
            if (packages == null) {
                Map<ClassLoader, Map<String, ?>> map = this.classLoadersPackages;
                synchronized (map) {
                    packages = this.classLoadersPackages.get(classLoader);
                    if (packages == null) {
                        packages = StaticComponentContainer.Driver.retrieveLoadedPackages(classLoader);
                        this.classLoadersPackages.put(classLoader, packages);
                    }
                }
            }
            if (packages == null) {
                StaticComponentContainer.Throwables.throwException("Could not find packages Map on {}", classLoader);
            }
            return packages;
        }

        public <T> Class<T> loadOrDefineByJavaClass(JavaClass javaClass, ClassLoader classLoader) throws ClassNotFoundException {
            HashMap<String, JavaClass> repository = new HashMap<String, JavaClass>();
            repository.put(javaClass.getName(), javaClass);
            return this.loadOrDefineByJavaClass(javaClass.getName(), repository, classLoader);
        }

        public <T> Class<T> loadOrDefineByJavaClass(String className, Map<String, JavaClass> byteCodes, ClassLoader classLoader) throws ClassNotFoundException {
            if (!(classLoader instanceof MemoryClassLoader)) {
                return this.loadOrDefineByByteCode(className, clsName -> ((JavaClass)byteCodes.get(clsName)).getByteCode(), classLoader, this.getDefineClassMethod(classLoader), this.getDefinePackageMethod(classLoader));
            }
            for (Map.Entry<String, JavaClass> clazz : byteCodes.entrySet()) {
                ((MemoryClassLoader)classLoader).addByteCode(clazz.getKey(), clazz.getValue().getByteCode());
            }
            return classLoader.loadClass(className);
        }

        public Class<?> loadOrDefineByByteCode(ByteBuffer byteCode, ClassLoader classLoader) throws ClassNotFoundException {
            HashMap repository = new HashMap();
            return JavaClass.extractByUsing(byteCode, javaClass -> {
                repository.put(javaClass.getName(), javaClass);
                return this.loadOrDefineByJavaClass(javaClass.getName(), repository, classLoader);
            });
        }

        public <T> Class<T> loadOrDefineByByteCode(String className, Map<String, ByteBuffer> repository, ClassLoader classLoader) throws ClassNotFoundException {
            if (!(classLoader instanceof MemoryClassLoader)) {
                return this.loadOrDefineByByteCode(className, clsName -> (ByteBuffer)repository.get(clsName), classLoader, this.getDefineClassMethod(classLoader), this.getDefinePackageMethod(classLoader));
            }
            for (Map.Entry<String, ByteBuffer> clazz : repository.entrySet()) {
                ((MemoryClassLoader)classLoader).addByteCode(clazz.getKey(), clazz.getValue());
            }
            return classLoader.loadClass(className);
        }

        private <T> Class<T> loadOrDefineByByteCode(String className, Function<String, ByteBuffer> byteCodeSupplier, ClassLoader classLoader, MethodHandle defineClassMethod, MethodHandle definePackageMethod) throws ClassNotFoundException {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError exc) {
                try {
                    Class<T> cls = this.defineOrLoad(classLoader, defineClassMethod, className, byteCodeSupplier.apply(className));
                    this.definePackageFor(cls, classLoader, definePackageMethod);
                    return cls;
                }
                catch (ClassNotFoundException | NoClassDefFoundError | InvocationTargetException exc2) {
                    if (byteCodeSupplier.apply(className) == null) {
                        throw new ClassNotFoundException(className);
                    }
                    String newNotFoundClassName = StaticComponentContainer.Classes.retrieveNames(exc2).stream().findFirst().orElseGet(() -> null);
                    this.loadOrDefineByByteCode(newNotFoundClassName, byteCodeSupplier, classLoader, defineClassMethod, definePackageMethod);
                    return this.loadOrDefineByByteCode(className, byteCodeSupplier, classLoader, defineClassMethod, definePackageMethod);
                }
            }
        }

        public <T> Class<T> loadOrDefine(Class<T> toLoad, ClassLoader classLoader) throws ClassNotFoundException {
            return this.loadOrDefine(toLoad, classLoader, this.getDefineClassMethod(classLoader), this.getDefinePackageMethod(classLoader));
        }

        private <T> Class<T> loadOrDefine(Class<T> toLoad, ClassLoader classLoader, MethodHandle defineClassMethod, MethodHandle definePackageMethod) throws ClassNotFoundException {
            String className = toLoad.getName();
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError exc) {
                try {
                    Class<T> cls = this.defineOrLoad(classLoader, defineClassMethod, className, StaticComponentContainer.BufferHandler.shareContent(StaticComponentContainer.Classes.getByteCode(toLoad)));
                    this.definePackageFor(cls, classLoader, definePackageMethod);
                    return cls;
                }
                catch (ClassNotFoundException | NoClassDefFoundError | InvocationTargetException exc2) {
                    String newNotFoundClassName = StaticComponentContainer.Classes.retrieveNames(exc2).stream().findFirst().orElseGet(() -> null);
                    this.loadOrDefine(Class.forName(newNotFoundClassName, false, toLoad.getClassLoader()), classLoader, defineClassMethod, definePackageMethod);
                    return this.loadOrDefine(Class.forName(className, false, toLoad.getClassLoader()), classLoader, defineClassMethod, definePackageMethod);
                }
            }
        }

        public <T> Class<T> defineOrLoad(ClassLoader classLoader, JavaClass javaClass) throws ReflectiveOperationException {
            String className = javaClass.getName();
            Class<T> definedClass = this.defineOrLoad(classLoader, this.getDefineClassMethod(classLoader), className, javaClass.getByteCode());
            this.definePackageFor(definedClass, classLoader, this.getDefinePackageMethod(classLoader));
            return definedClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> Class<T> defineOrLoad(ClassLoader classLoader, MethodHandle method, String className, ByteBuffer byteCode) throws ClassNotFoundException, InvocationTargetException, NoClassDefFoundError {
            try {
                Object object = this.getClassLoadingLock(classLoader, className);
                synchronized (object) {
                    return method.invoke(classLoader, className, byteCode, null);
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError | InvocationTargetException exc) {
                throw exc;
            }
            catch (LinkageError exc) {
                StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Class {} is already defined", className);
                return classLoader.loadClass(className);
            }
            catch (Throwable exc) {
                if (byteCode == null) {
                    throw new ClassNotFoundException(className);
                }
                return (Class)StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
            }
        }

        private Package definePackage(ClassLoader classLoader, MethodHandle definePackageMethod, String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
            return Executor.get(() -> {
                try {
                    return definePackageMethod.invoke(classLoader, name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
                }
                catch (IllegalArgumentException exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Package " + name + " already defined");
                    return this.retrieveLoadedPackage(classLoader, name);
                }
            });
        }

        private void definePackageFor(Class<?> cls, ClassLoader classLoader, MethodHandle definePackageMethod) {
            String pckgName;
            if (cls.getName().contains(".") && this.retrieveLoadedPackage(classLoader, pckgName = cls.getName().substring(0, cls.getName().lastIndexOf("."))) == null) {
                StaticComponentContainer.Synchronizer.execute(classLoader + "_" + pckgName, () -> {
                    if (this.retrieveLoadedPackage(classLoader, pckgName) == null) {
                        this.definePackage(classLoader, definePackageMethod, pckgName, null, null, null, null, null, null, null);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> Class<T> retrieveLoadedClass(ClassLoader classLoader, String className) {
            Collection<Class<?>> definedClasses;
            Collection<Class<?>> collection = definedClasses = this.retrieveLoadedClasses(classLoader);
            synchronized (collection) {
                for (Class<?> cls : definedClasses) {
                    if (!cls.getName().equals(className)) continue;
                    return cls;
                }
            }
            ClassLoader parentClassLoader = this.getParent(classLoader);
            if (parentClassLoader != null) {
                return this.retrieveLoadedClass(parentClassLoader, className);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Class<?>> retrieveLoadedClassesForPackage(ClassLoader classLoader, Predicate<Package> packagePredicate) {
            Collection<Class<?>> definedClasses;
            HashSet classesFound = new HashSet();
            Collection<Class<?>> collection = definedClasses = this.retrieveLoadedClasses(classLoader);
            synchronized (collection) {
                for (Class<?> cls : definedClasses) {
                    Package classPackage = cls.getPackage();
                    if (!packagePredicate.test(classPackage)) continue;
                    classesFound.add(cls);
                }
            }
            ClassLoader parentClassLoader = this.getParent(classLoader);
            if (parentClassLoader != null) {
                classesFound.addAll(this.retrieveLoadedClassesForPackage(parentClassLoader, packagePredicate));
            }
            return classesFound;
        }

        public Package retrieveLoadedPackage(ClassLoader classLoader, String packageName) {
            Map<String, ?> packages = this.retrieveLoadedPackages(classLoader);
            Object packageToFind = packages.get(packageName);
            ClassLoader parentClassLoader = null;
            if (packageToFind != null) {
                if (packageToFind instanceof Package) {
                    return (Package)packageToFind;
                }
                return StaticComponentContainer.Driver.getPackage(classLoader, packageName);
            }
            parentClassLoader = this.getParent(classLoader);
            if (parentClassLoader != null) {
                return this.retrieveLoadedPackage(parentClassLoader, packageName);
            }
            return null;
        }

        public ClassLoader getClassLoaderOfPath(ClassLoader classLoader, String path) {
            FileSystemItem fIS = FileSystemItem.ofPath(path);
            ClassLoader pathLoader = null;
            for (ClassLoader cl : this.getHierarchy(classLoader)) {
                URL[] urls = this.getURLs(cl);
                if (urls == null) continue;
                for (URL url : urls) {
                    FileSystemItem loadedPathFIS = FileSystemItem.of(url);
                    if (!loadedPathFIS.equals(fIS) && !loadedPathFIS.isParentOf(fIS)) continue;
                    pathLoader = cl;
                }
            }
            return pathLoader;
        }

        public boolean isItPossibleToAddClassPaths(ClassLoader classLoader) {
            if (classLoader != null) {
                if (classLoader instanceof URLClassLoader || this.isBuiltinClassLoader(classLoader) || classLoader instanceof PathScannerClassLoader) {
                    return true;
                }
                return this.isItPossibleToAddClassPaths(this.getParent(classLoader));
            }
            return false;
        }

        public Collection<String> addClassPath(ClassLoader classLoader, String ... classPaths) {
            return this.addClassPaths(classLoader, Arrays.asList(classPaths));
        }

        public Collection<String> addClassPath(ClassLoader classLoader, Predicate<String> checkForAddedClasses, String ... classPaths) {
            return this.addClassPaths(classLoader, checkForAddedClasses, Arrays.asList(classPaths));
        }

        public Collection<String> addClassPaths(ClassLoader classLoader, Predicate<String> checkForAddedClasses, Collection<String> ... classPathCollections) {
            if (!(classLoader instanceof URLClassLoader || this.isBuiltinClassLoader(classLoader) || classLoader instanceof PathScannerClassLoader)) {
                if (!this.isItPossibleToAddClassPaths(classLoader)) {
                    throw new UnsupportedException(StaticComponentContainer.Strings.compile("Could not add class paths to {} because the type {} is not supported", StaticComponentContainer.Objects.getId(classLoader), classLoader.getClass()));
                }
                return this.addClassPaths(this.getParent(classLoader), checkForAddedClasses, classPathCollections);
            }
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(classLoader)) {
                return this.addClassPaths((ClassLoader)StaticComponentContainer.Fields.getDirect((Object)classLoader, "classLoader"), checkForAddedClasses, classPathCollections);
            }
            HashSet<String> paths = new HashSet<String>();
            for (Collection<String> classPaths : classPathCollections) {
                paths.addAll(classPaths);
            }
            if (classLoader instanceof URLClassLoader || StaticComponentContainer.Driver.isBuiltinClassLoader(classLoader)) {
                paths.removeAll(this.getAllLoadedPaths(classLoader));
                if (!paths.isEmpty()) {
                    ClassLoader target;
                    ClassLoader classLoader2 = target = classLoader instanceof URLClassLoader ? classLoader : StaticComponentContainer.Fields.getDirect((Object)classLoader, "ucp");
                    if (target != null) {
                        Consumer<URL> classPathAdder = urls -> StaticComponentContainer.Methods.invokeDirect(target, "addURL", urls);
                        paths.stream().map(classPath -> FileSystemItem.ofPath(classPath).getURL()).forEach(url -> classPathAdder.accept((URL)url));
                        return paths;
                    }
                }
            } else if (classLoader instanceof PathScannerClassLoader) {
                return ((PathScannerClassLoader)classLoader).scanPathsAndAddAllByteCodesFound(paths, checkForAddedClasses);
            }
            return new HashSet<String>();
        }

        public Collection<String> addClassPaths(ClassLoader classLoader, Collection<String> ... classPathCollections) {
            return this.addClassPaths(classLoader, (String path) -> true, classPathCollections);
        }

        public Collection<String> getLoadedPaths(ClassLoader classLoader) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            if (classLoader instanceof PathScannerClassLoader) {
                paths.addAll(((PathScannerClassLoader)classLoader).loadedPaths);
            } else {
                URL[] resUrl = this.getURLs(classLoader);
                if (resUrl != null) {
                    for (int i = 0; i < resUrl.length; ++i) {
                        paths.add(StaticComponentContainer.Paths.convertURLPathToAbsolutePath(resUrl[i].getPath()));
                    }
                }
            }
            return paths;
        }

        public Collection<String> getAllLoadedPaths(ClassLoader classLoader) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            while (classLoader != null) {
                paths.addAll(this.getLoadedPaths(classLoader));
                classLoader = this.getParent(classLoader);
            }
            return paths;
        }

        public boolean isBuiltinClassLoader(ClassLoader classLoader) {
            return StaticComponentContainer.Driver.isBuiltinClassLoader(classLoader);
        }

        public URL[] getURLs(ClassLoader classLoader) {
            if (classLoader instanceof URLClassLoader) {
                return ((URLClassLoader)classLoader).getURLs();
            }
            if (StaticComponentContainer.Driver.isClassLoaderDelegate(classLoader)) {
                return this.getURLs((ClassLoader)StaticComponentContainer.Fields.getDirect((Object)classLoader, "classLoader"));
            }
            if (StaticComponentContainer.Driver.isBuiltinClassLoader(classLoader)) {
                Object urlClassPath = StaticComponentContainer.Fields.getDirect((Object)classLoader, "ucp");
                if (urlClassPath != null) {
                    return (URL[])StaticComponentContainer.Methods.invoke(urlClassPath, "getURLs", new Object[0]);
                }
            } else if (classLoader instanceof PathScannerClassLoader) {
                return ((PathScannerClassLoader)classLoader).getURLs();
            }
            return null;
        }

        @SafeVarargs
        public final Collection<FileSystemItem> getResources(ClassLoader classLoader, String ... paths) {
            return this.getResources(classLoader, Arrays.asList(paths));
        }

        @SafeVarargs
        public final Collection<FileSystemItem> getResources(ClassLoader classLoader, Collection<String> ... pathCollections) {
            HashSet<FileSystemItem> paths = new HashSet<FileSystemItem>();
            for (Collection<String> pathCollection : pathCollections) {
                for (String path : pathCollection) {
                    try {
                        paths.addAll(Collections.list(classLoader.getResources(path)).stream().map(url -> FileSystemItem.of(url)).collect(Collectors.toSet()));
                    }
                    catch (IOException exc) {
                        StaticComponentContainer.Throwables.throwException(exc, new Object[0]);
                    }
                }
            }
            return paths;
        }

        public void unregister(ClassLoader classLoader) {
            this.classLoadersClasses.remove(classLoader);
            this.classLoadersPackages.remove(classLoader);
        }

        @Override
        public void close() {
            if (this != StaticComponentContainer.ClassLoaders) {
                this.classLoadersClasses.clear();
                this.classLoadersClasses = null;
                this.classLoadersMethods.clear();
                this.classLoadersMethods = null;
                this.classLoadersPackages.clear();
                this.classLoadersPackages = null;
                this.builtinClassLoaderClassParentField = null;
            } else {
                StaticComponentContainer.Throwables.throwException("Could not close singleton instance {}", this);
            }
        }

        public static class UnsupportedException
        extends RuntimeException {
            private static final long serialVersionUID = 8964839983768809586L;

            public UnsupportedException(String s) {
                super(s);
            }

            public UnsupportedException(String s, Throwable cause) {
                super(s, cause);
            }
        }
    }

    public static class Symbol {

        public static class Tag {
            static final byte UTF8 = 1;
            static final byte INTEGER = 3;
            static final byte FLOAT = 4;
            static final byte LONG = 5;
            static final byte DOUBLE = 6;
            static final byte CLASS = 7;
            static final byte STRING = 8;
            static final byte FIELD_REF = 9;
            static final byte METHOD_REF = 10;
            static final byte INTERFACE_METHOD_REF = 11;
            static final byte NAME_AND_TYPE = 12;
            static final byte METHOD_HANDLE = 15;
            static final byte METHOD_TYPE = 16;
            static final byte DYNAMIC = 17;
            static final byte INVOKE_DYNAMIC = 18;
            static final byte MODULE = 19;
            static final byte PACKAGE = 20;
        }
    }
}

