/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassFactory;
import org.burningwave.core.classes.FunctionalInterfaceFactory;
import org.burningwave.core.classes.FunctionalInterfaceSourceGenerator;
import org.burningwave.core.classes.LoadOrBuildAndDefineConfig;
import org.burningwave.core.classes.Members;
import org.burningwave.core.classes.UnitSourceGenerator;
import org.burningwave.core.function.Executor;
import org.burningwave.core.function.MultiParamsFunction;
import org.burningwave.core.function.ThrowingSupplier;

class FunctionalInterfaceFactoryImpl
implements FunctionalInterfaceFactory,
Component {
    private ClassFactory classFactory;
    private FunctionalInterfaceSourceGenerator sourceCodeGenerator;

    FunctionalInterfaceFactoryImpl(ClassFactory classFactory) {
        this.classFactory = classFactory;
        this.sourceCodeGenerator = FunctionalInterfaceSourceGenerator.create();
    }

    @Override
    public <T> T getOrCreate(Class<?> targetClass, Class<?> ... argumentTypes) {
        Constructor<?> ctor = StaticComponentContainer.Constructors.findFirstAndMakeItAccessible(targetClass, argumentTypes);
        if (ctor == null) {
            StaticComponentContainer.Throwables.throwException("Constructor with argument types {} not found in {} class", String.join((CharSequence)", ", Arrays.asList(argumentTypes).stream().map(cls -> cls.getName()).collect(Collectors.toList())), targetClass.getName());
        }
        return (T)this.getOrCreate(ctor);
    }

    @Override
    public <T> T getOrCreateFunction(Class<?> targetClass, String methodName, Class<?> ... argumentTypes) {
        return (T)this.getOrCreateBindedFunction(this.retrieveMethod(targetClass, methodName, argumentTypes));
    }

    @Override
    public <T> T getOrCreateSupplier(Class<?> targetClass, String methodName) {
        return (T)this.getOrCreateBindedSupplier(this.retrieveMethod(targetClass, methodName, new Class[0]));
    }

    @Override
    public <T> T getOrCreatePredicate(Class<?> targetClass, String methodName, Class<?> ... argumentTypes) {
        return (T)this.getOrCreateBindedPredicate(this.retrieveMethod(targetClass, methodName, argumentTypes));
    }

    @Override
    public <T> T getOrCreateConsumer(Class<?> targetClass, String methodName, Class<?> ... argumentTypes) {
        return (T)this.getOrCreateBindedConsumer(this.retrieveMethod(targetClass, methodName, argumentTypes));
    }

    @Override
    public <T> T getOrCreate(Class<?> targetClass, String methodName, Class<?> ... argumentTypes) {
        return (T)this.getOrCreate(this.retrieveMethod(targetClass, methodName, argumentTypes));
    }

    private Method retrieveMethod(Class<?> targetClass, String methodName, Class<?> ... argumentTypes) {
        Method method = StaticComponentContainer.Methods.findFirstAndMakeItAccessible(targetClass, methodName, argumentTypes);
        if (method == null) {
            StaticComponentContainer.Throwables.throwException("Method named {} with argument types {} not found in {} hierarchy", methodName, String.join((CharSequence)", ", Arrays.asList(argumentTypes).stream().map(cls -> cls.getName()).collect(Collectors.toList())), targetClass.getName());
        }
        return method;
    }

    @Override
    public <F> F getOrCreate(Executable executable) {
        if (executable instanceof Method) {
            Method targetMethod = (Method)executable;
            if (targetMethod.getParameterTypes().length == 0 && targetMethod.getReturnType() == Void.TYPE) {
                return this.getOrCreateBindedRunnable(targetMethod);
            }
            if (!(targetMethod.getReturnType() != Boolean.TYPE && targetMethod.getReturnType() != Boolean.class || targetMethod.getParameterTypes().length <= 0 && (targetMethod.getParameterTypes().length != 0 || Modifier.isStatic(targetMethod.getModifiers())))) {
                return this.getOrCreateBindedPredicate(targetMethod);
            }
            if (targetMethod.getParameterTypes().length == 0 && targetMethod.getReturnType() != Void.TYPE) {
                return this.getOrCreateBindedSupplier(targetMethod);
            }
            if (targetMethod.getParameterTypes().length > 0 && targetMethod.getReturnType() == Void.TYPE) {
                return this.getOrCreateBindedConsumer(targetMethod);
            }
            if (targetMethod.getParameterTypes().length > 0 && targetMethod.getReturnType() != Void.TYPE) {
                return this.getOrCreateBindedFunction(targetMethod);
            }
        } else if (executable instanceof Constructor) {
            Constructor targetConstructor = (Constructor)executable;
            if (targetConstructor.getParameterTypes().length == 0) {
                return this.getOrCreateBindedSupplier(targetConstructor);
            }
            return this.getOrCreateBindedFunction(targetConstructor);
        }
        return null;
    }

    <F> F getOrCreateBindedRunnable(Executable executable) {
        return (F)StaticComponentContainer.Cache.bindedFunctionalInterfaces.getOrUploadIfAbsent(StaticComponentContainer.Classes.getClassLoader(executable.getDeclaringClass()), this.getCacheKey(executable), () -> Executor.get(() -> {
            Supplier<Members.Handler.OfExecutable.Box<? extends Executable>> methodHandleBoxSupplier = executable instanceof Constructor ? () -> StaticComponentContainer.Constructors.findDirectHandleBox((Constructor)executable) : () -> StaticComponentContainer.Methods.findDirectHandleBox((Method)executable);
            return this.bindTo(methodHandleBoxSupplier, () -> Modifier.isStatic(executable.getModifiers()) || executable instanceof Constructor ? new AbstractMap.SimpleEntry<Class<Runnable>, String>(Runnable.class, "run") : new AbstractMap.SimpleEntry<Class<Consumer>, String>(Consumer.class, "accept"), methodHandle -> methodHandle.type().generic().changeReturnType(Void.TYPE));
        }));
    }

    <F> F getOrCreateBindedSupplier(Executable executable) {
        return (F)StaticComponentContainer.Cache.bindedFunctionalInterfaces.getOrUploadIfAbsent(StaticComponentContainer.Classes.getClassLoader(executable.getDeclaringClass()), this.getCacheKey(executable), () -> Executor.get(() -> {
            Supplier<Members.Handler.OfExecutable.Box<? extends Executable>> methodHandleBoxSupplier = executable instanceof Constructor ? () -> StaticComponentContainer.Constructors.findDirectHandleBox((Constructor)executable) : () -> StaticComponentContainer.Methods.findDirectHandleBox((Method)executable);
            return this.bindTo(methodHandleBoxSupplier, () -> Modifier.isStatic(executable.getModifiers()) || executable instanceof Constructor ? new AbstractMap.SimpleEntry<Class<Supplier>, String>(Supplier.class, "get") : new AbstractMap.SimpleEntry<Class<Function>, String>(Function.class, "apply"), methodHandle -> methodHandle.type().generic());
        }));
    }

    <F> F getOrCreateBindedFunction(Executable executable) {
        return (F)StaticComponentContainer.Cache.bindedFunctionalInterfaces.getOrUploadIfAbsent(StaticComponentContainer.Classes.getClassLoader(executable.getDeclaringClass()), this.getCacheKey(executable), () -> Executor.get(() -> {
            Supplier<Members.Handler.OfExecutable.Box<? extends Executable>> methodHandleBoxSupplier = executable instanceof Constructor ? () -> StaticComponentContainer.Constructors.findDirectHandleBox((Constructor)executable) : () -> StaticComponentContainer.Methods.findDirectHandleBox((Method)executable);
            return this.bindTo(methodHandleBoxSupplier, () -> new AbstractMap.SimpleEntry(this.retrieveClass(Function.class, parameterCount -> this.loadOrBuildAndDefineFunctionSubType(executable.getDeclaringClass().getClassLoader(), (int)parameterCount), Modifier.isStatic(executable.getModifiers()) || executable instanceof Constructor ? executable.getParameterCount() : executable.getParameterCount() + 1), "apply"), methodHandle -> methodHandle.type().generic());
        }));
    }

    <F> F getOrCreateBindedConsumer(Method targetMethod) {
        return (F)StaticComponentContainer.Cache.bindedFunctionalInterfaces.getOrUploadIfAbsent(StaticComponentContainer.Classes.getClassLoader(targetMethod.getDeclaringClass()), this.getCacheKey(targetMethod), () -> Executor.get(() -> this.bindTo(() -> StaticComponentContainer.Methods.findDirectHandleBox(targetMethod), () -> new AbstractMap.SimpleEntry(this.retrieveClass(Consumer.class, parameterCount -> this.loadOrBuildAndDefineConsumerSubType(targetMethod.getDeclaringClass().getClassLoader(), (int)parameterCount), Modifier.isStatic(targetMethod.getModifiers()) ? targetMethod.getParameterCount() : targetMethod.getParameterCount() + 1), "accept"), methodHandle -> methodHandle.type().generic().changeReturnType(Void.TYPE))));
    }

    <F> F getOrCreateBindedPredicate(Method targetMethod) {
        return (F)StaticComponentContainer.Cache.bindedFunctionalInterfaces.getOrUploadIfAbsent(StaticComponentContainer.Classes.getClassLoader(targetMethod.getDeclaringClass()), this.getCacheKey(targetMethod), () -> Executor.get(() -> this.bindTo(() -> StaticComponentContainer.Methods.findDirectHandleBox(targetMethod), () -> new AbstractMap.SimpleEntry(this.retrieveClass(Predicate.class, parameterCount -> this.loadOrBuildAndDefinePredicateSubType(targetMethod.getDeclaringClass().getClassLoader(), (int)parameterCount), Modifier.isStatic(targetMethod.getModifiers()) ? targetMethod.getParameterCount() : targetMethod.getParameterCount() + 1), "test"), methodHandle -> methodHandle.type().generic().changeReturnType(Boolean.TYPE))));
    }

    @Override
    public <T> Class<T> loadOrBuildAndDefineFunctionSubType(int parametersCount) {
        return this.loadOrBuildAndDefineFunctionSubType(null, parametersCount);
    }

    @Override
    public <T> Class<T> loadOrBuildAndDefineFunctionSubType(ClassLoader classLoader, int parametersLength) {
        return this.loadOrBuildAndDefineFunctionInterfaceSubType(classLoader, "FunctionFor", "Parameters", parametersLength, (className, paramsL) -> UnitSourceGenerator.create(StaticComponentContainer.Classes.retrievePackageName((String)className)).addClass(this.sourceCodeGenerator.generateFunction((String)className, (int)paramsL)));
    }

    @Override
    public <T> Class<T> loadOrBuildAndDefineConsumerSubType(int parametersCount) {
        return this.loadOrBuildAndDefineConsumerSubType(null, parametersCount);
    }

    @Override
    public <T> Class<T> loadOrBuildAndDefineConsumerSubType(ClassLoader classLoader, int parametersLength) {
        return this.loadOrBuildAndDefineFunctionInterfaceSubType(classLoader, "ConsumerFor", "Parameters", parametersLength, (className, paramsL) -> UnitSourceGenerator.create(StaticComponentContainer.Classes.retrievePackageName((String)className)).addClass(this.sourceCodeGenerator.generateConsumer((String)className, (int)paramsL)));
    }

    @Override
    public <T> Class<T> loadOrBuildAndDefinePredicateSubType(int parametersLength) {
        return this.loadOrBuildAndDefinePredicateSubType(null, parametersLength);
    }

    @Override
    public <T> Class<T> loadOrBuildAndDefinePredicateSubType(ClassLoader classLoader, int parametersLength) {
        return this.loadOrBuildAndDefineFunctionInterfaceSubType(classLoader, "PredicateFor", "Parameters", parametersLength, (className, paramsL) -> UnitSourceGenerator.create(StaticComponentContainer.Classes.retrievePackageName((String)className)).addClass(this.sourceCodeGenerator.generatePredicate((String)className, (int)paramsL)));
    }

    private <T> Class<T> loadOrBuildAndDefineFunctionInterfaceSubType(ClassLoader classLoader, String classNamePrefix, String classNameSuffix, int parametersLength, BiFunction<String, Integer, UnitSourceGenerator> unitSourceGeneratorSupplier) {
        String functionalInterfaceName = classNamePrefix + parametersLength + classNameSuffix;
        String packageName = MultiParamsFunction.class.getPackage().getName();
        String className = packageName + "." + functionalInterfaceName;
        try (ClassFactory.ClassRetriever classRetriever = this.classFactory.loadOrBuildAndDefine((LoadOrBuildAndDefineConfig)LoadOrBuildAndDefineConfig.forUnitSourceGenerator(unitSourceGeneratorSupplier.apply(className, parametersLength)).useClassLoader(classLoader));){
            Class<?> clazz = classRetriever.get(className);
            return clazz;
        }
    }

    private <F> F bindTo(Supplier<Members.Handler.OfExecutable.Box<? extends Executable>> methodHandleBoxSupplier, ThrowingSupplier<Map.Entry<Class<?>, String>, Throwable> functionalInterfaceBagSupplier, Function<MethodHandle, MethodType> functionalInterfaceSignatureSupplier) throws Throwable {
        Members.Handler.OfExecutable.Box<? extends Executable> methodHandleBox = methodHandleBoxSupplier.get();
        MethodHandle methodHandle = methodHandleBox.getHandler();
        Map.Entry<Class<?>, String> functionalInterfaceBag = functionalInterfaceBagSupplier.get();
        return (F)LambdaMetafactory.metafactory(methodHandleBox.getConsulter(), functionalInterfaceBag.getValue(), MethodType.methodType(functionalInterfaceBag.getKey()), functionalInterfaceSignatureSupplier.apply(methodHandle), methodHandle, methodHandle.type()).getTarget().invoke();
    }

    Class<?> retrieveClass(Class<?> cls, Function<Integer, Class<?>> classRetriever, int parametersCount) throws ClassNotFoundException {
        if (parametersCount < 3) {
            String className = parametersCount == 2 ? Optional.ofNullable(cls.getPackage()).map(pkg -> pkg.getName() + ".").orElse("") + "Bi" + cls.getSimpleName() : cls.getName();
            return Class.forName(className, true, StaticComponentContainer.Classes.getClassLoader(cls));
        }
        return classRetriever.apply(parametersCount);
    }

    String getCacheKey(Executable executable) {
        Class<?> targetMethodDeclaringClass = executable.getDeclaringClass();
        Parameter[] parameters = executable.getParameters();
        String argumentsKey = "";
        if (parameters != null && parameters.length > 0) {
            StringBuffer argumentsKeyStringBuffer = new StringBuffer();
            Stream.of(parameters).forEach(parameter -> argumentsKeyStringBuffer.append("/" + parameter.getType().getName()));
            argumentsKey = argumentsKeyStringBuffer.toString();
        }
        String cacheKey = "/" + targetMethodDeclaringClass.getName() + "@" + targetMethodDeclaringClass.hashCode() + "/" + executable.getName() + argumentsKey;
        return cacheKey;
    }
}

