/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Consumer;
import org.burningwave.core.Closeable;
import org.burningwave.core.Criteria;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.ThrowingFunction;
import org.burningwave.core.io.FileSystemItem;

public class JavaClass
implements Closeable {
    private ByteBuffer byteCode;
    private String classNameSlashed;
    private String className;

    private JavaClass(String className, ByteBuffer byteCode) {
        this.classNameSlashed = className;
        this.byteCode = byteCode;
    }

    JavaClass(Class<?> cls) {
        this(cls.getName(), StaticComponentContainer.Classes.getByteCode(cls));
    }

    JavaClass(ByteBuffer byteCode) {
        this(StaticComponentContainer.Classes.retrieveName(byteCode), StaticComponentContainer.BufferHandler.shareContent(byteCode));
    }

    public static JavaClass create(Class<?> cls) {
        return new JavaClass(cls);
    }

    public static JavaClass create(ByteBuffer byteCode) {
        return new JavaClass(byteCode);
    }

    public static void use(ByteBuffer byteCode, Consumer<JavaClass> javaClassConsumer) {
        try (JavaClass javaClass = JavaClass.create(byteCode);){
            javaClassConsumer.accept(javaClass);
        }
    }

    public static <T, E extends Throwable> T extractByUsing(ByteBuffer byteCode, ThrowingFunction<JavaClass, T, E> javaClassConsumer) throws E {
        try (JavaClass javaClass = JavaClass.create(byteCode);){
            T t = javaClassConsumer.apply(javaClass);
            return t;
        }
    }

    private String _getPackageName() {
        return this.classNameSlashed.contains("/") ? this.classNameSlashed.substring(0, this.classNameSlashed.lastIndexOf("/")) : null;
    }

    private String _getSimpleName() {
        return this.classNameSlashed.contains("/") ? this.classNameSlashed.substring(this.classNameSlashed.lastIndexOf("/") + 1) : this.classNameSlashed;
    }

    public String getPackageName() {
        return Optional.ofNullable(this._getPackageName()).map(value -> value.replace("/", ".")).orElse(null);
    }

    public String getSimpleName() {
        return Optional.ofNullable(this._getSimpleName()).orElse(null);
    }

    public String getPackagePath() {
        String packageName = this.getPackageName();
        return packageName != null ? packageName.replace(".", "/") + "/" : null;
    }

    public String getClassFileName() {
        String classFileName = this.getSimpleName();
        return classFileName != null ? classFileName.replace(".", "$") + ".class" : null;
    }

    public String getPath() {
        String packagePath = this.getPackagePath();
        String classFileName = this.getClassFileName();
        String path = null;
        if (packagePath != null) {
            path = packagePath;
        }
        if (classFileName != null) {
            if (path == null) {
                path = "";
            }
            path = path + classFileName;
        }
        return path;
    }

    public String getName() {
        if (this.className == null) {
            String packageName = this.getPackageName();
            String classSimpleName = this.getSimpleName();
            String name = null;
            if (packageName != null) {
                name = packageName;
            }
            if (classSimpleName != null) {
                name = packageName == null ? "" : name + ".";
                name = name + classSimpleName;
            }
            this.className = name;
        }
        return this.className;
    }

    public ByteBuffer getByteCode() {
        return StaticComponentContainer.BufferHandler.duplicate(this.byteCode);
    }

    public byte[] toByteArray() {
        return StaticComponentContainer.BufferHandler.toByteArray(this.getByteCode());
    }

    public FileSystemItem storeToClassPath(String classPathFolder) {
        return StaticComponentContainer.Streams.store(classPathFolder + "/" + this.getPath(), this.getByteCode());
    }

    public JavaClass duplicate() {
        return new JavaClass(this.classNameSlashed, this.byteCode);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void close() {
        this.classNameSlashed = null;
        this.byteCode = null;
    }

    protected static class Criteria
    extends org.burningwave.core.Criteria<JavaClass, Criteria, Criteria.TestContext<JavaClass, Criteria>> {
        protected Criteria() {
        }

        public static Criteria create() {
            return new Criteria();
        }
    }
}

