/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.burningwave.core.Closeable;
import org.burningwave.core.classes.ClassPathHelper;
import org.burningwave.core.classes.JavaMemoryCompilerImpl;
import org.burningwave.core.classes.UnitSourceGenerator;
import org.burningwave.core.concurrent.QueuedTasksExecutor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

public interface JavaMemoryCompiler {
    public static JavaMemoryCompiler create(PathHelper pathHelper, ClassPathHelper classPathHelper, Properties config) {
        return new JavaMemoryCompilerImpl(pathHelper, classPathHelper, config);
    }

    public QueuedTasksExecutor.ProducerTask<Compilation.Result> compile(Compilation.Config var1);

    public static class Compilation {

        public static class Exception
        extends RuntimeException {
            private static final long serialVersionUID = 4515340268068466479L;

            public Exception(String s) {
                super(s);
            }

            public Exception(String s, Throwable cause) {
                super(s, cause);
            }
        }

        public static class Result
        implements Closeable {
            private FileSystemItem classPath;
            private Map<String, ByteBuffer> compiledFiles;
            private Collection<String> dependencies;

            Result(FileSystemItem classPath, Map<String, ByteBuffer> compiledFiles, Collection<String> classPaths) {
                this.classPath = classPath;
                this.compiledFiles = compiledFiles;
                this.dependencies = classPaths;
            }

            public FileSystemItem getClassPath() {
                return this.classPath;
            }

            public Map<String, ByteBuffer> getCompiledFiles() {
                return this.compiledFiles;
            }

            public Collection<String> getDependencies() {
                return this.dependencies;
            }

            @Override
            public void close() {
                this.compiledFiles.clear();
                this.dependencies.clear();
                this.classPath = null;
            }
        }

        public static class Config {
            private Collection<String> sources = new HashSet<String>();
            private Collection<String> classPaths;
            private Collection<String> additionalClassPaths;
            private Collection<String> blackListedClassPaths;
            private Collection<String> additionalBlackListedClassPaths;
            private Collection<String> classRepositories;
            private Collection<String> additionalClassRepositories;
            private String compiledClassesStorage;
            private boolean useTemporaryFolderForStoring;
            Map<String, String> extraParameters;

            private Config() {
                this.storeCompiledClassesToTemporaryFolder("common");
            }

            @SafeVarargs
            public static final Config withSources(Collection<String> ... sourceCollections) {
                Config compileConfig = new Config();
                for (Collection<String> sourceCollection : sourceCollections) {
                    compileConfig.sources.addAll(sourceCollection);
                }
                return compileConfig;
            }

            @SafeVarargs
            public static final Config withSource(String ... sources) {
                return Config.withSources(Arrays.asList(sources));
            }

            @SafeVarargs
            public static final Config forUnitSourceGenerator(UnitSourceGenerator ... sources) {
                return Config.forUnitSourceGenerators(Arrays.asList(sources));
            }

            @SafeVarargs
            public static final Config forUnitSourceGenerators(Collection<UnitSourceGenerator> ... sourceCollections) {
                Config compileConfig = new Config();
                for (Collection<UnitSourceGenerator> sourceCollection : sourceCollections) {
                    compileConfig.sources.addAll(sourceCollection.stream().map(source -> source.make()).collect(Collectors.toList()));
                }
                return compileConfig;
            }

            public Config storeCompiledClasses(boolean flag) {
                if (flag) {
                    if (this.compiledClassesStorage == null) {
                        this.storeCompiledClassesToTemporaryFolder("common");
                    }
                } else {
                    this.compiledClassesStorage = null;
                }
                return this;
            }

            public Config storeCompiledClassesToTemporaryFolder(String folderName) {
                this.compiledClassesStorage = folderName;
                this.useTemporaryFolderForStoring = true;
                return this;
            }

            public Config storeCompiledClassesTo(String folderName) {
                this.compiledClassesStorage = folderName;
                this.useTemporaryFolderForStoring = false;
                return this;
            }

            public Config storeCompiledClassesToNewTemporaryFolder() {
                return this.storeCompiledClassesToTemporaryFolder(UUID.randomUUID().toString());
            }

            public Config setVersion(String version) {
                return this.putExtraParameter("--release", version);
            }

            public Config putExtraParameter(String parameterName, String parameterValue) {
                if (this.extraParameters == null) {
                    this.extraParameters = new LinkedHashMap<String, String>();
                }
                this.extraParameters.put(parameterName, parameterValue);
                return this;
            }

            @SafeVarargs
            public final Config setClassPaths(Collection<String> ... classPathCollections) {
                if (this.classPaths == null) {
                    this.classPaths = new HashSet<String>();
                }
                for (Collection<String> classPathCollection : classPathCollections) {
                    this.classPaths.addAll(classPathCollection);
                }
                return this;
            }

            @SafeVarargs
            public final Config setClassPaths(String ... classPaths) {
                return this.setClassPaths(Arrays.asList(classPaths));
            }

            @SafeVarargs
            public final Config addClassPaths(Collection<String> ... classPathCollections) {
                if (this.additionalClassPaths == null) {
                    this.additionalClassPaths = new HashSet<String>();
                }
                for (Collection<String> classPathCollection : classPathCollections) {
                    this.additionalClassPaths.addAll(classPathCollection);
                }
                return this;
            }

            @SafeVarargs
            public final Config addClassPaths(String ... classPaths) {
                return this.addClassPaths(Arrays.asList(classPaths));
            }

            @SafeVarargs
            public final Config setClassRepositories(Collection<String> ... classPathCollections) {
                if (this.classRepositories == null) {
                    this.classRepositories = new HashSet<String>();
                }
                for (Collection<String> classPathCollection : classPathCollections) {
                    this.classRepositories.addAll(classPathCollection);
                }
                return this;
            }

            @SafeVarargs
            public final Config setClassRepository(String ... classPaths) {
                return this.setClassRepositories(Arrays.asList(classPaths));
            }

            @SafeVarargs
            public final Config addClassRepositories(Collection<String> ... classPathCollections) {
                if (this.additionalClassRepositories == null) {
                    this.additionalClassRepositories = new HashSet<String>();
                }
                for (Collection<String> classPathCollection : classPathCollections) {
                    this.additionalClassRepositories.addAll(classPathCollection);
                }
                return this;
            }

            @SafeVarargs
            public final Config addClassRepository(String ... classPaths) {
                return this.addClassRepositories(Arrays.asList(classPaths));
            }

            @SafeVarargs
            public final Config setBlackListedClassPaths(Collection<String> ... classPathCollections) {
                if (this.blackListedClassPaths == null) {
                    this.blackListedClassPaths = new HashSet<String>();
                }
                for (Collection<String> classPathCollection : classPathCollections) {
                    this.blackListedClassPaths.addAll(classPathCollection);
                }
                return this;
            }

            @SafeVarargs
            public final Config setBlackListedClassPaths(String ... classPaths) {
                return this.setBlackListedClassPaths(Arrays.asList(classPaths));
            }

            @SafeVarargs
            public final Config addBlackListedClassPaths(Collection<String> ... classPathCollections) {
                if (this.additionalBlackListedClassPaths == null) {
                    this.additionalBlackListedClassPaths = new HashSet<String>();
                }
                for (Collection<String> classPathCollection : classPathCollections) {
                    this.additionalBlackListedClassPaths.addAll(classPathCollection);
                }
                return this;
            }

            @SafeVarargs
            public final Config addBlackListedClassPaths(String ... classPaths) {
                return this.addBlackListedClassPaths(Arrays.asList(classPaths));
            }

            Collection<String> getSources() {
                return this.sources;
            }

            Collection<String> getClassPaths() {
                return this.classPaths;
            }

            Collection<String> getAdditionalClassPaths() {
                return this.additionalClassPaths;
            }

            Collection<String> getClassRepositories() {
                return this.classRepositories;
            }

            Collection<String> getAdditionalClassRepositories() {
                return this.additionalClassRepositories;
            }

            Collection<String> getBlackListedClassPaths() {
                return this.blackListedClassPaths;
            }

            Collection<String> getAdditionalBlackListedClassPaths() {
                return this.additionalBlackListedClassPaths;
            }

            boolean isStoringCompiledClassesEnabled() {
                return this.compiledClassesStorage != null;
            }

            String getCompiledClassesStorage() {
                return this.compiledClassesStorage;
            }

            boolean useTemporaryFolderForStoring() {
                return this.useTemporaryFolderForStoring;
            }

            Map<String, String> getExtraParameters() {
                return this.extraParameters;
            }
        }
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            defaultValues.put(Key.CLASS_PATHS, PathHelper.Configuration.Key.MAIN_CLASS_PATHS_PLACE_HOLDER + PathHelper.Configuration.getPathsSeparator() + "${" + PathHelper.Configuration.Key.MAIN_CLASS_PATHS_EXTENSION + "}" + PathHelper.Configuration.getPathsSeparator() + "${" + Key.ADDITIONAL_CLASS_PATHS + "}");
            defaultValues.put(Key.CLASS_REPOSITORIES, "${" + PathHelper.Configuration.Key.MAIN_CLASS_REPOSITORIES + "}" + PathHelper.Configuration.getPathsSeparator() + "${" + Key.ADDITIONAL_CLASS_REPOSITORIES + "}" + PathHelper.Configuration.getPathsSeparator());
            defaultValues.put(Key.BLACK_LISTED_CLASS_PATHS, "//${paths.main-class-paths}/..//children:.*?surefirebooter\\d{0,}\\.jar;");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            public static final String CLASS_PATHS = PathHelper.Configuration.Key.PATHS_PREFIX + "java-memory-compiler.class-paths";
            public static final String BLACK_LISTED_CLASS_PATHS = PathHelper.Configuration.Key.PATHS_PREFIX + "java-memory-compiler.black-listed-class-paths";
            public static final String ADDITIONAL_CLASS_PATHS = PathHelper.Configuration.Key.PATHS_PREFIX + "java-memory-compiler.additional-class-paths";
            public static final String CLASS_REPOSITORIES = PathHelper.Configuration.Key.PATHS_PREFIX + "java-memory-compiler.class-repositories";
            public static final String ADDITIONAL_CLASS_REPOSITORIES = PathHelper.Configuration.Key.PATHS_PREFIX + "java-memory-compiler.additional-class-repositories";
        }
    }
}

